/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import com.rockset.client.model.Privilege;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Role {
    @SerializedName(value="created_at")
    private String createdAt = null;
    @SerializedName(value="created_by")
    private String createdBy = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="owner_email")
    private String ownerEmail = null;
    @SerializedName(value="privileges")
    private List<Privilege> privileges = null;
    @SerializedName(value="role_name")
    private String roleName = null;

    public Role createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @JsonProperty(value="created_at")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="ISO-8601 date of when the role was created.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public Role createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty(value="created_by")
    @ApiModelProperty(example="hello@rockset.com", value="Email of the user who created the role.")
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Role description(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="description")
    @ApiModelProperty(example="Role with read and write privileges to all collections.", value="Description for the role.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Role ownerEmail(String ownerEmail) {
        this.ownerEmail = ownerEmail;
        return this;
    }

    @JsonProperty(value="owner_email")
    @ApiModelProperty(example="hello@rockset.com", value="Email of the user who currently owns the role.")
    public String getOwnerEmail() {
        return this.ownerEmail;
    }

    public void setOwnerEmail(String ownerEmail) {
        this.ownerEmail = ownerEmail;
    }

    public Role privileges(List<Privilege> privileges) {
        this.privileges = privileges;
        return this;
    }

    public Role addPrivilegesItem(Privilege privilegesItem) {
        if (this.privileges == null) {
            this.privileges = new ArrayList<Privilege>();
        }
        this.privileges.add(privilegesItem);
        return this;
    }

    @JsonProperty(value="privileges")
    @ApiModelProperty(value="List of privileges associated with the role.")
    public List<Privilege> getPrivileges() {
        return this.privileges;
    }

    public void setPrivileges(List<Privilege> privileges) {
        this.privileges = privileges;
    }

    public Role roleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    @JsonProperty(value="role_name")
    @ApiModelProperty(example="read_write", value="Unique identifier for the role.")
    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Role role = (Role)o;
        return Objects.equals(this.createdAt, role.createdAt) && Objects.equals(this.createdBy, role.createdBy) && Objects.equals(this.description, role.description) && Objects.equals(this.ownerEmail, role.ownerEmail) && Objects.equals(this.privileges, role.privileges) && Objects.equals(this.roleName, role.roleName);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.createdBy, this.description, this.ownerEmail, this.privileges, this.roleName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Role {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    ownerEmail: ").append(this.toIndentedString(this.ownerEmail)).append("\n");
        sb.append("    privileges: ").append(this.toIndentedString(this.privileges)).append("\n");
        sb.append("    roleName: ").append(this.toIndentedString(this.roleName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

