/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class RpcSinkStats {
    @SerializedName(value="worker")
    private String worker = null;
    @SerializedName(value="fragment")
    private Long fragment = null;
    @SerializedName(value="task")
    private String task = null;
    @SerializedName(value="operator_id")
    private Long operatorId = null;
    @SerializedName(value="src_operator_name")
    private String srcOperatorName = null;
    @SerializedName(value="input_bytes")
    private Long inputBytes = null;
    @SerializedName(value="max_input_bytes")
    private Long maxInputBytes = null;
    @SerializedName(value="input_rows")
    private Long inputRows = null;
    @SerializedName(value="input_data_chunks")
    private Long inputDataChunks = null;
    @SerializedName(value="output_data_chunks")
    private Long outputDataChunks = null;
    @SerializedName(value="output_messages")
    private Long outputMessages = null;
    @SerializedName(value="processing_time_us")
    private Long processingTimeUs = null;

    public RpcSinkStats worker(String worker) {
        this.worker = worker;
        return this;
    }

    @JsonProperty(value="worker")
    @ApiModelProperty(example="aggregator", value="The id of the worker this operator ran on")
    public String getWorker() {
        return this.worker;
    }

    public void setWorker(String worker) {
        this.worker = worker;
    }

    public RpcSinkStats fragment(Long fragment) {
        this.fragment = fragment;
        return this;
    }

    @JsonProperty(value="fragment")
    @ApiModelProperty(example="13", value="The id of the fragment this operator belonged to")
    public Long getFragment() {
        return this.fragment;
    }

    public void setFragment(Long fragment) {
        this.fragment = fragment;
    }

    public RpcSinkStats task(String task) {
        this.task = task;
        return this;
    }

    @JsonProperty(value="task")
    @ApiModelProperty(example="2", value="The id of the task this operator belonged to")
    public String getTask() {
        return this.task;
    }

    public void setTask(String task) {
        this.task = task;
    }

    public RpcSinkStats operatorId(Long operatorId) {
        this.operatorId = operatorId;
        return this;
    }

    @JsonProperty(value="operator_id")
    @ApiModelProperty(example="3", value="The id of this operator in the task")
    public Long getOperatorId() {
        return this.operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public RpcSinkStats srcOperatorName(String srcOperatorName) {
        this.srcOperatorName = srcOperatorName;
        return this;
    }

    @JsonProperty(value="src_operator_name")
    @ApiModelProperty(example="AllGather", value="The class name of upstream operator")
    public String getSrcOperatorName() {
        return this.srcOperatorName;
    }

    public void setSrcOperatorName(String srcOperatorName) {
        this.srcOperatorName = srcOperatorName;
    }

    public RpcSinkStats inputBytes(Long inputBytes) {
        this.inputBytes = inputBytes;
        return this;
    }

    @JsonProperty(value="input_bytes")
    @ApiModelProperty(example="48004800", value="Total bytes received from the input")
    public Long getInputBytes() {
        return this.inputBytes;
    }

    public void setInputBytes(Long inputBytes) {
        this.inputBytes = inputBytes;
    }

    public RpcSinkStats maxInputBytes(Long maxInputBytes) {
        this.maxInputBytes = maxInputBytes;
        return this;
    }

    @JsonProperty(value="max_input_bytes")
    @ApiModelProperty(example="48004800", value="Maximum bytes received in one data chunk")
    public Long getMaxInputBytes() {
        return this.maxInputBytes;
    }

    public void setMaxInputBytes(Long maxInputBytes) {
        this.maxInputBytes = maxInputBytes;
    }

    public RpcSinkStats inputRows(Long inputRows) {
        this.inputRows = inputRows;
        return this;
    }

    @JsonProperty(value="input_rows")
    @ApiModelProperty(example="1000100", value="Total rows received from the input")
    public Long getInputRows() {
        return this.inputRows;
    }

    public void setInputRows(Long inputRows) {
        this.inputRows = inputRows;
    }

    public RpcSinkStats inputDataChunks(Long inputDataChunks) {
        this.inputDataChunks = inputDataChunks;
        return this;
    }

    @JsonProperty(value="input_data_chunks")
    @ApiModelProperty(example="1000100", value="Total data chunks received from the input")
    public Long getInputDataChunks() {
        return this.inputDataChunks;
    }

    public void setInputDataChunks(Long inputDataChunks) {
        this.inputDataChunks = inputDataChunks;
    }

    public RpcSinkStats outputDataChunks(Long outputDataChunks) {
        this.outputDataChunks = outputDataChunks;
        return this;
    }

    @JsonProperty(value="output_data_chunks")
    @ApiModelProperty(example="1000100", value="Total data chunks sent to the output")
    public Long getOutputDataChunks() {
        return this.outputDataChunks;
    }

    public void setOutputDataChunks(Long outputDataChunks) {
        this.outputDataChunks = outputDataChunks;
    }

    public RpcSinkStats outputMessages(Long outputMessages) {
        this.outputMessages = outputMessages;
        return this;
    }

    @JsonProperty(value="output_messages")
    @ApiModelProperty(example="1000100", value="Total messages sent to the output")
    public Long getOutputMessages() {
        return this.outputMessages;
    }

    public void setOutputMessages(Long outputMessages) {
        this.outputMessages = outputMessages;
    }

    public RpcSinkStats processingTimeUs(Long processingTimeUs) {
        this.processingTimeUs = processingTimeUs;
        return this;
    }

    @JsonProperty(value="processing_time_us")
    @ApiModelProperty(example="2500", value="Total time in microseconds spent doing useful work")
    public Long getProcessingTimeUs() {
        return this.processingTimeUs;
    }

    public void setProcessingTimeUs(Long processingTimeUs) {
        this.processingTimeUs = processingTimeUs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RpcSinkStats rpcSinkStats = (RpcSinkStats)o;
        return Objects.equals(this.worker, rpcSinkStats.worker) && Objects.equals(this.fragment, rpcSinkStats.fragment) && Objects.equals(this.task, rpcSinkStats.task) && Objects.equals(this.operatorId, rpcSinkStats.operatorId) && Objects.equals(this.srcOperatorName, rpcSinkStats.srcOperatorName) && Objects.equals(this.inputBytes, rpcSinkStats.inputBytes) && Objects.equals(this.maxInputBytes, rpcSinkStats.maxInputBytes) && Objects.equals(this.inputRows, rpcSinkStats.inputRows) && Objects.equals(this.inputDataChunks, rpcSinkStats.inputDataChunks) && Objects.equals(this.outputDataChunks, rpcSinkStats.outputDataChunks) && Objects.equals(this.outputMessages, rpcSinkStats.outputMessages) && Objects.equals(this.processingTimeUs, rpcSinkStats.processingTimeUs);
    }

    public int hashCode() {
        return Objects.hash(this.worker, this.fragment, this.task, this.operatorId, this.srcOperatorName, this.inputBytes, this.maxInputBytes, this.inputRows, this.inputDataChunks, this.outputDataChunks, this.outputMessages, this.processingTimeUs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RpcSinkStats {\n");
        sb.append("    worker: ").append(this.toIndentedString(this.worker)).append("\n");
        sb.append("    fragment: ").append(this.toIndentedString(this.fragment)).append("\n");
        sb.append("    task: ").append(this.toIndentedString(this.task)).append("\n");
        sb.append("    operatorId: ").append(this.toIndentedString(this.operatorId)).append("\n");
        sb.append("    srcOperatorName: ").append(this.toIndentedString(this.srcOperatorName)).append("\n");
        sb.append("    inputBytes: ").append(this.toIndentedString(this.inputBytes)).append("\n");
        sb.append("    maxInputBytes: ").append(this.toIndentedString(this.maxInputBytes)).append("\n");
        sb.append("    inputRows: ").append(this.toIndentedString(this.inputRows)).append("\n");
        sb.append("    inputDataChunks: ").append(this.toIndentedString(this.inputDataChunks)).append("\n");
        sb.append("    outputDataChunks: ").append(this.toIndentedString(this.outputDataChunks)).append("\n");
        sb.append("    outputMessages: ").append(this.toIndentedString(this.outputMessages)).append("\n");
        sb.append("    processingTimeUs: ").append(this.toIndentedString(this.processingTimeUs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

