/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.rockset.client.model.SavedQueryParameter;
import com.rockset.client.model.SavedQueryStats;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SavedQuery {
    @SerializedName(value="workspace")
    private String workspace = null;
    @SerializedName(value="created_by")
    private String createdBy = null;
    @SerializedName(value="created_at")
    private String createdAt = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="version")
    private Integer version = null;
    @SerializedName(value="version_tag")
    private String versionTag = null;
    @SerializedName(value="query_sql")
    private String querySql = null;
    @SerializedName(value="collections")
    private List<String> collections = null;
    @SerializedName(value="parameters")
    private List<SavedQueryParameter> parameters = null;
    @SerializedName(value="state")
    private StateEnum state = null;
    @SerializedName(value="stats")
    private SavedQueryStats stats = null;

    public SavedQuery workspace(String workspace) {
        this.workspace = workspace;
        return this;
    }

    @JsonProperty(value="workspace")
    @ApiModelProperty(example="commons", value="workspace of this saved query")
    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public SavedQuery createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty(value="created_by")
    @ApiModelProperty(example="..@rockset.com", value="user that created this query")
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public SavedQuery createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @JsonProperty(value="created_at")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="ISO-8601 date of when saved query was created")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public SavedQuery name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @ApiModelProperty(example="myQuery", value="query name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SavedQuery version(Integer version) {
        this.version = version;
        return this;
    }

    @JsonProperty(value="version")
    @ApiModelProperty(example="1", value="query version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public SavedQuery versionTag(String versionTag) {
        this.versionTag = versionTag;
        return this;
    }

    @JsonProperty(value="version_tag")
    @ApiModelProperty(example="production version foo", value="optional version tag")
    public String getVersionTag() {
        return this.versionTag;
    }

    public void setVersionTag(String versionTag) {
        this.versionTag = versionTag;
    }

    public SavedQuery querySql(String querySql) {
        this.querySql = querySql;
        return this;
    }

    @JsonProperty(value="query_sql")
    @ApiModelProperty(example="SELECT 'Foo'", value="SQL text of this query")
    public String getQuerySql() {
        return this.querySql;
    }

    public void setQuerySql(String querySql) {
        this.querySql = querySql;
    }

    public SavedQuery collections(List<String> collections) {
        this.collections = collections;
        return this;
    }

    public SavedQuery addCollectionsItem(String collectionsItem) {
        if (this.collections == null) {
            this.collections = new ArrayList<String>();
        }
        this.collections.add(collectionsItem);
        return this;
    }

    @JsonProperty(value="collections")
    @ApiModelProperty(value="collections queried by this query")
    public List<String> getCollections() {
        return this.collections;
    }

    public void setCollections(List<String> collections) {
        this.collections = collections;
    }

    public SavedQuery parameters(List<SavedQueryParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public SavedQuery addParametersItem(SavedQueryParameter parametersItem) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<SavedQueryParameter>();
        }
        this.parameters.add(parametersItem);
        return this;
    }

    @JsonProperty(value="parameters")
    @ApiModelProperty(value="parameters associated with this query")
    public List<SavedQueryParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<SavedQueryParameter> parameters) {
        this.parameters = parameters;
    }

    public SavedQuery state(StateEnum state) {
        this.state = state;
        return this;
    }

    @JsonProperty(value="state")
    @ApiModelProperty(example="ACTIVE", value="status of this query")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public SavedQuery stats(SavedQueryStats stats) {
        this.stats = stats;
        return this;
    }

    @JsonProperty(value="stats")
    @ApiModelProperty(value="stats related to this query")
    public SavedQueryStats getStats() {
        return this.stats;
    }

    public void setStats(SavedQueryStats stats) {
        this.stats = stats;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SavedQuery savedQuery = (SavedQuery)o;
        return Objects.equals(this.workspace, savedQuery.workspace) && Objects.equals(this.createdBy, savedQuery.createdBy) && Objects.equals(this.createdAt, savedQuery.createdAt) && Objects.equals(this.name, savedQuery.name) && Objects.equals(this.version, savedQuery.version) && Objects.equals(this.versionTag, savedQuery.versionTag) && Objects.equals(this.querySql, savedQuery.querySql) && Objects.equals(this.collections, savedQuery.collections) && Objects.equals(this.parameters, savedQuery.parameters) && Objects.equals((Object)this.state, (Object)savedQuery.state) && Objects.equals(this.stats, savedQuery.stats);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.workspace, this.createdBy, this.createdAt, this.name, this.version, this.versionTag, this.querySql, this.collections, this.parameters, this.state, this.stats});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SavedQuery {\n");
        sb.append("    workspace: ").append(this.toIndentedString(this.workspace)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    versionTag: ").append(this.toIndentedString(this.versionTag)).append("\n");
        sb.append("    querySql: ").append(this.toIndentedString(this.querySql)).append("\n");
        sb.append("    collections: ").append(this.toIndentedString(this.collections)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    stats: ").append(this.toIndentedString(this.stats)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        ACTIVE("ACTIVE"),
        ARCHIVED("ARCHIVED");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String text) {
            for (StateEnum b : StateEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

