/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import com.rockset.client.model.ExecutionStatus;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class ScheduledLambda {
    @SerializedName(value="cron_string")
    private String cronString = null;
    @SerializedName(value="execution_count")
    private Long executionCount = null;
    @SerializedName(value="last_completion_date")
    private String lastCompletionDate = null;
    @SerializedName(value="last_query_id")
    private String lastQueryId = null;
    @SerializedName(value="next_execution_date")
    private String nextExecutionDate = null;
    @SerializedName(value="ql_name")
    private String qlName = null;
    @SerializedName(value="query_execution_status")
    private ExecutionStatus queryExecutionStatus = null;
    @SerializedName(value="resume_permanent_error")
    private Boolean resumePermanentError = null;
    @SerializedName(value="rrn")
    private String rrn = null;
    @SerializedName(value="tag")
    private String tag = null;
    @SerializedName(value="total_times_to_execute")
    private Long totalTimesToExecute = null;
    @SerializedName(value="version")
    private String version = null;
    @SerializedName(value="webhook_payload")
    private String webhookPayload = null;
    @SerializedName(value="webhook_url")
    private String webhookUrl = null;
    @SerializedName(value="workspace")
    private String workspace = null;

    public ScheduledLambda cronString(String cronString) {
        this.cronString = cronString;
        return this;
    }

    @JsonProperty(value="cron_string")
    @ApiModelProperty(example="* * * * *", value="The UNIX-formatted cron string for this scheduled query lambda.")
    public String getCronString() {
        return this.cronString;
    }

    public void setCronString(String cronString) {
        this.cronString = cronString;
    }

    public ScheduledLambda executionCount(Long executionCount) {
        this.executionCount = executionCount;
        return this;
    }

    @JsonProperty(value="execution_count")
    @ApiModelProperty(example="5", value="The number of times this scheduled QL has been executed.")
    public Long getExecutionCount() {
        return this.executionCount;
    }

    public void setExecutionCount(Long executionCount) {
        this.executionCount = executionCount;
    }

    public ScheduledLambda lastCompletionDate(String lastCompletionDate) {
        this.lastCompletionDate = lastCompletionDate;
        return this;
    }

    @JsonProperty(value="last_completion_date")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="The last time this scheduled query lambda completed successfully.")
    public String getLastCompletionDate() {
        return this.lastCompletionDate;
    }

    public void setLastCompletionDate(String lastCompletionDate) {
        this.lastCompletionDate = lastCompletionDate;
    }

    public ScheduledLambda lastQueryId(String lastQueryId) {
        this.lastQueryId = lastQueryId;
        return this;
    }

    @JsonProperty(value="last_query_id")
    @ApiModelProperty(example="salkdjfsd-1jakdsjfksaj", value="The ID of the query that was triggered by this scheduled lambda's last run.")
    public String getLastQueryId() {
        return this.lastQueryId;
    }

    public void setLastQueryId(String lastQueryId) {
        this.lastQueryId = lastQueryId;
    }

    public ScheduledLambda nextExecutionDate(String nextExecutionDate) {
        this.nextExecutionDate = nextExecutionDate;
        return this;
    }

    @JsonProperty(value="next_execution_date")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="The next time this scheduled query lambda will be executed.")
    public String getNextExecutionDate() {
        return this.nextExecutionDate;
    }

    public void setNextExecutionDate(String nextExecutionDate) {
        this.nextExecutionDate = nextExecutionDate;
    }

    public ScheduledLambda qlName(String qlName) {
        this.qlName = qlName;
        return this;
    }

    @JsonProperty(value="ql_name")
    @ApiModelProperty(example="example_ql", value="The name of the associated query lambda.")
    public String getQlName() {
        return this.qlName;
    }

    public void setQlName(String qlName) {
        this.qlName = qlName;
    }

    public ScheduledLambda queryExecutionStatus(ExecutionStatus queryExecutionStatus) {
        this.queryExecutionStatus = queryExecutionStatus;
        return this;
    }

    @JsonProperty(value="query_execution_status")
    @ApiModelProperty(value="Query execution status of the scheduled lambda. This field will only be populated when the query execution encounters a warning or error state.")
    public ExecutionStatus getQueryExecutionStatus() {
        return this.queryExecutionStatus;
    }

    public void setQueryExecutionStatus(ExecutionStatus queryExecutionStatus) {
        this.queryExecutionStatus = queryExecutionStatus;
    }

    public ScheduledLambda resumePermanentError(Boolean resumePermanentError) {
        this.resumePermanentError = resumePermanentError;
        return this;
    }

    @JsonProperty(value="resume_permanent_error")
    @ApiModelProperty(value="Boolean flag to allow a scheduled query lambda to resume execution after being suspended due to execution failure. This flag will be unset after scheduled lambda execution.")
    public Boolean isResumePermanentError() {
        return this.resumePermanentError;
    }

    public void setResumePermanentError(Boolean resumePermanentError) {
        this.resumePermanentError = resumePermanentError;
    }

    public ScheduledLambda rrn(String rrn) {
        this.rrn = rrn;
        return this;
    }

    @JsonProperty(value="rrn")
    @ApiModelProperty(example="rrn:sl:use1a1:123e4567-e89b-12d3-a456-556642440000", value="Scheduled Lambda mapping RRN.")
    public String getRrn() {
        return this.rrn;
    }

    public void setRrn(String rrn) {
        this.rrn = rrn;
    }

    public ScheduledLambda tag(String tag) {
        this.tag = tag;
        return this;
    }

    @JsonProperty(value="tag")
    @ApiModelProperty(example="production", value="The query lambda tag.")
    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public ScheduledLambda totalTimesToExecute(Long totalTimesToExecute) {
        this.totalTimesToExecute = totalTimesToExecute;
        return this;
    }

    @JsonProperty(value="total_times_to_execute")
    @ApiModelProperty(example="5", value="The number of times to execute this scheduled query lambda. Once this scheduled query lambda has been executed this many times, it will no longer be executed.")
    public Long getTotalTimesToExecute() {
        return this.totalTimesToExecute;
    }

    public void setTotalTimesToExecute(Long totalTimesToExecute) {
        this.totalTimesToExecute = totalTimesToExecute;
    }

    public ScheduledLambda version(String version) {
        this.version = version;
        return this;
    }

    @JsonProperty(value="version")
    @ApiModelProperty(example="abcde1234", value="The version of the associated query lambda.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ScheduledLambda webhookPayload(String webhookPayload) {
        this.webhookPayload = webhookPayload;
        return this;
    }

    @JsonProperty(value="webhook_payload")
    @ApiModelProperty(example="{\"text\": \"A scheduled query lambda completed execution. Query ID: {{QUERY_ID}}, Initial results: {{QUERY_RESULTS}}\"", value="The payload that should be sent to the webhook.")
    public String getWebhookPayload() {
        return this.webhookPayload;
    }

    public void setWebhookPayload(String webhookPayload) {
        this.webhookPayload = webhookPayload;
    }

    public ScheduledLambda webhookUrl(String webhookUrl) {
        this.webhookUrl = webhookUrl;
        return this;
    }

    @JsonProperty(value="webhook_url")
    @ApiModelProperty(example="https://hooks.slack.com/services/T00000000/B00000000/XXXXXXXXXXXXXXXXXXXXXXXX", value="The URL of the webhook that should be triggered after this scheduled query lambda completes.")
    public String getWebhookUrl() {
        return this.webhookUrl;
    }

    public void setWebhookUrl(String webhookUrl) {
        this.webhookUrl = webhookUrl;
    }

    public ScheduledLambda workspace(String workspace) {
        this.workspace = workspace;
        return this;
    }

    @JsonProperty(value="workspace")
    @ApiModelProperty(example="commons", value="Workspace of the associated query lambda.")
    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduledLambda scheduledLambda = (ScheduledLambda)o;
        return Objects.equals(this.cronString, scheduledLambda.cronString) && Objects.equals(this.executionCount, scheduledLambda.executionCount) && Objects.equals(this.lastCompletionDate, scheduledLambda.lastCompletionDate) && Objects.equals(this.lastQueryId, scheduledLambda.lastQueryId) && Objects.equals(this.nextExecutionDate, scheduledLambda.nextExecutionDate) && Objects.equals(this.qlName, scheduledLambda.qlName) && Objects.equals(this.queryExecutionStatus, scheduledLambda.queryExecutionStatus) && Objects.equals(this.resumePermanentError, scheduledLambda.resumePermanentError) && Objects.equals(this.rrn, scheduledLambda.rrn) && Objects.equals(this.tag, scheduledLambda.tag) && Objects.equals(this.totalTimesToExecute, scheduledLambda.totalTimesToExecute) && Objects.equals(this.version, scheduledLambda.version) && Objects.equals(this.webhookPayload, scheduledLambda.webhookPayload) && Objects.equals(this.webhookUrl, scheduledLambda.webhookUrl) && Objects.equals(this.workspace, scheduledLambda.workspace);
    }

    public int hashCode() {
        return Objects.hash(this.cronString, this.executionCount, this.lastCompletionDate, this.lastQueryId, this.nextExecutionDate, this.qlName, this.queryExecutionStatus, this.resumePermanentError, this.rrn, this.tag, this.totalTimesToExecute, this.version, this.webhookPayload, this.webhookUrl, this.workspace);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScheduledLambda {\n");
        sb.append("    cronString: ").append(this.toIndentedString(this.cronString)).append("\n");
        sb.append("    executionCount: ").append(this.toIndentedString(this.executionCount)).append("\n");
        sb.append("    lastCompletionDate: ").append(this.toIndentedString(this.lastCompletionDate)).append("\n");
        sb.append("    lastQueryId: ").append(this.toIndentedString(this.lastQueryId)).append("\n");
        sb.append("    nextExecutionDate: ").append(this.toIndentedString(this.nextExecutionDate)).append("\n");
        sb.append("    qlName: ").append(this.toIndentedString(this.qlName)).append("\n");
        sb.append("    queryExecutionStatus: ").append(this.toIndentedString(this.queryExecutionStatus)).append("\n");
        sb.append("    resumePermanentError: ").append(this.toIndentedString(this.resumePermanentError)).append("\n");
        sb.append("    rrn: ").append(this.toIndentedString(this.rrn)).append("\n");
        sb.append("    tag: ").append(this.toIndentedString(this.tag)).append("\n");
        sb.append("    totalTimesToExecute: ").append(this.toIndentedString(this.totalTimesToExecute)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    webhookPayload: ").append(this.toIndentedString(this.webhookPayload)).append("\n");
        sb.append("    webhookUrl: ").append(this.toIndentedString(this.webhookUrl)).append("\n");
        sb.append("    workspace: ").append(this.toIndentedString(this.workspace)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

