/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import com.rockset.client.model.AwsAccessKey;
import com.rockset.client.model.AwsRole;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class SnowflakeIntegration {
    @SerializedName(value="aws_access_key")
    private AwsAccessKey awsAccessKey = null;
    @SerializedName(value="aws_role")
    private AwsRole awsRole = null;
    @SerializedName(value="default_warehouse")
    private String defaultWarehouse = null;
    @SerializedName(value="password")
    private String password = null;
    @SerializedName(value="s3_export_path")
    private String s3ExportPath = null;
    @SerializedName(value="snowflake_url")
    private String snowflakeUrl = null;
    @SerializedName(value="user_role")
    private String userRole = null;
    @SerializedName(value="username")
    private String username = null;

    public SnowflakeIntegration awsAccessKey(AwsAccessKey awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
        return this;
    }

    @JsonProperty(value="aws_access_key")
    @ApiModelProperty(value="Credentials for an AWS access key integration.")
    public AwsAccessKey getAwsAccessKey() {
        return this.awsAccessKey;
    }

    public void setAwsAccessKey(AwsAccessKey awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
    }

    public SnowflakeIntegration awsRole(AwsRole awsRole) {
        this.awsRole = awsRole;
        return this;
    }

    @JsonProperty(value="aws_role")
    @ApiModelProperty(value="Details of an AWS cross-account role integration.")
    public AwsRole getAwsRole() {
        return this.awsRole;
    }

    public void setAwsRole(AwsRole awsRole) {
        this.awsRole = awsRole;
    }

    public SnowflakeIntegration defaultWarehouse(String defaultWarehouse) {
        this.defaultWarehouse = defaultWarehouse;
        return this;
    }

    @JsonProperty(value="default_warehouse")
    @ApiModelProperty(required=true, value="default snowflake data warehouse name for query execution. Warehouse name can be overridden in the collection.")
    public String getDefaultWarehouse() {
        return this.defaultWarehouse;
    }

    public void setDefaultWarehouse(String defaultWarehouse) {
        this.defaultWarehouse = defaultWarehouse;
    }

    public SnowflakeIntegration password(String password) {
        this.password = password;
        return this;
    }

    @JsonProperty(value="password")
    @ApiModelProperty(required=true, value="Snowflake database password.")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public SnowflakeIntegration s3ExportPath(String s3ExportPath) {
        this.s3ExportPath = s3ExportPath;
        return this;
    }

    @JsonProperty(value="s3_export_path")
    @ApiModelProperty(example="s3://bucket/prefix", required=true, value="S3 path used for running 'COPY INTO' command on snowflake table.")
    public String getS3ExportPath() {
        return this.s3ExportPath;
    }

    public void setS3ExportPath(String s3ExportPath) {
        this.s3ExportPath = s3ExportPath;
    }

    public SnowflakeIntegration snowflakeUrl(String snowflakeUrl) {
        this.snowflakeUrl = snowflakeUrl;
        return this;
    }

    @JsonProperty(value="snowflake_url")
    @ApiModelProperty(example="acme-marketing-test-account.snowflakecomputing.com", required=true, value="Snowflake browser url.")
    public String getSnowflakeUrl() {
        return this.snowflakeUrl;
    }

    public void setSnowflakeUrl(String snowflakeUrl) {
        this.snowflakeUrl = snowflakeUrl;
    }

    public SnowflakeIntegration userRole(String userRole) {
        this.userRole = userRole;
        return this;
    }

    @JsonProperty(value="user_role")
    @ApiModelProperty(value="Snowflake user role. If unspecified, will use the default user role.")
    public String getUserRole() {
        return this.userRole;
    }

    public void setUserRole(String userRole) {
        this.userRole = userRole;
    }

    public SnowflakeIntegration username(String username) {
        this.username = username;
        return this;
    }

    @JsonProperty(value="username")
    @ApiModelProperty(required=true, value="Snowflake database username.")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnowflakeIntegration snowflakeIntegration = (SnowflakeIntegration)o;
        return Objects.equals(this.awsAccessKey, snowflakeIntegration.awsAccessKey) && Objects.equals(this.awsRole, snowflakeIntegration.awsRole) && Objects.equals(this.defaultWarehouse, snowflakeIntegration.defaultWarehouse) && Objects.equals(this.password, snowflakeIntegration.password) && Objects.equals(this.s3ExportPath, snowflakeIntegration.s3ExportPath) && Objects.equals(this.snowflakeUrl, snowflakeIntegration.snowflakeUrl) && Objects.equals(this.userRole, snowflakeIntegration.userRole) && Objects.equals(this.username, snowflakeIntegration.username);
    }

    public int hashCode() {
        return Objects.hash(this.awsAccessKey, this.awsRole, this.defaultWarehouse, this.password, this.s3ExportPath, this.snowflakeUrl, this.userRole, this.username);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SnowflakeIntegration {\n");
        sb.append("    awsAccessKey: ").append(this.toIndentedString(this.awsAccessKey)).append("\n");
        sb.append("    awsRole: ").append(this.toIndentedString(this.awsRole)).append("\n");
        sb.append("    defaultWarehouse: ").append(this.toIndentedString(this.defaultWarehouse)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    s3ExportPath: ").append(this.toIndentedString(this.s3ExportPath)).append("\n");
        sb.append("    snowflakeUrl: ").append(this.toIndentedString(this.snowflakeUrl)).append("\n");
        sb.append("    userRole: ").append(this.toIndentedString(this.userRole)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

