/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import com.rockset.client.model.FieldMappingQuery;
import com.rockset.client.model.FormatParams;
import com.rockset.client.model.SourceAzureBlobStorage;
import com.rockset.client.model.SourceAzureEventHubs;
import com.rockset.client.model.SourceAzureServiceBus;
import com.rockset.client.model.SourceDynamoDb;
import com.rockset.client.model.SourceFileUpload;
import com.rockset.client.model.SourceGcs;
import com.rockset.client.model.SourceKafka;
import com.rockset.client.model.SourceKinesis;
import com.rockset.client.model.SourceMongoDb;
import com.rockset.client.model.SourceS3;
import com.rockset.client.model.SourceSnapshot;
import com.rockset.client.model.SourceSnowflake;
import com.rockset.client.model.SourceSystem;
import com.rockset.client.model.Status;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Details about the data source for the given collection. Only one of the following fields are allowed to be defined. Only collections can act as data sources for views. ")
public class Source {
    @SerializedName(value="azure_blob_storage")
    private SourceAzureBlobStorage azureBlobStorage = null;
    @SerializedName(value="azure_event_hubs")
    private SourceAzureEventHubs azureEventHubs = null;
    @SerializedName(value="azure_service_bus")
    private SourceAzureServiceBus azureServiceBus = null;
    @SerializedName(value="dynamodb")
    private SourceDynamoDb dynamodb = null;
    @SerializedName(value="file_upload")
    private SourceFileUpload fileUpload = null;
    @SerializedName(value="format_params")
    private FormatParams formatParams = null;
    @SerializedName(value="gcs")
    private SourceGcs gcs = null;
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="ingest_transformation")
    private FieldMappingQuery ingestTransformation = null;
    @SerializedName(value="integration_name")
    private String integrationName = null;
    @SerializedName(value="kafka")
    private SourceKafka kafka = null;
    @SerializedName(value="kinesis")
    private SourceKinesis kinesis = null;
    @SerializedName(value="mongodb")
    private SourceMongoDb mongodb = null;
    @SerializedName(value="resume_at")
    private String resumeAt = null;
    @SerializedName(value="s3")
    private SourceS3 s3 = null;
    @SerializedName(value="snapshot")
    private SourceSnapshot snapshot = null;
    @SerializedName(value="snowflake")
    private SourceSnowflake snowflake = null;
    @SerializedName(value="status")
    private Status status = null;
    @SerializedName(value="suspended_at")
    private String suspendedAt = null;
    @SerializedName(value="system")
    private SourceSystem system = null;

    public Source azureBlobStorage(SourceAzureBlobStorage azureBlobStorage) {
        this.azureBlobStorage = azureBlobStorage;
        return this;
    }

    @JsonProperty(value="azure_blob_storage")
    @ApiModelProperty(value="Configuration for ingestion from Azure Blob Storage.")
    public SourceAzureBlobStorage getAzureBlobStorage() {
        return this.azureBlobStorage;
    }

    public void setAzureBlobStorage(SourceAzureBlobStorage azureBlobStorage) {
        this.azureBlobStorage = azureBlobStorage;
    }

    public Source azureEventHubs(SourceAzureEventHubs azureEventHubs) {
        this.azureEventHubs = azureEventHubs;
        return this;
    }

    @JsonProperty(value="azure_event_hubs")
    @ApiModelProperty(value="Configuration for ingestion from Azure Event Hubs.")
    public SourceAzureEventHubs getAzureEventHubs() {
        return this.azureEventHubs;
    }

    public void setAzureEventHubs(SourceAzureEventHubs azureEventHubs) {
        this.azureEventHubs = azureEventHubs;
    }

    public Source azureServiceBus(SourceAzureServiceBus azureServiceBus) {
        this.azureServiceBus = azureServiceBus;
        return this;
    }

    @JsonProperty(value="azure_service_bus")
    @ApiModelProperty(value="")
    public SourceAzureServiceBus getAzureServiceBus() {
        return this.azureServiceBus;
    }

    public void setAzureServiceBus(SourceAzureServiceBus azureServiceBus) {
        this.azureServiceBus = azureServiceBus;
    }

    public Source dynamodb(SourceDynamoDb dynamodb) {
        this.dynamodb = dynamodb;
        return this;
    }

    @JsonProperty(value="dynamodb")
    @ApiModelProperty(value="Configuration for ingestion from  a dynamodb table.")
    public SourceDynamoDb getDynamodb() {
        return this.dynamodb;
    }

    public void setDynamodb(SourceDynamoDb dynamodb) {
        this.dynamodb = dynamodb;
    }

    @JsonProperty(value="file_upload")
    @ApiModelProperty(value="File upload details.")
    public SourceFileUpload getFileUpload() {
        return this.fileUpload;
    }

    public Source formatParams(FormatParams formatParams) {
        this.formatParams = formatParams;
        return this;
    }

    @JsonProperty(value="format_params")
    @ApiModelProperty(value="Format parameters for data from this source.")
    public FormatParams getFormatParams() {
        return this.formatParams;
    }

    public void setFormatParams(FormatParams formatParams) {
        this.formatParams = formatParams;
    }

    public Source gcs(SourceGcs gcs) {
        this.gcs = gcs;
        return this;
    }

    @JsonProperty(value="gcs")
    @ApiModelProperty(value="Configuration for ingestion from GCS.")
    public SourceGcs getGcs() {
        return this.gcs;
    }

    public void setGcs(SourceGcs gcs) {
        this.gcs = gcs;
    }

    @JsonProperty(value="id")
    @ApiModelProperty(example="a1df483c-734e-485b-8005-f46386ef42f6", value="Unique source identifier.")
    public String getId() {
        return this.id;
    }

    public Source ingestTransformation(FieldMappingQuery ingestTransformation) {
        this.ingestTransformation = ingestTransformation;
        return this;
    }

    @JsonProperty(value="ingest_transformation")
    @ApiModelProperty(value="Ingest transformation for a source.")
    public FieldMappingQuery getIngestTransformation() {
        return this.ingestTransformation;
    }

    public void setIngestTransformation(FieldMappingQuery ingestTransformation) {
        this.ingestTransformation = ingestTransformation;
    }

    public Source integrationName(String integrationName) {
        this.integrationName = integrationName;
        return this;
    }

    @JsonProperty(value="integration_name")
    @ApiModelProperty(example="aws-integration", value="Name of integration to use.")
    public String getIntegrationName() {
        return this.integrationName;
    }

    public void setIntegrationName(String integrationName) {
        this.integrationName = integrationName;
    }

    public Source kafka(SourceKafka kafka) {
        this.kafka = kafka;
        return this;
    }

    @JsonProperty(value="kafka")
    @ApiModelProperty(value="Kafka collection identifier.")
    public SourceKafka getKafka() {
        return this.kafka;
    }

    public void setKafka(SourceKafka kafka) {
        this.kafka = kafka;
    }

    public Source kinesis(SourceKinesis kinesis) {
        this.kinesis = kinesis;
        return this;
    }

    @JsonProperty(value="kinesis")
    @ApiModelProperty(value="Configuration for ingestion from kinesis stream.")
    public SourceKinesis getKinesis() {
        return this.kinesis;
    }

    public void setKinesis(SourceKinesis kinesis) {
        this.kinesis = kinesis;
    }

    public Source mongodb(SourceMongoDb mongodb) {
        this.mongodb = mongodb;
        return this;
    }

    @JsonProperty(value="mongodb")
    @ApiModelProperty(value="MongoDB collection details.")
    public SourceMongoDb getMongodb() {
        return this.mongodb;
    }

    public void setMongodb(SourceMongoDb mongodb) {
        this.mongodb = mongodb;
    }

    @JsonProperty(value="resume_at")
    @ApiModelProperty(example="2019-01-15T21:48:23Z", value="ISO-8601 date when source would be auto resumed, if suspended")
    public String getResumeAt() {
        return this.resumeAt;
    }

    public Source s3(SourceS3 s3) {
        this.s3 = s3;
        return this;
    }

    @JsonProperty(value="s3")
    @ApiModelProperty(value="Configuration for ingestion from S3.")
    public SourceS3 getS3() {
        return this.s3;
    }

    public void setS3(SourceS3 s3) {
        this.s3 = s3;
    }

    public Source snapshot(SourceSnapshot snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    @JsonProperty(value="snapshot")
    @ApiModelProperty(value="Configuration for restoring from snapshot.")
    public SourceSnapshot getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(SourceSnapshot snapshot) {
        this.snapshot = snapshot;
    }

    public Source snowflake(SourceSnowflake snowflake) {
        this.snowflake = snowflake;
        return this;
    }

    @JsonProperty(value="snowflake")
    @ApiModelProperty(value="Configuration for ingestion from Snowflake.")
    public SourceSnowflake getSnowflake() {
        return this.snowflake;
    }

    public void setSnowflake(SourceSnowflake snowflake) {
        this.snowflake = snowflake;
    }

    @JsonProperty(value="status")
    @ApiModelProperty(value="The ingest status of this source.")
    public Status getStatus() {
        return this.status;
    }

    @JsonProperty(value="suspended_at")
    @ApiModelProperty(example="2019-01-15T21:48:23Z", value="ISO-8601 date when source was suspended, if suspended")
    public String getSuspendedAt() {
        return this.suspendedAt;
    }

    public Source system(SourceSystem system) {
        this.system = system;
        return this;
    }

    @JsonProperty(value="system")
    @ApiModelProperty(value="")
    public SourceSystem getSystem() {
        return this.system;
    }

    public void setSystem(SourceSystem system) {
        this.system = system;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Source source = (Source)o;
        return Objects.equals(this.azureBlobStorage, source.azureBlobStorage) && Objects.equals(this.azureEventHubs, source.azureEventHubs) && Objects.equals(this.azureServiceBus, source.azureServiceBus) && Objects.equals(this.dynamodb, source.dynamodb) && Objects.equals(this.fileUpload, source.fileUpload) && Objects.equals(this.formatParams, source.formatParams) && Objects.equals(this.gcs, source.gcs) && Objects.equals(this.id, source.id) && Objects.equals(this.ingestTransformation, source.ingestTransformation) && Objects.equals(this.integrationName, source.integrationName) && Objects.equals(this.kafka, source.kafka) && Objects.equals(this.kinesis, source.kinesis) && Objects.equals(this.mongodb, source.mongodb) && Objects.equals(this.resumeAt, source.resumeAt) && Objects.equals(this.s3, source.s3) && Objects.equals(this.snapshot, source.snapshot) && Objects.equals(this.snowflake, source.snowflake) && Objects.equals(this.status, source.status) && Objects.equals(this.suspendedAt, source.suspendedAt) && Objects.equals(this.system, source.system);
    }

    public int hashCode() {
        return Objects.hash(this.azureBlobStorage, this.azureEventHubs, this.azureServiceBus, this.dynamodb, this.fileUpload, this.formatParams, this.gcs, this.id, this.ingestTransformation, this.integrationName, this.kafka, this.kinesis, this.mongodb, this.resumeAt, this.s3, this.snapshot, this.snowflake, this.status, this.suspendedAt, this.system);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Source {\n");
        sb.append("    azureBlobStorage: ").append(this.toIndentedString(this.azureBlobStorage)).append("\n");
        sb.append("    azureEventHubs: ").append(this.toIndentedString(this.azureEventHubs)).append("\n");
        sb.append("    azureServiceBus: ").append(this.toIndentedString(this.azureServiceBus)).append("\n");
        sb.append("    dynamodb: ").append(this.toIndentedString(this.dynamodb)).append("\n");
        sb.append("    fileUpload: ").append(this.toIndentedString(this.fileUpload)).append("\n");
        sb.append("    formatParams: ").append(this.toIndentedString(this.formatParams)).append("\n");
        sb.append("    gcs: ").append(this.toIndentedString(this.gcs)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    ingestTransformation: ").append(this.toIndentedString(this.ingestTransformation)).append("\n");
        sb.append("    integrationName: ").append(this.toIndentedString(this.integrationName)).append("\n");
        sb.append("    kafka: ").append(this.toIndentedString(this.kafka)).append("\n");
        sb.append("    kinesis: ").append(this.toIndentedString(this.kinesis)).append("\n");
        sb.append("    mongodb: ").append(this.toIndentedString(this.mongodb)).append("\n");
        sb.append("    resumeAt: ").append(this.toIndentedString(this.resumeAt)).append("\n");
        sb.append("    s3: ").append(this.toIndentedString(this.s3)).append("\n");
        sb.append("    snapshot: ").append(this.toIndentedString(this.snapshot)).append("\n");
        sb.append("    snowflake: ").append(this.toIndentedString(this.snowflake)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    suspendedAt: ").append(this.toIndentedString(this.suspendedAt)).append("\n");
        sb.append("    system: ").append(this.toIndentedString(this.system)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

