/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import com.rockset.client.model.SourceAzBlobStorageSettings;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class SourceAzureBlobStorage {
    @SerializedName(value="blob_bytes_total")
    private Long blobBytesTotal = null;
    @SerializedName(value="blob_count_downloaded")
    private Long blobCountDownloaded = null;
    @SerializedName(value="blob_count_total")
    private Long blobCountTotal = null;
    @SerializedName(value="container")
    private String container = null;
    @SerializedName(value="pattern")
    private String pattern = null;
    @SerializedName(value="prefix")
    private String prefix = null;
    @SerializedName(value="settings")
    private SourceAzBlobStorageSettings settings = null;

    @JsonProperty(value="blob_bytes_total")
    @ApiModelProperty(value="")
    public Long getBlobBytesTotal() {
        return this.blobBytesTotal;
    }

    @JsonProperty(value="blob_count_downloaded")
    @ApiModelProperty(value="")
    public Long getBlobCountDownloaded() {
        return this.blobCountDownloaded;
    }

    @JsonProperty(value="blob_count_total")
    @ApiModelProperty(value="")
    public Long getBlobCountTotal() {
        return this.blobCountTotal;
    }

    public SourceAzureBlobStorage container(String container) {
        this.container = container;
        return this;
    }

    @JsonProperty(value="container")
    @ApiModelProperty(example="server-logs", value="Name of Azure blob Storage container you want to ingest from.")
    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public SourceAzureBlobStorage pattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    @JsonProperty(value="pattern")
    @ApiModelProperty(example="prefix/to/_**_/keys/_*.format", value="Glob-style pattern that selects keys to ingest. Only either prefix or pattern can be specified.")
    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public SourceAzureBlobStorage prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @JsonProperty(value="prefix")
    @ApiModelProperty(example="prefix/to/blobs", value="Prefix that selects blobs to ingest.")
    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public SourceAzureBlobStorage settings(SourceAzBlobStorageSettings settings) {
        this.settings = settings;
        return this;
    }

    @JsonProperty(value="settings")
    @ApiModelProperty(value="custom settings for Azure blob Storage source")
    public SourceAzBlobStorageSettings getSettings() {
        return this.settings;
    }

    public void setSettings(SourceAzBlobStorageSettings settings) {
        this.settings = settings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceAzureBlobStorage sourceAzureBlobStorage = (SourceAzureBlobStorage)o;
        return Objects.equals(this.blobBytesTotal, sourceAzureBlobStorage.blobBytesTotal) && Objects.equals(this.blobCountDownloaded, sourceAzureBlobStorage.blobCountDownloaded) && Objects.equals(this.blobCountTotal, sourceAzureBlobStorage.blobCountTotal) && Objects.equals(this.container, sourceAzureBlobStorage.container) && Objects.equals(this.pattern, sourceAzureBlobStorage.pattern) && Objects.equals(this.prefix, sourceAzureBlobStorage.prefix) && Objects.equals(this.settings, sourceAzureBlobStorage.settings);
    }

    public int hashCode() {
        return Objects.hash(this.blobBytesTotal, this.blobCountDownloaded, this.blobCountTotal, this.container, this.pattern, this.prefix, this.settings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SourceAzureBlobStorage {\n");
        sb.append("    blobBytesTotal: ").append(this.toIndentedString(this.blobBytesTotal)).append("\n");
        sb.append("    blobCountDownloaded: ").append(this.toIndentedString(this.blobCountDownloaded)).append("\n");
        sb.append("    blobCountTotal: ").append(this.toIndentedString(this.blobCountTotal)).append("\n");
        sb.append("    container: ").append(this.toIndentedString(this.container)).append("\n");
        sb.append("    pattern: ").append(this.toIndentedString(this.pattern)).append("\n");
        sb.append("    prefix: ").append(this.toIndentedString(this.prefix)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

