/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.rockset.client.model.StatusAzureEventHubs;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class SourceAzureEventHubs {
    @SerializedName(value="hub_id")
    private String hubId = null;
    @SerializedName(value="offset_reset_policy")
    private OffsetResetPolicyEnum offsetResetPolicy = null;
    @SerializedName(value="status")
    private StatusAzureEventHubs status = null;

    public SourceAzureEventHubs hubId(String hubId) {
        this.hubId = hubId;
        return this;
    }

    @JsonProperty(value="hub_id")
    @ApiModelProperty(example="event-hub-1", value="Name of the hub which rockset should ingest from.")
    public String getHubId() {
        return this.hubId;
    }

    public void setHubId(String hubId) {
        this.hubId = hubId;
    }

    public SourceAzureEventHubs offsetResetPolicy(OffsetResetPolicyEnum offsetResetPolicy) {
        this.offsetResetPolicy = offsetResetPolicy;
        return this;
    }

    @JsonProperty(value="offset_reset_policy")
    @ApiModelProperty(example="EARLIEST", value="The offset reset policy.")
    public OffsetResetPolicyEnum getOffsetResetPolicy() {
        return this.offsetResetPolicy;
    }

    public void setOffsetResetPolicy(OffsetResetPolicyEnum offsetResetPolicy) {
        this.offsetResetPolicy = offsetResetPolicy;
    }

    @JsonProperty(value="status")
    @ApiModelProperty(value="Source status.")
    public StatusAzureEventHubs getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceAzureEventHubs sourceAzureEventHubs = (SourceAzureEventHubs)o;
        return Objects.equals(this.hubId, sourceAzureEventHubs.hubId) && Objects.equals((Object)this.offsetResetPolicy, (Object)sourceAzureEventHubs.offsetResetPolicy) && Objects.equals(this.status, sourceAzureEventHubs.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hubId, this.offsetResetPolicy, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SourceAzureEventHubs {\n");
        sb.append("    hubId: ").append(this.toIndentedString(this.hubId)).append("\n");
        sb.append("    offsetResetPolicy: ").append(this.toIndentedString((Object)this.offsetResetPolicy)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OffsetResetPolicyEnum {
        LATEST("LATEST"),
        EARLIEST("EARLIEST");

        private String value;

        private OffsetResetPolicyEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OffsetResetPolicyEnum fromValue(String text) {
            for (OffsetResetPolicyEnum b : OffsetResetPolicyEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<OffsetResetPolicyEnum> {
            public void write(JsonWriter jsonWriter, OffsetResetPolicyEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OffsetResetPolicyEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OffsetResetPolicyEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

