/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import com.rockset.client.model.SourceDynamoDbSettings;
import com.rockset.client.model.StatusDynamoDb;
import com.rockset.client.model.StatusDynamoDbV2;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class SourceDynamoDb {
    @SerializedName(value="aws_region")
    private String awsRegion = null;
    @SerializedName(value="current_status")
    private StatusDynamoDbV2 currentStatus = null;
    @SerializedName(value="rcu")
    private Long rcu = null;
    @SerializedName(value="settings")
    private SourceDynamoDbSettings settings = null;
    @SerializedName(value="status")
    private StatusDynamoDb status = null;
    @SerializedName(value="table_name")
    private String tableName = null;
    @SerializedName(value="use_scan_api")
    private Boolean useScanApi = null;

    public SourceDynamoDb awsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
        return this;
    }

    @JsonProperty(value="aws_region")
    @ApiModelProperty(example="us-east-2", value="AWS region name of DynamoDB table, by default us-west-2 is used.")
    public String getAwsRegion() {
        return this.awsRegion;
    }

    public void setAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
    }

    @JsonProperty(value="current_status")
    @ApiModelProperty(value="DynamoDB source status v2.")
    public StatusDynamoDbV2 getCurrentStatus() {
        return this.currentStatus;
    }

    public SourceDynamoDb rcu(Long rcu) {
        this.rcu = rcu;
        return this;
    }

    @JsonProperty(value="rcu")
    @ApiModelProperty(example="1000", value="Max RCU usage for scan.")
    public Long getRcu() {
        return this.rcu;
    }

    public void setRcu(Long rcu) {
        this.rcu = rcu;
    }

    public SourceDynamoDb settings(SourceDynamoDbSettings settings) {
        this.settings = settings;
        return this;
    }

    @JsonProperty(value="settings")
    @ApiModelProperty(value="custom settings for Amazon DynamoDB source")
    public SourceDynamoDbSettings getSettings() {
        return this.settings;
    }

    public void setSettings(SourceDynamoDbSettings settings) {
        this.settings = settings;
    }

    @JsonProperty(value="status")
    @ApiModelProperty(value="DynamoDB source status.")
    public StatusDynamoDb getStatus() {
        return this.status;
    }

    public SourceDynamoDb tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    @JsonProperty(value="table_name")
    @ApiModelProperty(example="dynamodb_table_name", required=true, value="Name of DynamoDB table containing data.")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public SourceDynamoDb useScanApi(Boolean useScanApi) {
        this.useScanApi = useScanApi;
        return this;
    }

    @JsonProperty(value="use_scan_api")
    @ApiModelProperty(value="Whether to use DynamoDB Scan API for the initial scan.")
    public Boolean isUseScanApi() {
        return this.useScanApi;
    }

    public void setUseScanApi(Boolean useScanApi) {
        this.useScanApi = useScanApi;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceDynamoDb sourceDynamoDb = (SourceDynamoDb)o;
        return Objects.equals(this.awsRegion, sourceDynamoDb.awsRegion) && Objects.equals(this.currentStatus, sourceDynamoDb.currentStatus) && Objects.equals(this.rcu, sourceDynamoDb.rcu) && Objects.equals(this.settings, sourceDynamoDb.settings) && Objects.equals(this.status, sourceDynamoDb.status) && Objects.equals(this.tableName, sourceDynamoDb.tableName) && Objects.equals(this.useScanApi, sourceDynamoDb.useScanApi);
    }

    public int hashCode() {
        return Objects.hash(this.awsRegion, this.currentStatus, this.rcu, this.settings, this.status, this.tableName, this.useScanApi);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SourceDynamoDb {\n");
        sb.append("    awsRegion: ").append(this.toIndentedString(this.awsRegion)).append("\n");
        sb.append("    currentStatus: ").append(this.toIndentedString(this.currentStatus)).append("\n");
        sb.append("    rcu: ").append(this.toIndentedString(this.rcu)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    tableName: ").append(this.toIndentedString(this.tableName)).append("\n");
        sb.append("    useScanApi: ").append(this.toIndentedString(this.useScanApi)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

