/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class SourceDynamoDbSettings {
    @SerializedName(value="dynamodb_stream_poll_frequency")
    private String dynamodbStreamPollFrequency = null;

    public SourceDynamoDbSettings dynamodbStreamPollFrequency(String dynamodbStreamPollFrequency) {
        this.dynamodbStreamPollFrequency = dynamodbStreamPollFrequency;
        return this;
    }

    @JsonProperty(value="dynamodb_stream_poll_frequency")
    @ApiModelProperty(example="PT1S", value="Each DynamoDB stream can have one to many shards, and Rockset polls each DynamoDB shard at a fixed rate. Decreasing the duration between polls helps reduce ingest latency, while increasing the duration can prevent  Rockset from keeping up with the updates. If the latency exceeds 24 hours (DynamoDB stream retention duration), Rockset will not be able to process all of the streaming updates. Each request also has a fixed price associated with it. Duration value is of type ISO 8601 (e.g. PT5H, PT4M, PT3S). It doesn't account for DST, leap seconds and leap years. Minimum value: PT0.25S. Maximum value: PT5M.")
    public String getDynamodbStreamPollFrequency() {
        return this.dynamodbStreamPollFrequency;
    }

    public void setDynamodbStreamPollFrequency(String dynamodbStreamPollFrequency) {
        this.dynamodbStreamPollFrequency = dynamodbStreamPollFrequency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceDynamoDbSettings sourceDynamoDbSettings = (SourceDynamoDbSettings)o;
        return Objects.equals(this.dynamodbStreamPollFrequency, sourceDynamoDbSettings.dynamodbStreamPollFrequency);
    }

    public int hashCode() {
        return Objects.hash(this.dynamodbStreamPollFrequency);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SourceDynamoDbSettings {\n");
        sb.append("    dynamodbStreamPollFrequency: ").append(this.toIndentedString(this.dynamodbStreamPollFrequency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

