/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import com.rockset.client.model.SourceGcsSettings;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class SourceGcs {
    @SerializedName(value="bucket")
    private String bucket = null;
    @SerializedName(value="object_bytes_downloaded")
    private Long objectBytesDownloaded = null;
    @SerializedName(value="object_bytes_total")
    private Long objectBytesTotal = null;
    @SerializedName(value="object_count_downloaded")
    private Long objectCountDownloaded = null;
    @SerializedName(value="object_count_total")
    private Long objectCountTotal = null;
    @SerializedName(value="pattern")
    private String pattern = null;
    @SerializedName(value="prefix")
    private String prefix = null;
    @SerializedName(value="settings")
    private SourceGcsSettings settings = null;

    public SourceGcs bucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    @JsonProperty(value="bucket")
    @ApiModelProperty(example="server-logs", value="Name of GCS bucket you want to ingest from.")
    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    @JsonProperty(value="object_bytes_downloaded")
    @ApiModelProperty(value="")
    public Long getObjectBytesDownloaded() {
        return this.objectBytesDownloaded;
    }

    @JsonProperty(value="object_bytes_total")
    @ApiModelProperty(value="")
    public Long getObjectBytesTotal() {
        return this.objectBytesTotal;
    }

    @JsonProperty(value="object_count_downloaded")
    @ApiModelProperty(value="")
    public Long getObjectCountDownloaded() {
        return this.objectCountDownloaded;
    }

    @JsonProperty(value="object_count_total")
    @ApiModelProperty(value="")
    public Long getObjectCountTotal() {
        return this.objectCountTotal;
    }

    public SourceGcs pattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    @JsonProperty(value="pattern")
    @ApiModelProperty(example="prefix/to/_**_/keys/_*.format", value="Glob-style pattern that selects keys to ingest. Only either prefix or pattern can be specified.")
    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public SourceGcs prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @JsonProperty(value="prefix")
    @ApiModelProperty(example="prefix/to/keys", value="Prefix that selects keys to ingest.")
    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public SourceGcs settings(SourceGcsSettings settings) {
        this.settings = settings;
        return this;
    }

    @JsonProperty(value="settings")
    @ApiModelProperty(value="custom settings for Google cloud Storage source")
    public SourceGcsSettings getSettings() {
        return this.settings;
    }

    public void setSettings(SourceGcsSettings settings) {
        this.settings = settings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceGcs sourceGcs = (SourceGcs)o;
        return Objects.equals(this.bucket, sourceGcs.bucket) && Objects.equals(this.objectBytesDownloaded, sourceGcs.objectBytesDownloaded) && Objects.equals(this.objectBytesTotal, sourceGcs.objectBytesTotal) && Objects.equals(this.objectCountDownloaded, sourceGcs.objectCountDownloaded) && Objects.equals(this.objectCountTotal, sourceGcs.objectCountTotal) && Objects.equals(this.pattern, sourceGcs.pattern) && Objects.equals(this.prefix, sourceGcs.prefix) && Objects.equals(this.settings, sourceGcs.settings);
    }

    public int hashCode() {
        return Objects.hash(this.bucket, this.objectBytesDownloaded, this.objectBytesTotal, this.objectCountDownloaded, this.objectCountTotal, this.pattern, this.prefix, this.settings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SourceGcs {\n");
        sb.append("    bucket: ").append(this.toIndentedString(this.bucket)).append("\n");
        sb.append("    objectBytesDownloaded: ").append(this.toIndentedString(this.objectBytesDownloaded)).append("\n");
        sb.append("    objectBytesTotal: ").append(this.toIndentedString(this.objectBytesTotal)).append("\n");
        sb.append("    objectCountDownloaded: ").append(this.toIndentedString(this.objectCountDownloaded)).append("\n");
        sb.append("    objectCountTotal: ").append(this.toIndentedString(this.objectCountTotal)).append("\n");
        sb.append("    pattern: ").append(this.toIndentedString(this.pattern)).append("\n");
        sb.append("    prefix: ").append(this.toIndentedString(this.prefix)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

