/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class SourceGcsSettings {
    @SerializedName(value="gcs_scan_frequency")
    private String gcsScanFrequency = null;

    public SourceGcsSettings gcsScanFrequency(String gcsScanFrequency) {
        this.gcsScanFrequency = gcsScanFrequency;
        return this;
    }

    @JsonProperty(value="gcs_scan_frequency")
    @ApiModelProperty(example="PT5M", value="Rockset scans a GCS bucket based on a defined time interval. The scan frequency determines the length of time between a new scan and the previous scan. If the previous scan finds new objects or updates to existing objects, Rockset immediately scans the bucket again after processing changes from the previous scan. Duration value is of type ISO 8601 (e.g. PT5H, PT4M, PT3S). It doesn't account for DST, leap seconds and leap years. Minimum value: PT1S. Maximum value: PT1H.")
    public String getGcsScanFrequency() {
        return this.gcsScanFrequency;
    }

    public void setGcsScanFrequency(String gcsScanFrequency) {
        this.gcsScanFrequency = gcsScanFrequency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceGcsSettings sourceGcsSettings = (SourceGcsSettings)o;
        return Objects.equals(this.gcsScanFrequency, sourceGcsSettings.gcsScanFrequency);
    }

    public int hashCode() {
        return Objects.hash(this.gcsScanFrequency);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SourceGcsSettings {\n");
        sb.append("    gcsScanFrequency: ").append(this.toIndentedString(this.gcsScanFrequency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

