/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.rockset.client.model.StatusKafka;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class SourceKafka {
    @SerializedName(value="client_id")
    private String clientId = null;
    @SerializedName(value="consumer_group_id")
    private String consumerGroupId = null;
    @SerializedName(value="kafka_topic_name")
    private String kafkaTopicName = null;
    @SerializedName(value="offset_reset_policy")
    private OffsetResetPolicyEnum offsetResetPolicy = null;
    @SerializedName(value="status")
    private StatusKafka status = null;
    @SerializedName(value="use_v3")
    private Boolean useV3 = null;

    public SourceKafka clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @JsonProperty(value="client_id")
    @ApiModelProperty(example="cwc|0013a00001hSJ7oAAG|rockset-colln-consumer", value="The kafka client id being used.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public SourceKafka consumerGroupId(String consumerGroupId) {
        this.consumerGroupId = consumerGroupId;
        return this;
    }

    @JsonProperty(value="consumer_group_id")
    @ApiModelProperty(example="org-collection", value="The Kafka consumer group Id being used.")
    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    public void setConsumerGroupId(String consumerGroupId) {
        this.consumerGroupId = consumerGroupId;
    }

    public SourceKafka kafkaTopicName(String kafkaTopicName) {
        this.kafkaTopicName = kafkaTopicName;
        return this;
    }

    @JsonProperty(value="kafka_topic_name")
    @ApiModelProperty(example="example-topic", value="The Kafka topic to be tailed.")
    public String getKafkaTopicName() {
        return this.kafkaTopicName;
    }

    public void setKafkaTopicName(String kafkaTopicName) {
        this.kafkaTopicName = kafkaTopicName;
    }

    public SourceKafka offsetResetPolicy(OffsetResetPolicyEnum offsetResetPolicy) {
        this.offsetResetPolicy = offsetResetPolicy;
        return this;
    }

    @JsonProperty(value="offset_reset_policy")
    @ApiModelProperty(example="EARLIEST", value="The offset reset policy.")
    public OffsetResetPolicyEnum getOffsetResetPolicy() {
        return this.offsetResetPolicy;
    }

    public void setOffsetResetPolicy(OffsetResetPolicyEnum offsetResetPolicy) {
        this.offsetResetPolicy = offsetResetPolicy;
    }

    @JsonProperty(value="status")
    @ApiModelProperty(value="Kafka source status.")
    public StatusKafka getStatus() {
        return this.status;
    }

    public SourceKafka useV3(Boolean useV3) {
        this.useV3 = useV3;
        return this;
    }

    @JsonProperty(value="use_v3")
    @ApiModelProperty(value="Whether to use v3 integration.")
    public Boolean isUseV3() {
        return this.useV3;
    }

    public void setUseV3(Boolean useV3) {
        this.useV3 = useV3;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceKafka sourceKafka = (SourceKafka)o;
        return Objects.equals(this.clientId, sourceKafka.clientId) && Objects.equals(this.consumerGroupId, sourceKafka.consumerGroupId) && Objects.equals(this.kafkaTopicName, sourceKafka.kafkaTopicName) && Objects.equals((Object)this.offsetResetPolicy, (Object)sourceKafka.offsetResetPolicy) && Objects.equals(this.status, sourceKafka.status) && Objects.equals(this.useV3, sourceKafka.useV3);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.consumerGroupId, this.kafkaTopicName, this.offsetResetPolicy, this.status, this.useV3});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SourceKafka {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    consumerGroupId: ").append(this.toIndentedString(this.consumerGroupId)).append("\n");
        sb.append("    kafkaTopicName: ").append(this.toIndentedString(this.kafkaTopicName)).append("\n");
        sb.append("    offsetResetPolicy: ").append(this.toIndentedString((Object)this.offsetResetPolicy)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    useV3: ").append(this.toIndentedString(this.useV3)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OffsetResetPolicyEnum {
        LATEST("LATEST"),
        EARLIEST("EARLIEST");

        private String value;

        private OffsetResetPolicyEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OffsetResetPolicyEnum fromValue(String text) {
            for (OffsetResetPolicyEnum b : OffsetResetPolicyEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<OffsetResetPolicyEnum> {
            public void write(JsonWriter jsonWriter, OffsetResetPolicyEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OffsetResetPolicyEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OffsetResetPolicyEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

