/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SourceKinesis {
    @SerializedName(value="aws_region")
    private String awsRegion = null;
    @SerializedName(value="dms_primary_key")
    private List<String> dmsPrimaryKey = null;
    @SerializedName(value="offset_reset_policy")
    private OffsetResetPolicyEnum offsetResetPolicy = null;
    @SerializedName(value="stream_name")
    private String streamName = null;

    public SourceKinesis awsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
        return this;
    }

    @JsonProperty(value="aws_region")
    @ApiModelProperty(example="us-east-2", value="AWS region name of Kinesis stream, by default us-west-2 is used.")
    public String getAwsRegion() {
        return this.awsRegion;
    }

    public void setAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
    }

    public SourceKinesis dmsPrimaryKey(List<String> dmsPrimaryKey) {
        this.dmsPrimaryKey = dmsPrimaryKey;
        return this;
    }

    public SourceKinesis addDmsPrimaryKeyItem(String dmsPrimaryKeyItem) {
        if (this.dmsPrimaryKey == null) {
            this.dmsPrimaryKey = new ArrayList<String>();
        }
        this.dmsPrimaryKey.add(dmsPrimaryKeyItem);
        return this;
    }

    @JsonProperty(value="dms_primary_key")
    @ApiModelProperty(value="Set of fields that correspond to a DMS primary key.")
    public List<String> getDmsPrimaryKey() {
        return this.dmsPrimaryKey;
    }

    public void setDmsPrimaryKey(List<String> dmsPrimaryKey) {
        this.dmsPrimaryKey = dmsPrimaryKey;
    }

    public SourceKinesis offsetResetPolicy(OffsetResetPolicyEnum offsetResetPolicy) {
        this.offsetResetPolicy = offsetResetPolicy;
        return this;
    }

    @JsonProperty(value="offset_reset_policy")
    @ApiModelProperty(example="EARLIEST", value="For non-DMS streams, Rockset can tail from the earliest end or latest end of kinesis source.")
    public OffsetResetPolicyEnum getOffsetResetPolicy() {
        return this.offsetResetPolicy;
    }

    public void setOffsetResetPolicy(OffsetResetPolicyEnum offsetResetPolicy) {
        this.offsetResetPolicy = offsetResetPolicy;
    }

    public SourceKinesis streamName(String streamName) {
        this.streamName = streamName;
        return this;
    }

    @JsonProperty(value="stream_name")
    @ApiModelProperty(example="click_stream", required=true, value="Name of kinesis stream.")
    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceKinesis sourceKinesis = (SourceKinesis)o;
        return Objects.equals(this.awsRegion, sourceKinesis.awsRegion) && Objects.equals(this.dmsPrimaryKey, sourceKinesis.dmsPrimaryKey) && Objects.equals((Object)this.offsetResetPolicy, (Object)sourceKinesis.offsetResetPolicy) && Objects.equals(this.streamName, sourceKinesis.streamName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.awsRegion, this.dmsPrimaryKey, this.offsetResetPolicy, this.streamName});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SourceKinesis {\n");
        sb.append("    awsRegion: ").append(this.toIndentedString(this.awsRegion)).append("\n");
        sb.append("    dmsPrimaryKey: ").append(this.toIndentedString(this.dmsPrimaryKey)).append("\n");
        sb.append("    offsetResetPolicy: ").append(this.toIndentedString((Object)this.offsetResetPolicy)).append("\n");
        sb.append("    streamName: ").append(this.toIndentedString(this.streamName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OffsetResetPolicyEnum {
        LATEST("LATEST"),
        EARLIEST("EARLIEST");

        private String value;

        private OffsetResetPolicyEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OffsetResetPolicyEnum fromValue(String text) {
            for (OffsetResetPolicyEnum b : OffsetResetPolicyEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<OffsetResetPolicyEnum> {
            public void write(JsonWriter jsonWriter, OffsetResetPolicyEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OffsetResetPolicyEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OffsetResetPolicyEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

