/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import com.rockset.client.model.StatusMongoDb;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class SourceMongoDb {
    @SerializedName(value="collection_name")
    private String collectionName = null;
    @SerializedName(value="database_name")
    private String databaseName = null;
    @SerializedName(value="retrieve_full_document")
    private Boolean retrieveFullDocument = null;
    @SerializedName(value="status")
    private StatusMongoDb status = null;

    public SourceMongoDb collectionName(String collectionName) {
        this.collectionName = collectionName;
        return this;
    }

    @JsonProperty(value="collection_name")
    @ApiModelProperty(example="my_collection", required=true, value="MongoDB collection name.")
    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public SourceMongoDb databaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    @JsonProperty(value="database_name")
    @ApiModelProperty(example="my_database", required=true, value="MongoDB database name containing this collection.")
    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public SourceMongoDb retrieveFullDocument(Boolean retrieveFullDocument) {
        this.retrieveFullDocument = retrieveFullDocument;
        return this;
    }

    @JsonProperty(value="retrieve_full_document")
    @ApiModelProperty(value="Whether to get the full document from the MongoDB change stream to enable multi-field expression transformations. Selecting this option will increase load on your upstream MongoDB database.")
    public Boolean isRetrieveFullDocument() {
        return this.retrieveFullDocument;
    }

    public void setRetrieveFullDocument(Boolean retrieveFullDocument) {
        this.retrieveFullDocument = retrieveFullDocument;
    }

    @JsonProperty(value="status")
    @ApiModelProperty(value="MongoDB source status.")
    public StatusMongoDb getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceMongoDb sourceMongoDb = (SourceMongoDb)o;
        return Objects.equals(this.collectionName, sourceMongoDb.collectionName) && Objects.equals(this.databaseName, sourceMongoDb.databaseName) && Objects.equals(this.retrieveFullDocument, sourceMongoDb.retrieveFullDocument) && Objects.equals(this.status, sourceMongoDb.status);
    }

    public int hashCode() {
        return Objects.hash(this.collectionName, this.databaseName, this.retrieveFullDocument, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SourceMongoDb {\n");
        sb.append("    collectionName: ").append(this.toIndentedString(this.collectionName)).append("\n");
        sb.append("    databaseName: ").append(this.toIndentedString(this.databaseName)).append("\n");
        sb.append("    retrieveFullDocument: ").append(this.toIndentedString(this.retrieveFullDocument)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

