/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class SourceRedshift {
    @SerializedName(value="database")
    private String database = null;
    @SerializedName(value="schema")
    private String schema = null;
    @SerializedName(value="table_name")
    private String tableName = null;
    @SerializedName(value="incremental_field")
    private String incrementalField = null;

    public SourceRedshift database(String database) {
        this.database = database;
        return this;
    }

    @JsonProperty(value="database")
    @ApiModelProperty(example="dev", required=true, value="name of the database in Redshift Cluster")
    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public SourceRedshift schema(String schema) {
        this.schema = schema;
        return this;
    }

    @JsonProperty(value="schema")
    @ApiModelProperty(example="common", required=true, value="schema which contains the Redshift table")
    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public SourceRedshift tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    @JsonProperty(value="table_name")
    @ApiModelProperty(example="redshift_table_name", required=true, value="name of Redshift table containing data")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public SourceRedshift incrementalField(String incrementalField) {
        this.incrementalField = incrementalField;
        return this;
    }

    @JsonProperty(value="incremental_field")
    @ApiModelProperty(example="updated_at", value="field in Redshift source table to monitor for updates")
    public String getIncrementalField() {
        return this.incrementalField;
    }

    public void setIncrementalField(String incrementalField) {
        this.incrementalField = incrementalField;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceRedshift sourceRedshift = (SourceRedshift)o;
        return Objects.equals(this.database, sourceRedshift.database) && Objects.equals(this.schema, sourceRedshift.schema) && Objects.equals(this.tableName, sourceRedshift.tableName) && Objects.equals(this.incrementalField, sourceRedshift.incrementalField);
    }

    public int hashCode() {
        return Objects.hash(this.database, this.schema, this.tableName, this.incrementalField);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SourceRedshift {\n");
        sb.append("    database: ").append(this.toIndentedString(this.database)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    tableName: ").append(this.toIndentedString(this.tableName)).append("\n");
        sb.append("    incrementalField: ").append(this.toIndentedString(this.incrementalField)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

