/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import com.rockset.client.model.SourceS3Settings;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

public class SourceS3 {
    @SerializedName(value="bucket")
    private String bucket = null;
    @SerializedName(value="object_bytes_downloaded")
    private Long objectBytesDownloaded = null;
    @SerializedName(value="object_bytes_total")
    private Long objectBytesTotal = null;
    @SerializedName(value="object_count_downloaded")
    private Long objectCountDownloaded = null;
    @SerializedName(value="object_count_total")
    private Long objectCountTotal = null;
    @SerializedName(value="pattern")
    private String pattern = null;
    @SerializedName(value="prefix")
    private String prefix = null;
    @SerializedName(value="prefixes")
    private List<String> prefixes = null;
    @SerializedName(value="region")
    private String region = null;
    @SerializedName(value="settings")
    private SourceS3Settings settings = null;

    public SourceS3 bucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    @JsonProperty(value="bucket")
    @ApiModelProperty(example="s3://customer-account-info", required=true, value="Address of S3 bucket containing data.")
    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    @JsonProperty(value="object_bytes_downloaded")
    @ApiModelProperty(value="")
    public Long getObjectBytesDownloaded() {
        return this.objectBytesDownloaded;
    }

    @JsonProperty(value="object_bytes_total")
    @ApiModelProperty(value="")
    public Long getObjectBytesTotal() {
        return this.objectBytesTotal;
    }

    @JsonProperty(value="object_count_downloaded")
    @ApiModelProperty(value="")
    public Long getObjectCountDownloaded() {
        return this.objectCountDownloaded;
    }

    @JsonProperty(value="object_count_total")
    @ApiModelProperty(value="")
    public Long getObjectCountTotal() {
        return this.objectCountTotal;
    }

    public SourceS3 pattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    @JsonProperty(value="pattern")
    @ApiModelProperty(example="prefix/to/_**_/keys/_*.format", value="Glob-style pattern that selects keys to ingest. Only either prefix or pattern can be specified.")
    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public SourceS3 prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @JsonProperty(value="prefix")
    @ApiModelProperty(example="prefix/to/keys", value="Prefix that selects keys to ingest.")
    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @JsonProperty(value="prefixes")
    @ApiModelProperty(example="\"[\\\"/transactions\\\", \\\"/stores\\\"]\"", value="Deprecated in favor of `prefix`. List of prefixes to paths from which data should be ingested.")
    public List<String> getPrefixes() {
        return this.prefixes;
    }

    public SourceS3 region(String region) {
        this.region = region;
        return this;
    }

    @JsonProperty(value="region")
    @ApiModelProperty(example="us-west-2", value="AWS region containing source bucket.")
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public SourceS3 settings(SourceS3Settings settings) {
        this.settings = settings;
        return this;
    }

    @JsonProperty(value="settings")
    @ApiModelProperty(value="custom settings for Amazon S3 source")
    public SourceS3Settings getSettings() {
        return this.settings;
    }

    public void setSettings(SourceS3Settings settings) {
        this.settings = settings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceS3 sourceS3 = (SourceS3)o;
        return Objects.equals(this.bucket, sourceS3.bucket) && Objects.equals(this.objectBytesDownloaded, sourceS3.objectBytesDownloaded) && Objects.equals(this.objectBytesTotal, sourceS3.objectBytesTotal) && Objects.equals(this.objectCountDownloaded, sourceS3.objectCountDownloaded) && Objects.equals(this.objectCountTotal, sourceS3.objectCountTotal) && Objects.equals(this.pattern, sourceS3.pattern) && Objects.equals(this.prefix, sourceS3.prefix) && Objects.equals(this.prefixes, sourceS3.prefixes) && Objects.equals(this.region, sourceS3.region) && Objects.equals(this.settings, sourceS3.settings);
    }

    public int hashCode() {
        return Objects.hash(this.bucket, this.objectBytesDownloaded, this.objectBytesTotal, this.objectCountDownloaded, this.objectCountTotal, this.pattern, this.prefix, this.prefixes, this.region, this.settings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SourceS3 {\n");
        sb.append("    bucket: ").append(this.toIndentedString(this.bucket)).append("\n");
        sb.append("    objectBytesDownloaded: ").append(this.toIndentedString(this.objectBytesDownloaded)).append("\n");
        sb.append("    objectBytesTotal: ").append(this.toIndentedString(this.objectBytesTotal)).append("\n");
        sb.append("    objectCountDownloaded: ").append(this.toIndentedString(this.objectCountDownloaded)).append("\n");
        sb.append("    objectCountTotal: ").append(this.toIndentedString(this.objectCountTotal)).append("\n");
        sb.append("    pattern: ").append(this.toIndentedString(this.pattern)).append("\n");
        sb.append("    prefix: ").append(this.toIndentedString(this.prefix)).append("\n");
        sb.append("    prefixes: ").append(this.toIndentedString(this.prefixes)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

