/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import com.rockset.client.model.StatusSnowflake;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class SourceSnowflake {
    @SerializedName(value="database")
    private String database = null;
    @SerializedName(value="schema")
    private String schema = null;
    @SerializedName(value="status")
    private StatusSnowflake status = null;
    @SerializedName(value="table_name")
    private String tableName = null;
    @SerializedName(value="warehouse")
    private String warehouse = null;

    public SourceSnowflake database(String database) {
        this.database = database;
        return this;
    }

    @JsonProperty(value="database")
    @ApiModelProperty(example="NASDAQ", required=true, value="Name of the snowflake database.")
    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public SourceSnowflake schema(String schema) {
        this.schema = schema;
        return this;
    }

    @JsonProperty(value="schema")
    @ApiModelProperty(example="PUBLIC", required=true, value="Name of the snowflake database schema.")
    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    @JsonProperty(value="status")
    @ApiModelProperty(value="Snowflake source status.")
    public StatusSnowflake getStatus() {
        return this.status;
    }

    public SourceSnowflake tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    @JsonProperty(value="table_name")
    @ApiModelProperty(example="COMPANIES", required=true, value="Name of the snowflake table.")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public SourceSnowflake warehouse(String warehouse) {
        this.warehouse = warehouse;
        return this;
    }

    @JsonProperty(value="warehouse")
    @ApiModelProperty(example="COMPUTE_XL", value="Name of the data warehouse to be used.")
    public String getWarehouse() {
        return this.warehouse;
    }

    public void setWarehouse(String warehouse) {
        this.warehouse = warehouse;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceSnowflake sourceSnowflake = (SourceSnowflake)o;
        return Objects.equals(this.database, sourceSnowflake.database) && Objects.equals(this.schema, sourceSnowflake.schema) && Objects.equals(this.status, sourceSnowflake.status) && Objects.equals(this.tableName, sourceSnowflake.tableName) && Objects.equals(this.warehouse, sourceSnowflake.warehouse);
    }

    public int hashCode() {
        return Objects.hash(this.database, this.schema, this.status, this.tableName, this.warehouse);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SourceSnowflake {\n");
        sb.append("    database: ").append(this.toIndentedString(this.database)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    tableName: ").append(this.toIndentedString(this.tableName)).append("\n");
        sb.append("    warehouse: ").append(this.toIndentedString(this.warehouse)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

