/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class SourceSystem {
    @SerializedName(value="type")
    private TypeEnum type = null;
    @SerializedName(value="workspace")
    private String workspace = null;

    public SourceSystem type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="type")
    @ApiModelProperty(example="QUERY_LOGS", value="The type of this system source.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public SourceSystem workspace(String workspace) {
        this.workspace = workspace;
        return this;
    }

    @JsonProperty(value="workspace")
    @ApiModelProperty(example="commons", value="The workspace for which collections will have logs created. If unspecified, logs will be created for collections in all workspaces. Currently only supported for the INGEST_LOGS system source.")
    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceSystem sourceSystem = (SourceSystem)o;
        return Objects.equals((Object)this.type, (Object)sourceSystem.type) && Objects.equals(this.workspace, sourceSystem.workspace);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.workspace});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SourceSystem {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    workspace: ").append(this.toIndentedString(this.workspace)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        QUERY_LOGS("QUERYLOGS"),
        INGEST_LOGS("INGESTLOGS");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

