/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class Status {
    @SerializedName(value="detected_size_bytes")
    private Long detectedSizeBytes = null;
    @SerializedName(value="last_processed_at")
    private String lastProcessedAt = null;
    @SerializedName(value="last_processed_item")
    private String lastProcessedItem = null;
    @SerializedName(value="message")
    private String message = null;
    @SerializedName(value="state")
    private StateEnum state = null;
    @SerializedName(value="total_processed_items")
    private Long totalProcessedItems = null;

    public Status detectedSizeBytes(Long detectedSizeBytes) {
        this.detectedSizeBytes = detectedSizeBytes;
        return this;
    }

    @JsonProperty(value="detected_size_bytes")
    @ApiModelProperty(value="Size in bytes detected for the source at collection initialization. This size can be 0 or null for event stream sources.")
    public Long getDetectedSizeBytes() {
        return this.detectedSizeBytes;
    }

    public void setDetectedSizeBytes(Long detectedSizeBytes) {
        this.detectedSizeBytes = detectedSizeBytes;
    }

    public Status lastProcessedAt(String lastProcessedAt) {
        this.lastProcessedAt = lastProcessedAt;
        return this;
    }

    @JsonProperty(value="last_processed_at")
    @ApiModelProperty(example="2019-01-15T21:48:23Z", value="ISO-8601 date when source was last processed.")
    public String getLastProcessedAt() {
        return this.lastProcessedAt;
    }

    public void setLastProcessedAt(String lastProcessedAt) {
        this.lastProcessedAt = lastProcessedAt;
    }

    public Status lastProcessedItem(String lastProcessedItem) {
        this.lastProcessedItem = lastProcessedItem;
        return this;
    }

    @JsonProperty(value="last_processed_item")
    @ApiModelProperty(example="/path/to/some/object", value="Last source item processed by ingester.")
    public String getLastProcessedItem() {
        return this.lastProcessedItem;
    }

    public void setLastProcessedItem(String lastProcessedItem) {
        this.lastProcessedItem = lastProcessedItem;
    }

    public Status message(String message) {
        this.message = message;
        return this;
    }

    @JsonProperty(value="message")
    @ApiModelProperty(example="error 403 forbidden", value="State message.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Status state(StateEnum state) {
        this.state = state;
        return this;
    }

    @JsonProperty(value="state")
    @ApiModelProperty(example="INITIALIZING", value="Status of the Source's ingestion.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public Status totalProcessedItems(Long totalProcessedItems) {
        this.totalProcessedItems = totalProcessedItems;
        return this;
    }

    @JsonProperty(value="total_processed_items")
    @ApiModelProperty(example="32849023", value="Total items processed of source.")
    public Long getTotalProcessedItems() {
        return this.totalProcessedItems;
    }

    public void setTotalProcessedItems(Long totalProcessedItems) {
        this.totalProcessedItems = totalProcessedItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Status status = (Status)o;
        return Objects.equals(this.detectedSizeBytes, status.detectedSizeBytes) && Objects.equals(this.lastProcessedAt, status.lastProcessedAt) && Objects.equals(this.lastProcessedItem, status.lastProcessedItem) && Objects.equals(this.message, status.message) && Objects.equals((Object)this.state, (Object)status.state) && Objects.equals(this.totalProcessedItems, status.totalProcessedItems);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.detectedSizeBytes, this.lastProcessedAt, this.lastProcessedItem, this.message, this.state, this.totalProcessedItems});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Status {\n");
        sb.append("    detectedSizeBytes: ").append(this.toIndentedString(this.detectedSizeBytes)).append("\n");
        sb.append("    lastProcessedAt: ").append(this.toIndentedString(this.lastProcessedAt)).append("\n");
        sb.append("    lastProcessedItem: ").append(this.toIndentedString(this.lastProcessedItem)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    totalProcessedItems: ").append(this.toIndentedString(this.totalProcessedItems)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        INITIALIZING("INITIALIZING"),
        WATCHING("WATCHING"),
        PROCESSING("PROCESSING"),
        COMPLETED("COMPLETED"),
        ERROR("ERROR"),
        SUSPENDED("SUSPENDED");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String text) {
            for (StateEnum b : StateEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

