/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.rockset.client.model.StatusAzureEventHubsPartition;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class StatusAzureEventHubs {
    @SerializedName(value="last_consumed_time")
    private String lastConsumedTime = null;
    @SerializedName(value="num_documents_processed")
    private Long numDocumentsProcessed = null;
    @SerializedName(value="partitions")
    private List<StatusAzureEventHubsPartition> partitions = null;
    @SerializedName(value="state")
    private StateEnum state = null;

    public StatusAzureEventHubs lastConsumedTime(String lastConsumedTime) {
        this.lastConsumedTime = lastConsumedTime;
        return this;
    }

    @JsonProperty(value="last_consumed_time")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="Time at which the last document was consumed.")
    public String getLastConsumedTime() {
        return this.lastConsumedTime;
    }

    public void setLastConsumedTime(String lastConsumedTime) {
        this.lastConsumedTime = lastConsumedTime;
    }

    public StatusAzureEventHubs numDocumentsProcessed(Long numDocumentsProcessed) {
        this.numDocumentsProcessed = numDocumentsProcessed;
        return this;
    }

    @JsonProperty(value="num_documents_processed")
    @ApiModelProperty(example="1337", value="Number of documents consumed.")
    public Long getNumDocumentsProcessed() {
        return this.numDocumentsProcessed;
    }

    public void setNumDocumentsProcessed(Long numDocumentsProcessed) {
        this.numDocumentsProcessed = numDocumentsProcessed;
    }

    public StatusAzureEventHubs partitions(List<StatusAzureEventHubsPartition> partitions) {
        this.partitions = partitions;
        return this;
    }

    public StatusAzureEventHubs addPartitionsItem(StatusAzureEventHubsPartition partitionsItem) {
        if (this.partitions == null) {
            this.partitions = new ArrayList<StatusAzureEventHubsPartition>();
        }
        this.partitions.add(partitionsItem);
        return this;
    }

    @JsonProperty(value="partitions")
    @ApiModelProperty(value="Status info per partition.")
    public List<StatusAzureEventHubsPartition> getPartitions() {
        return this.partitions;
    }

    public void setPartitions(List<StatusAzureEventHubsPartition> partitions) {
        this.partitions = partitions;
    }

    public StatusAzureEventHubs state(StateEnum state) {
        this.state = state;
        return this;
    }

    @JsonProperty(value="state")
    @ApiModelProperty(example="ACTIVE", value="State of the source.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusAzureEventHubs statusAzureEventHubs = (StatusAzureEventHubs)o;
        return Objects.equals(this.lastConsumedTime, statusAzureEventHubs.lastConsumedTime) && Objects.equals(this.numDocumentsProcessed, statusAzureEventHubs.numDocumentsProcessed) && Objects.equals(this.partitions, statusAzureEventHubs.partitions) && Objects.equals((Object)this.state, (Object)statusAzureEventHubs.state);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.lastConsumedTime, this.numDocumentsProcessed, this.partitions, this.state});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StatusAzureEventHubs {\n");
        sb.append("    lastConsumedTime: ").append(this.toIndentedString(this.lastConsumedTime)).append("\n");
        sb.append("    numDocumentsProcessed: ").append(this.toIndentedString(this.numDocumentsProcessed)).append("\n");
        sb.append("    partitions: ").append(this.toIndentedString(this.partitions)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        NO_DOCS_YET("NODOCSYET"),
        ACTIVE("ACTIVE"),
        DORMANT("DORMANT");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String text) {
            for (StateEnum b : StateEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

