/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class StatusDynamoDb {
    @SerializedName(value="scan_end_time")
    private String scanEndTime = null;
    @SerializedName(value="scan_records_processed")
    private Long scanRecordsProcessed = null;
    @SerializedName(value="scan_start_time")
    private String scanStartTime = null;
    @SerializedName(value="scan_total_records")
    private Long scanTotalRecords = null;
    @SerializedName(value="state")
    private StateEnum state = null;
    @SerializedName(value="stream_last_processed_at")
    private String streamLastProcessedAt = null;

    public StatusDynamoDb scanEndTime(String scanEndTime) {
        this.scanEndTime = scanEndTime;
        return this;
    }

    @JsonProperty(value="scan_end_time")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="DynamoDb scan end time.")
    public String getScanEndTime() {
        return this.scanEndTime;
    }

    public void setScanEndTime(String scanEndTime) {
        this.scanEndTime = scanEndTime;
    }

    public StatusDynamoDb scanRecordsProcessed(Long scanRecordsProcessed) {
        this.scanRecordsProcessed = scanRecordsProcessed;
        return this;
    }

    @JsonProperty(value="scan_records_processed")
    @ApiModelProperty(example="1000", value="Number of records inserted using scan.")
    public Long getScanRecordsProcessed() {
        return this.scanRecordsProcessed;
    }

    public void setScanRecordsProcessed(Long scanRecordsProcessed) {
        this.scanRecordsProcessed = scanRecordsProcessed;
    }

    public StatusDynamoDb scanStartTime(String scanStartTime) {
        this.scanStartTime = scanStartTime;
        return this;
    }

    @JsonProperty(value="scan_start_time")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="DynamoDB scan start time.")
    public String getScanStartTime() {
        return this.scanStartTime;
    }

    public void setScanStartTime(String scanStartTime) {
        this.scanStartTime = scanStartTime;
    }

    public StatusDynamoDb scanTotalRecords(Long scanTotalRecords) {
        this.scanTotalRecords = scanTotalRecords;
        return this;
    }

    @JsonProperty(value="scan_total_records")
    @ApiModelProperty(example="2000", value="Number of records in DynamoDB table at time of scan.")
    public Long getScanTotalRecords() {
        return this.scanTotalRecords;
    }

    public void setScanTotalRecords(Long scanTotalRecords) {
        this.scanTotalRecords = scanTotalRecords;
    }

    public StatusDynamoDb state(StateEnum state) {
        this.state = state;
        return this;
    }

    @JsonProperty(value="state")
    @ApiModelProperty(example="SCANNING_TABLE", value="State of current ingest for this table.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public StatusDynamoDb streamLastProcessedAt(String streamLastProcessedAt) {
        this.streamLastProcessedAt = streamLastProcessedAt;
        return this;
    }

    @JsonProperty(value="stream_last_processed_at")
    @ApiModelProperty(example="2019-01-15T21:48:23Z", value="ISO-8601 date when source was last processed.")
    public String getStreamLastProcessedAt() {
        return this.streamLastProcessedAt;
    }

    public void setStreamLastProcessedAt(String streamLastProcessedAt) {
        this.streamLastProcessedAt = streamLastProcessedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusDynamoDb statusDynamoDb = (StatusDynamoDb)o;
        return Objects.equals(this.scanEndTime, statusDynamoDb.scanEndTime) && Objects.equals(this.scanRecordsProcessed, statusDynamoDb.scanRecordsProcessed) && Objects.equals(this.scanStartTime, statusDynamoDb.scanStartTime) && Objects.equals(this.scanTotalRecords, statusDynamoDb.scanTotalRecords) && Objects.equals((Object)this.state, (Object)statusDynamoDb.state) && Objects.equals(this.streamLastProcessedAt, statusDynamoDb.streamLastProcessedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.scanEndTime, this.scanRecordsProcessed, this.scanStartTime, this.scanTotalRecords, this.state, this.streamLastProcessedAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StatusDynamoDb {\n");
        sb.append("    scanEndTime: ").append(this.toIndentedString(this.scanEndTime)).append("\n");
        sb.append("    scanRecordsProcessed: ").append(this.toIndentedString(this.scanRecordsProcessed)).append("\n");
        sb.append("    scanStartTime: ").append(this.toIndentedString(this.scanStartTime)).append("\n");
        sb.append("    scanTotalRecords: ").append(this.toIndentedString(this.scanTotalRecords)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    streamLastProcessedAt: ").append(this.toIndentedString(this.streamLastProcessedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        INITIALIZING("INITIALIZING"),
        SCANNING_TABLE("SCANNINGTABLE"),
        PROCESSING_STREAM("PROCESSINGSTREAM");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String text) {
            for (StateEnum b : StateEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

