/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.rockset.client.model.StatusKafkaPartition;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class StatusKafka {
    @SerializedName(value="kafka_partitions")
    private List<StatusKafkaPartition> kafkaPartitions = null;
    @SerializedName(value="last_consumed_time")
    private String lastConsumedTime = null;
    @SerializedName(value="num_documents_processed")
    private Long numDocumentsProcessed = null;
    @SerializedName(value="state")
    private StateEnum state = null;

    public StatusKafka kafkaPartitions(List<StatusKafkaPartition> kafkaPartitions) {
        this.kafkaPartitions = kafkaPartitions;
        return this;
    }

    public StatusKafka addKafkaPartitionsItem(StatusKafkaPartition kafkaPartitionsItem) {
        if (this.kafkaPartitions == null) {
            this.kafkaPartitions = new ArrayList<StatusKafkaPartition>();
        }
        this.kafkaPartitions.add(kafkaPartitionsItem);
        return this;
    }

    @JsonProperty(value="kafka_partitions")
    @ApiModelProperty(value="Status info per partition.")
    public List<StatusKafkaPartition> getKafkaPartitions() {
        return this.kafkaPartitions;
    }

    public void setKafkaPartitions(List<StatusKafkaPartition> kafkaPartitions) {
        this.kafkaPartitions = kafkaPartitions;
    }

    public StatusKafka lastConsumedTime(String lastConsumedTime) {
        this.lastConsumedTime = lastConsumedTime;
        return this;
    }

    @JsonProperty(value="last_consumed_time")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="Time at which the last document was consumed from Kafka.")
    public String getLastConsumedTime() {
        return this.lastConsumedTime;
    }

    public void setLastConsumedTime(String lastConsumedTime) {
        this.lastConsumedTime = lastConsumedTime;
    }

    public StatusKafka numDocumentsProcessed(Long numDocumentsProcessed) {
        this.numDocumentsProcessed = numDocumentsProcessed;
        return this;
    }

    @JsonProperty(value="num_documents_processed")
    @ApiModelProperty(example="1337", value="Number of documents consumed by this Kafka topic.")
    public Long getNumDocumentsProcessed() {
        return this.numDocumentsProcessed;
    }

    public void setNumDocumentsProcessed(Long numDocumentsProcessed) {
        this.numDocumentsProcessed = numDocumentsProcessed;
    }

    public StatusKafka state(StateEnum state) {
        this.state = state;
        return this;
    }

    @JsonProperty(value="state")
    @ApiModelProperty(example="ACTIVE", value="State of the Kafka source.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusKafka statusKafka = (StatusKafka)o;
        return Objects.equals(this.kafkaPartitions, statusKafka.kafkaPartitions) && Objects.equals(this.lastConsumedTime, statusKafka.lastConsumedTime) && Objects.equals(this.numDocumentsProcessed, statusKafka.numDocumentsProcessed) && Objects.equals((Object)this.state, (Object)statusKafka.state);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kafkaPartitions, this.lastConsumedTime, this.numDocumentsProcessed, this.state});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StatusKafka {\n");
        sb.append("    kafkaPartitions: ").append(this.toIndentedString(this.kafkaPartitions)).append("\n");
        sb.append("    lastConsumedTime: ").append(this.toIndentedString(this.lastConsumedTime)).append("\n");
        sb.append("    numDocumentsProcessed: ").append(this.toIndentedString(this.numDocumentsProcessed)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        NO_DOCS_YET("NODOCSYET"),
        ACTIVE("ACTIVE"),
        DORMANT("DORMANT");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String text) {
            for (StateEnum b : StateEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

