/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class StatusMongoDb {
    @SerializedName(value="scan_end_time")
    private String scanEndTime = null;
    @SerializedName(value="scan_records_processed")
    private Long scanRecordsProcessed = null;
    @SerializedName(value="scan_start_time")
    private String scanStartTime = null;
    @SerializedName(value="scan_total_records")
    private Long scanTotalRecords = null;
    @SerializedName(value="state")
    private StateEnum state = null;
    @SerializedName(value="stream_last_delete_processed_at")
    private String streamLastDeleteProcessedAt = null;
    @SerializedName(value="stream_last_insert_processed_at")
    private String streamLastInsertProcessedAt = null;
    @SerializedName(value="stream_last_update_processed_at")
    private String streamLastUpdateProcessedAt = null;
    @SerializedName(value="stream_records_deleted")
    private Long streamRecordsDeleted = null;
    @SerializedName(value="stream_records_inserted")
    private Long streamRecordsInserted = null;
    @SerializedName(value="stream_records_updated")
    private Long streamRecordsUpdated = null;

    public StatusMongoDb scanEndTime(String scanEndTime) {
        this.scanEndTime = scanEndTime;
        return this;
    }

    @JsonProperty(value="scan_end_time")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="MongoDB scan end time.")
    public String getScanEndTime() {
        return this.scanEndTime;
    }

    public void setScanEndTime(String scanEndTime) {
        this.scanEndTime = scanEndTime;
    }

    public StatusMongoDb scanRecordsProcessed(Long scanRecordsProcessed) {
        this.scanRecordsProcessed = scanRecordsProcessed;
        return this;
    }

    @JsonProperty(value="scan_records_processed")
    @ApiModelProperty(example="1000", value="Number of records inserted using scan.")
    public Long getScanRecordsProcessed() {
        return this.scanRecordsProcessed;
    }

    public void setScanRecordsProcessed(Long scanRecordsProcessed) {
        this.scanRecordsProcessed = scanRecordsProcessed;
    }

    public StatusMongoDb scanStartTime(String scanStartTime) {
        this.scanStartTime = scanStartTime;
        return this;
    }

    @JsonProperty(value="scan_start_time")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="MongoDB scan start time.")
    public String getScanStartTime() {
        return this.scanStartTime;
    }

    public void setScanStartTime(String scanStartTime) {
        this.scanStartTime = scanStartTime;
    }

    public StatusMongoDb scanTotalRecords(Long scanTotalRecords) {
        this.scanTotalRecords = scanTotalRecords;
        return this;
    }

    @JsonProperty(value="scan_total_records")
    @ApiModelProperty(example="2000", value="Number of records in MongoDB table at time of scan.")
    public Long getScanTotalRecords() {
        return this.scanTotalRecords;
    }

    public void setScanTotalRecords(Long scanTotalRecords) {
        this.scanTotalRecords = scanTotalRecords;
    }

    public StatusMongoDb state(StateEnum state) {
        this.state = state;
        return this;
    }

    @JsonProperty(value="state")
    @ApiModelProperty(example="SCANNING_TABLE", value="State of current ingest for this table.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public StatusMongoDb streamLastDeleteProcessedAt(String streamLastDeleteProcessedAt) {
        this.streamLastDeleteProcessedAt = streamLastDeleteProcessedAt;
        return this;
    }

    @JsonProperty(value="stream_last_delete_processed_at")
    @ApiModelProperty(example="2019-01-15T21:48:23Z", value="ISO-8601 date when delete from source was last processed.")
    public String getStreamLastDeleteProcessedAt() {
        return this.streamLastDeleteProcessedAt;
    }

    public void setStreamLastDeleteProcessedAt(String streamLastDeleteProcessedAt) {
        this.streamLastDeleteProcessedAt = streamLastDeleteProcessedAt;
    }

    public StatusMongoDb streamLastInsertProcessedAt(String streamLastInsertProcessedAt) {
        this.streamLastInsertProcessedAt = streamLastInsertProcessedAt;
        return this;
    }

    @JsonProperty(value="stream_last_insert_processed_at")
    @ApiModelProperty(example="2019-01-15T21:48:23Z", value="ISO-8601 date when new insert from source was last processed.")
    public String getStreamLastInsertProcessedAt() {
        return this.streamLastInsertProcessedAt;
    }

    public void setStreamLastInsertProcessedAt(String streamLastInsertProcessedAt) {
        this.streamLastInsertProcessedAt = streamLastInsertProcessedAt;
    }

    public StatusMongoDb streamLastUpdateProcessedAt(String streamLastUpdateProcessedAt) {
        this.streamLastUpdateProcessedAt = streamLastUpdateProcessedAt;
        return this;
    }

    @JsonProperty(value="stream_last_update_processed_at")
    @ApiModelProperty(example="2019-01-15T21:48:23Z", value="ISO-8601 date when update from source was last processed.")
    public String getStreamLastUpdateProcessedAt() {
        return this.streamLastUpdateProcessedAt;
    }

    public void setStreamLastUpdateProcessedAt(String streamLastUpdateProcessedAt) {
        this.streamLastUpdateProcessedAt = streamLastUpdateProcessedAt;
    }

    public StatusMongoDb streamRecordsDeleted(Long streamRecordsDeleted) {
        this.streamRecordsDeleted = streamRecordsDeleted;
        return this;
    }

    @JsonProperty(value="stream_records_deleted")
    @ApiModelProperty(example="100", value="Number of new records deleted using stream.")
    public Long getStreamRecordsDeleted() {
        return this.streamRecordsDeleted;
    }

    public void setStreamRecordsDeleted(Long streamRecordsDeleted) {
        this.streamRecordsDeleted = streamRecordsDeleted;
    }

    public StatusMongoDb streamRecordsInserted(Long streamRecordsInserted) {
        this.streamRecordsInserted = streamRecordsInserted;
        return this;
    }

    @JsonProperty(value="stream_records_inserted")
    @ApiModelProperty(example="10000", value="Number of new records inserted using stream.")
    public Long getStreamRecordsInserted() {
        return this.streamRecordsInserted;
    }

    public void setStreamRecordsInserted(Long streamRecordsInserted) {
        this.streamRecordsInserted = streamRecordsInserted;
    }

    public StatusMongoDb streamRecordsUpdated(Long streamRecordsUpdated) {
        this.streamRecordsUpdated = streamRecordsUpdated;
        return this;
    }

    @JsonProperty(value="stream_records_updated")
    @ApiModelProperty(example="1000", value="Number of new records updated using stream.")
    public Long getStreamRecordsUpdated() {
        return this.streamRecordsUpdated;
    }

    public void setStreamRecordsUpdated(Long streamRecordsUpdated) {
        this.streamRecordsUpdated = streamRecordsUpdated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusMongoDb statusMongoDb = (StatusMongoDb)o;
        return Objects.equals(this.scanEndTime, statusMongoDb.scanEndTime) && Objects.equals(this.scanRecordsProcessed, statusMongoDb.scanRecordsProcessed) && Objects.equals(this.scanStartTime, statusMongoDb.scanStartTime) && Objects.equals(this.scanTotalRecords, statusMongoDb.scanTotalRecords) && Objects.equals((Object)this.state, (Object)statusMongoDb.state) && Objects.equals(this.streamLastDeleteProcessedAt, statusMongoDb.streamLastDeleteProcessedAt) && Objects.equals(this.streamLastInsertProcessedAt, statusMongoDb.streamLastInsertProcessedAt) && Objects.equals(this.streamLastUpdateProcessedAt, statusMongoDb.streamLastUpdateProcessedAt) && Objects.equals(this.streamRecordsDeleted, statusMongoDb.streamRecordsDeleted) && Objects.equals(this.streamRecordsInserted, statusMongoDb.streamRecordsInserted) && Objects.equals(this.streamRecordsUpdated, statusMongoDb.streamRecordsUpdated);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.scanEndTime, this.scanRecordsProcessed, this.scanStartTime, this.scanTotalRecords, this.state, this.streamLastDeleteProcessedAt, this.streamLastInsertProcessedAt, this.streamLastUpdateProcessedAt, this.streamRecordsDeleted, this.streamRecordsInserted, this.streamRecordsUpdated});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StatusMongoDb {\n");
        sb.append("    scanEndTime: ").append(this.toIndentedString(this.scanEndTime)).append("\n");
        sb.append("    scanRecordsProcessed: ").append(this.toIndentedString(this.scanRecordsProcessed)).append("\n");
        sb.append("    scanStartTime: ").append(this.toIndentedString(this.scanStartTime)).append("\n");
        sb.append("    scanTotalRecords: ").append(this.toIndentedString(this.scanTotalRecords)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    streamLastDeleteProcessedAt: ").append(this.toIndentedString(this.streamLastDeleteProcessedAt)).append("\n");
        sb.append("    streamLastInsertProcessedAt: ").append(this.toIndentedString(this.streamLastInsertProcessedAt)).append("\n");
        sb.append("    streamLastUpdateProcessedAt: ").append(this.toIndentedString(this.streamLastUpdateProcessedAt)).append("\n");
        sb.append("    streamRecordsDeleted: ").append(this.toIndentedString(this.streamRecordsDeleted)).append("\n");
        sb.append("    streamRecordsInserted: ").append(this.toIndentedString(this.streamRecordsInserted)).append("\n");
        sb.append("    streamRecordsUpdated: ").append(this.toIndentedString(this.streamRecordsUpdated)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        INITIALIZING("INITIALIZING"),
        SCANNING_TABLE("SCANNINGTABLE"),
        PROCESSING_STREAM("PROCESSINGSTREAM");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String text) {
            for (StateEnum b : StateEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

