/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class TLSConfig {
    @SerializedName(value="ca_cert")
    private String caCert = null;
    @SerializedName(value="client_cert")
    private String clientCert = null;
    @SerializedName(value="client_cert_expiry")
    private Long clientCertExpiry = null;
    @SerializedName(value="client_cert_subject")
    private String clientCertSubject = null;
    @SerializedName(value="client_key")
    private String clientKey = null;

    public TLSConfig caCert(String caCert) {
        this.caCert = caCert;
        return this;
    }

    @JsonProperty(value="ca_cert")
    @ApiModelProperty(example="-----BEGIN CERTIFICATE----- .... -----END CERTIFICATE-----", value="PEM-formatted certificate chain of the Certificate Authority used to verify remote server. If empty, Rockset, will use publicly trusted CAs")
    public String getCaCert() {
        return this.caCert;
    }

    public void setCaCert(String caCert) {
        this.caCert = caCert;
    }

    public TLSConfig clientCert(String clientCert) {
        this.clientCert = clientCert;
        return this;
    }

    @JsonProperty(value="client_cert")
    @ApiModelProperty(example="-----BEGIN CERTIFICATE----- .... -----END CERTIFICATE-----", required=true, value="PEM-formatted certificate chain to use for client authentication")
    public String getClientCert() {
        return this.clientCert;
    }

    public void setClientCert(String clientCert) {
        this.clientCert = clientCert;
    }

    @JsonProperty(value="client_cert_expiry")
    @ApiModelProperty(example="1695426751", value="Expiration date of the client certificate (represented as number of ms since epoch)")
    public Long getClientCertExpiry() {
        return this.clientCertExpiry;
    }

    @JsonProperty(value="client_cert_subject")
    @ApiModelProperty(example="CN=Sample Cert, OU=R&D, O=Company Ltd.", value="Subject of the client certificate, containing common name and other attributes")
    public String getClientCertSubject() {
        return this.clientCertSubject;
    }

    public TLSConfig clientKey(String clientKey) {
        this.clientKey = clientKey;
        return this;
    }

    @JsonProperty(value="client_key")
    @ApiModelProperty(example="-----BEGIN RSA PRIVATE KEY----- ... -----END RSA PRIVATE KEY-----", required=true, value="PEM-formatted private key to be used for client authentication")
    public String getClientKey() {
        return this.clientKey;
    }

    public void setClientKey(String clientKey) {
        this.clientKey = clientKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TLSConfig tlSConfig = (TLSConfig)o;
        return Objects.equals(this.caCert, tlSConfig.caCert) && Objects.equals(this.clientCert, tlSConfig.clientCert) && Objects.equals(this.clientCertExpiry, tlSConfig.clientCertExpiry) && Objects.equals(this.clientCertSubject, tlSConfig.clientCertSubject) && Objects.equals(this.clientKey, tlSConfig.clientKey);
    }

    public int hashCode() {
        return Objects.hash(this.caCert, this.clientCert, this.clientCertExpiry, this.clientCertSubject, this.clientKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TLSConfig {\n");
        sb.append("    caCert: ").append(this.toIndentedString(this.caCert)).append("\n");
        sb.append("    clientCert: ").append(this.toIndentedString(this.clientCert)).append("\n");
        sb.append("    clientCertExpiry: ").append(this.toIndentedString(this.clientCertExpiry)).append("\n");
        sb.append("    clientCertSubject: ").append(this.toIndentedString(this.clientCertSubject)).append("\n");
        sb.append("    clientKey: ").append(this.toIndentedString(this.clientKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

