/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class UpdateApiKeyRequest {
    @SerializedName(value="clear_expiry_time")
    private Boolean clearExpiryTime = null;
    @SerializedName(value="expiry_time")
    private String expiryTime = null;
    @SerializedName(value="state")
    private StateEnum state = null;

    public UpdateApiKeyRequest clearExpiryTime(Boolean clearExpiryTime) {
        this.clearExpiryTime = clearExpiryTime;
        return this;
    }

    @JsonProperty(value="clear_expiry_time")
    @ApiModelProperty(example="true", value="If set to true, the expiration time for this key will be cleared.")
    public Boolean isClearExpiryTime() {
        return this.clearExpiryTime;
    }

    public void setClearExpiryTime(Boolean clearExpiryTime) {
        this.clearExpiryTime = clearExpiryTime;
    }

    public UpdateApiKeyRequest expiryTime(String expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    @JsonProperty(value="expiry_time")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="If provided, the API key will automatically expire at this time (ISO-8601 format). Requires premium.")
    public String getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(String expiryTime) {
        this.expiryTime = expiryTime;
    }

    public UpdateApiKeyRequest state(StateEnum state) {
        this.state = state;
        return this;
    }

    @JsonProperty(value="state")
    @ApiModelProperty(example="ACTIVE", value="State that the api key should be set to.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateApiKeyRequest updateApiKeyRequest = (UpdateApiKeyRequest)o;
        return Objects.equals(this.clearExpiryTime, updateApiKeyRequest.clearExpiryTime) && Objects.equals(this.expiryTime, updateApiKeyRequest.expiryTime) && Objects.equals((Object)this.state, (Object)updateApiKeyRequest.state);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clearExpiryTime, this.expiryTime, this.state});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateApiKeyRequest {\n");
        sb.append("    clearExpiryTime: ").append(this.toIndentedString(this.clearExpiryTime)).append("\n");
        sb.append("    expiryTime: ").append(this.toIndentedString(this.expiryTime)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        ACTIVE("ACTIVE"),
        SUSPENDED("SUSPENDED");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String text) {
            for (StateEnum b : StateEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

