/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class UpdateScheduledLambdaRequest {
    @SerializedName(value="apikey")
    private String apikey = null;
    @SerializedName(value="resume_permanent_error")
    private Boolean resumePermanentError = null;
    @SerializedName(value="total_times_to_execute")
    private Long totalTimesToExecute = null;
    @SerializedName(value="webhook_auth_header")
    private String webhookAuthHeader = null;
    @SerializedName(value="webhook_payload")
    private String webhookPayload = null;
    @SerializedName(value="webhook_url")
    private String webhookUrl = null;

    public UpdateScheduledLambdaRequest apikey(String apikey) {
        this.apikey = apikey;
        return this;
    }

    @JsonProperty(value="apikey")
    @ApiModelProperty(example="qoiwkjndksd", value="The apikey to use when triggering execution of the associated query lambda.")
    public String getApikey() {
        return this.apikey;
    }

    public void setApikey(String apikey) {
        this.apikey = apikey;
    }

    public UpdateScheduledLambdaRequest resumePermanentError(Boolean resumePermanentError) {
        this.resumePermanentError = resumePermanentError;
        return this;
    }

    @JsonProperty(value="resume_permanent_error")
    @ApiModelProperty(value="Boolean flag to allow a scheduled query lambda to resume execution after being suspended due to execution failure. This flag will be unset after scheduled lambda execution.")
    public Boolean isResumePermanentError() {
        return this.resumePermanentError;
    }

    public void setResumePermanentError(Boolean resumePermanentError) {
        this.resumePermanentError = resumePermanentError;
    }

    public UpdateScheduledLambdaRequest totalTimesToExecute(Long totalTimesToExecute) {
        this.totalTimesToExecute = totalTimesToExecute;
        return this;
    }

    @JsonProperty(value="total_times_to_execute")
    @ApiModelProperty(example="1", value="The number of times to execute this scheduled query lambda.")
    public Long getTotalTimesToExecute() {
        return this.totalTimesToExecute;
    }

    public void setTotalTimesToExecute(Long totalTimesToExecute) {
        this.totalTimesToExecute = totalTimesToExecute;
    }

    public UpdateScheduledLambdaRequest webhookAuthHeader(String webhookAuthHeader) {
        this.webhookAuthHeader = webhookAuthHeader;
        return this;
    }

    @JsonProperty(value="webhook_auth_header")
    @ApiModelProperty(example="bearer qiowjkjkdskdskldio", value="The value to use as the authorization header when hitting the webhook.")
    public String getWebhookAuthHeader() {
        return this.webhookAuthHeader;
    }

    public void setWebhookAuthHeader(String webhookAuthHeader) {
        this.webhookAuthHeader = webhookAuthHeader;
    }

    public UpdateScheduledLambdaRequest webhookPayload(String webhookPayload) {
        this.webhookPayload = webhookPayload;
        return this;
    }

    @JsonProperty(value="webhook_payload")
    @ApiModelProperty(value="The payload that should be sent to the webhook. JSON format.")
    public String getWebhookPayload() {
        return this.webhookPayload;
    }

    public void setWebhookPayload(String webhookPayload) {
        this.webhookPayload = webhookPayload;
    }

    public UpdateScheduledLambdaRequest webhookUrl(String webhookUrl) {
        this.webhookUrl = webhookUrl;
        return this;
    }

    @JsonProperty(value="webhook_url")
    @ApiModelProperty(example="https://hooks.slack.com/services/T00000000/B00000000/XXXXXXXXXXXXXXXXXXXXXXXX", value="The URL of the webhook that should be triggered after this scheduled query lambda completes.")
    public String getWebhookUrl() {
        return this.webhookUrl;
    }

    public void setWebhookUrl(String webhookUrl) {
        this.webhookUrl = webhookUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateScheduledLambdaRequest updateScheduledLambdaRequest = (UpdateScheduledLambdaRequest)o;
        return Objects.equals(this.apikey, updateScheduledLambdaRequest.apikey) && Objects.equals(this.resumePermanentError, updateScheduledLambdaRequest.resumePermanentError) && Objects.equals(this.totalTimesToExecute, updateScheduledLambdaRequest.totalTimesToExecute) && Objects.equals(this.webhookAuthHeader, updateScheduledLambdaRequest.webhookAuthHeader) && Objects.equals(this.webhookPayload, updateScheduledLambdaRequest.webhookPayload) && Objects.equals(this.webhookUrl, updateScheduledLambdaRequest.webhookUrl);
    }

    public int hashCode() {
        return Objects.hash(this.apikey, this.resumePermanentError, this.totalTimesToExecute, this.webhookAuthHeader, this.webhookPayload, this.webhookUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateScheduledLambdaRequest {\n");
        sb.append("    apikey: ").append(this.toIndentedString(this.apikey)).append("\n");
        sb.append("    resumePermanentError: ").append(this.toIndentedString(this.resumePermanentError)).append("\n");
        sb.append("    totalTimesToExecute: ").append(this.toIndentedString(this.totalTimesToExecute)).append("\n");
        sb.append("    webhookAuthHeader: ").append(this.toIndentedString(this.webhookAuthHeader)).append("\n");
        sb.append("    webhookPayload: ").append(this.toIndentedString(this.webhookPayload)).append("\n");
        sb.append("    webhookUrl: ").append(this.toIndentedString(this.webhookUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

