/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class User {
    @SerializedName(value="created_at")
    private String createdAt = null;
    @SerializedName(value="email")
    private String email = null;
    @SerializedName(value="first_name")
    private String firstName = null;
    @SerializedName(value="last_name")
    private String lastName = null;
    @SerializedName(value="roles")
    private List<String> roles = null;
    @SerializedName(value="state")
    private String state = null;

    public User createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @JsonProperty(value="created_at")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="ISO-8601 date.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public User email(String email) {
        this.email = email;
        return this;
    }

    @JsonProperty(value="email")
    @ApiModelProperty(example="hello@rockset.com", required=true, value="User email.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public User firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @JsonProperty(value="first_name")
    @ApiModelProperty(example="John", value="User first name.")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public User lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @JsonProperty(value="last_name")
    @ApiModelProperty(example="Doe", value="User last name.")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public User roles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public User addRolesItem(String rolesItem) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        this.roles.add(rolesItem);
        return this;
    }

    @JsonProperty(value="roles")
    @ApiModelProperty(example="\"[\\\"admin\\\", \\\"member\\\", \\\"read-only\\\"]\"", value="List of roles for a given user.")
    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public User state(String state) {
        this.state = state;
        return this;
    }

    @JsonProperty(value="state")
    @ApiModelProperty(example="ACTIVE", value="State of user - NEW / ACTIVE.")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.createdAt, user.createdAt) && Objects.equals(this.email, user.email) && Objects.equals(this.firstName, user.firstName) && Objects.equals(this.lastName, user.lastName) && Objects.equals(this.roles, user.roles) && Objects.equals(this.state, user.state);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.email, this.firstName, this.lastName, this.roles, this.state);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class User {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

