/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class View {
    @SerializedName(value="created_at")
    private String createdAt = null;
    @SerializedName(value="created_by_apikey_name")
    private String createdByApikeyName = null;
    @SerializedName(value="creator_email")
    private String creatorEmail = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="entities")
    private List<String> entities = null;
    @SerializedName(value="modified_at")
    private String modifiedAt = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="owner_email")
    private String ownerEmail = null;
    @SerializedName(value="path")
    private String path = null;
    @SerializedName(value="query_sql")
    private String querySql = null;
    @SerializedName(value="state")
    private StateEnum state = null;
    @SerializedName(value="workspace")
    private String workspace = null;

    public View createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @JsonProperty(value="created_at")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="ISO-8601 date.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public View createdByApikeyName(String createdByApikeyName) {
        this.createdByApikeyName = createdByApikeyName;
        return this;
    }

    @JsonProperty(value="created_by_apikey_name")
    @ApiModelProperty(value="Name of the API key that was used to create this object if one was used.")
    public String getCreatedByApikeyName() {
        return this.createdByApikeyName;
    }

    public void setCreatedByApikeyName(String createdByApikeyName) {
        this.createdByApikeyName = createdByApikeyName;
    }

    public View creatorEmail(String creatorEmail) {
        this.creatorEmail = creatorEmail;
        return this;
    }

    @JsonProperty(value="creator_email")
    @ApiModelProperty(example="xyz@rockset.com", value="Email of the creator.")
    public String getCreatorEmail() {
        return this.creatorEmail;
    }

    public void setCreatorEmail(String creatorEmail) {
        this.creatorEmail = creatorEmail;
    }

    public View description(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="description")
    @ApiModelProperty(example="view referencing collection in workspace", value="View description.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public View entities(List<String> entities) {
        this.entities = entities;
        return this;
    }

    public View addEntitiesItem(String entitiesItem) {
        if (this.entities == null) {
            this.entities = new ArrayList<String>();
        }
        this.entities.add(entitiesItem);
        return this;
    }

    @JsonProperty(value="entities")
    @ApiModelProperty(example="\"[\\\"common.foo_view\\\", \\\"prod.demo_alias\\\", \\\"dev.user_collection\\\"]\"", value="List of entities referenced by view. An entity can be a view, alias or collection.")
    public List<String> getEntities() {
        return this.entities;
    }

    public void setEntities(List<String> entities) {
        this.entities = entities;
    }

    public View modifiedAt(String modifiedAt) {
        this.modifiedAt = modifiedAt;
        return this;
    }

    @JsonProperty(value="modified_at")
    @ApiModelProperty(example="2001-08-28T00:23:42Z", value="ISO-8601 date.")
    public String getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(String modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public View name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @ApiModelProperty(example="demo", value="Name of the view.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public View ownerEmail(String ownerEmail) {
        this.ownerEmail = ownerEmail;
        return this;
    }

    @JsonProperty(value="owner_email")
    @ApiModelProperty(example="abc@rockset.com", value="Email of the owner, note: deprecated and will always be null.")
    public String getOwnerEmail() {
        return this.ownerEmail;
    }

    public void setOwnerEmail(String ownerEmail) {
        this.ownerEmail = ownerEmail;
    }

    public View path(String path) {
        this.path = path;
        return this;
    }

    @JsonProperty(value="path")
    @ApiModelProperty(value="")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public View querySql(String querySql) {
        this.querySql = querySql;
        return this;
    }

    @JsonProperty(value="query_sql")
    @ApiModelProperty(example="SELECT * FROM commons.foo", value="SQL query of the view.")
    public String getQuerySql() {
        return this.querySql;
    }

    public void setQuerySql(String querySql) {
        this.querySql = querySql;
    }

    public View state(StateEnum state) {
        this.state = state;
        return this;
    }

    @JsonProperty(value="state")
    @ApiModelProperty(example="CREATED", value="State of the view.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public View workspace(String workspace) {
        this.workspace = workspace;
        return this;
    }

    @JsonProperty(value="workspace")
    @ApiModelProperty(example="commons", value="Name of the workspace.")
    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        View view = (View)o;
        return Objects.equals(this.createdAt, view.createdAt) && Objects.equals(this.createdByApikeyName, view.createdByApikeyName) && Objects.equals(this.creatorEmail, view.creatorEmail) && Objects.equals(this.description, view.description) && Objects.equals(this.entities, view.entities) && Objects.equals(this.modifiedAt, view.modifiedAt) && Objects.equals(this.name, view.name) && Objects.equals(this.ownerEmail, view.ownerEmail) && Objects.equals(this.path, view.path) && Objects.equals(this.querySql, view.querySql) && Objects.equals((Object)this.state, (Object)view.state) && Objects.equals(this.workspace, view.workspace);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.createdAt, this.createdByApikeyName, this.creatorEmail, this.description, this.entities, this.modifiedAt, this.name, this.ownerEmail, this.path, this.querySql, this.state, this.workspace});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class View {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    createdByApikeyName: ").append(this.toIndentedString(this.createdByApikeyName)).append("\n");
        sb.append("    creatorEmail: ").append(this.toIndentedString(this.creatorEmail)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    entities: ").append(this.toIndentedString(this.entities)).append("\n");
        sb.append("    modifiedAt: ").append(this.toIndentedString(this.modifiedAt)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    ownerEmail: ").append(this.toIndentedString(this.ownerEmail)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    querySql: ").append(this.toIndentedString(this.querySql)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    workspace: ").append(this.toIndentedString(this.workspace)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        CREATED("CREATED"),
        SYNCING("SYNCING"),
        DELETED("DELETED");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String text) {
            for (StateEnum b : StateEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

