/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.rockset.client.model.AutoScalingPolicy;
import com.rockset.client.model.VirtualInstanceStats;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class VirtualInstance {
    @SerializedName(value="auto_scaling_policy")
    private AutoScalingPolicy autoScalingPolicy = null;
    @SerializedName(value="auto_suspend_seconds")
    private Integer autoSuspendSeconds = null;
    @SerializedName(value="created_at")
    private String createdAt = null;
    @SerializedName(value="created_by")
    private String createdBy = null;
    @SerializedName(value="current_size")
    private CurrentSizeEnum currentSize = null;
    @SerializedName(value="default_pod_count")
    private Integer defaultPodCount = null;
    @SerializedName(value="default_vi")
    private Boolean defaultVi = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="desired_size")
    private DesiredSizeEnum desiredSize = null;
    @SerializedName(value="enable_remount_on_resume")
    private Boolean enableRemountOnResume = null;
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="monitoring_enabled")
    private Boolean monitoringEnabled = null;
    @SerializedName(value="mount_refresh_interval_seconds")
    private Integer mountRefreshIntervalSeconds = null;
    @SerializedName(value="mount_type")
    private MountTypeEnum mountType = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="resumed_at")
    private String resumedAt = null;
    @SerializedName(value="rrn")
    private String rrn = null;
    @SerializedName(value="scaled_pod_count")
    private Integer scaledPodCount = null;
    @SerializedName(value="state")
    private StateEnum state = null;
    @SerializedName(value="stats")
    private VirtualInstanceStats stats = null;

    public VirtualInstance autoScalingPolicy(AutoScalingPolicy autoScalingPolicy) {
        this.autoScalingPolicy = autoScalingPolicy;
        return this;
    }

    @JsonProperty(value="auto_scaling_policy")
    @ApiModelProperty(value="Options for configuring auto scaling policy")
    public AutoScalingPolicy getAutoScalingPolicy() {
        return this.autoScalingPolicy;
    }

    public void setAutoScalingPolicy(AutoScalingPolicy autoScalingPolicy) {
        this.autoScalingPolicy = autoScalingPolicy;
    }

    public VirtualInstance autoSuspendSeconds(Integer autoSuspendSeconds) {
        this.autoSuspendSeconds = autoSuspendSeconds;
        return this;
    }

    @JsonProperty(value="auto_suspend_seconds")
    @ApiModelProperty(example="3600", value="Number of seconds without queries after which the VI is suspended")
    public Integer getAutoSuspendSeconds() {
        return this.autoSuspendSeconds;
    }

    public void setAutoSuspendSeconds(Integer autoSuspendSeconds) {
        this.autoSuspendSeconds = autoSuspendSeconds;
    }

    public VirtualInstance createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @JsonProperty(value="created_at")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="ISO-8601 date of when virtual instance was created.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public VirtualInstance createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty(value="created_by")
    @ApiModelProperty(example="hello@rockset.com", value="Creator of requested virtual instance.")
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @JsonProperty(value="current_size")
    @ApiModelProperty(example="MEDIUM", value="Virtual instance current size.")
    public CurrentSizeEnum getCurrentSize() {
        return this.currentSize;
    }

    public VirtualInstance defaultPodCount(Integer defaultPodCount) {
        this.defaultPodCount = defaultPodCount;
        return this;
    }

    @JsonProperty(value="default_pod_count")
    @ApiModelProperty(value="")
    public Integer getDefaultPodCount() {
        return this.defaultPodCount;
    }

    public void setDefaultPodCount(Integer defaultPodCount) {
        this.defaultPodCount = defaultPodCount;
    }

    public VirtualInstance defaultVi(Boolean defaultVi) {
        this.defaultVi = defaultVi;
        return this;
    }

    @JsonProperty(value="default_vi")
    @ApiModelProperty(value="")
    public Boolean isDefaultVi() {
        return this.defaultVi;
    }

    public void setDefaultVi(Boolean defaultVi) {
        this.defaultVi = defaultVi;
    }

    public VirtualInstance description(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="description")
    @ApiModelProperty(example="VI for prod traffic", value="Virtual instance description.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="desired_size")
    @ApiModelProperty(example="MEDIUM", value="Virtual instance desired size.")
    public DesiredSizeEnum getDesiredSize() {
        return this.desiredSize;
    }

    public VirtualInstance enableRemountOnResume(Boolean enableRemountOnResume) {
        this.enableRemountOnResume = enableRemountOnResume;
        return this;
    }

    @JsonProperty(value="enable_remount_on_resume")
    @ApiModelProperty(example="true", value="When a Virtual Instance is resumed, it will remount all collections that were mounted when the Virtual Instance was suspended.")
    public Boolean isEnableRemountOnResume() {
        return this.enableRemountOnResume;
    }

    public void setEnableRemountOnResume(Boolean enableRemountOnResume) {
        this.enableRemountOnResume = enableRemountOnResume;
    }

    public VirtualInstance id(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    @ApiModelProperty(example="123e4567-e89b-12d3-a456-556642440000", value="Unique identifier for virtual instance.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public VirtualInstance monitoringEnabled(Boolean monitoringEnabled) {
        this.monitoringEnabled = monitoringEnabled;
        return this;
    }

    @JsonProperty(value="monitoring_enabled")
    @ApiModelProperty(value="")
    public Boolean isMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    public void setMonitoringEnabled(Boolean monitoringEnabled) {
        this.monitoringEnabled = monitoringEnabled;
    }

    public VirtualInstance mountRefreshIntervalSeconds(Integer mountRefreshIntervalSeconds) {
        this.mountRefreshIntervalSeconds = mountRefreshIntervalSeconds;
        return this;
    }

    @JsonProperty(value="mount_refresh_interval_seconds")
    @ApiModelProperty(example="3600", value="DEPRECATED. Number of seconds between data refreshes for mounts on this Virtual Instance")
    public Integer getMountRefreshIntervalSeconds() {
        return this.mountRefreshIntervalSeconds;
    }

    public void setMountRefreshIntervalSeconds(Integer mountRefreshIntervalSeconds) {
        this.mountRefreshIntervalSeconds = mountRefreshIntervalSeconds;
    }

    public VirtualInstance mountType(MountTypeEnum mountType) {
        this.mountType = mountType;
        return this;
    }

    @JsonProperty(value="mount_type")
    @ApiModelProperty(example="LIVE", value="The mount type of collections that this Virtual Instance will query. Live mounted collections stay up-to-date with the underlying collection in real-time. Static mounted collections do not stay up-to-date. See https://docs.rockset.com/documentation/docs/virtual-instances#virtual-instance-configuration")
    public MountTypeEnum getMountType() {
        return this.mountType;
    }

    public void setMountType(MountTypeEnum mountType) {
        this.mountType = mountType;
    }

    public VirtualInstance name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @ApiModelProperty(example="prod_vi", required=true, value="Virtual instance name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public VirtualInstance resumedAt(String resumedAt) {
        this.resumedAt = resumedAt;
        return this;
    }

    @JsonProperty(value="resumed_at")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="ISO-8601 date of when virtual instance was created.")
    public String getResumedAt() {
        return this.resumedAt;
    }

    public void setResumedAt(String resumedAt) {
        this.resumedAt = resumedAt;
    }

    public VirtualInstance rrn(String rrn) {
        this.rrn = rrn;
        return this;
    }

    @JsonProperty(value="rrn")
    @ApiModelProperty(example="rrn:vi:use1a1:123e4567-e89b-12d3-a456-556642440000", value="Virtual Instance RRN.")
    public String getRrn() {
        return this.rrn;
    }

    public void setRrn(String rrn) {
        this.rrn = rrn;
    }

    public VirtualInstance scaledPodCount(Integer scaledPodCount) {
        this.scaledPodCount = scaledPodCount;
        return this;
    }

    @JsonProperty(value="scaled_pod_count")
    @ApiModelProperty(value="")
    public Integer getScaledPodCount() {
        return this.scaledPodCount;
    }

    public void setScaledPodCount(Integer scaledPodCount) {
        this.scaledPodCount = scaledPodCount;
    }

    public VirtualInstance state(StateEnum state) {
        this.state = state;
        return this;
    }

    @JsonProperty(value="state")
    @ApiModelProperty(example="ACTIVE", value="Virtual instance state.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public VirtualInstance stats(VirtualInstanceStats stats) {
        this.stats = stats;
        return this;
    }

    @JsonProperty(value="stats")
    @ApiModelProperty(value="Stats about this VirtualInstance")
    public VirtualInstanceStats getStats() {
        return this.stats;
    }

    public void setStats(VirtualInstanceStats stats) {
        this.stats = stats;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualInstance virtualInstance = (VirtualInstance)o;
        return Objects.equals(this.autoScalingPolicy, virtualInstance.autoScalingPolicy) && Objects.equals(this.autoSuspendSeconds, virtualInstance.autoSuspendSeconds) && Objects.equals(this.createdAt, virtualInstance.createdAt) && Objects.equals(this.createdBy, virtualInstance.createdBy) && Objects.equals((Object)this.currentSize, (Object)virtualInstance.currentSize) && Objects.equals(this.defaultPodCount, virtualInstance.defaultPodCount) && Objects.equals(this.defaultVi, virtualInstance.defaultVi) && Objects.equals(this.description, virtualInstance.description) && Objects.equals((Object)this.desiredSize, (Object)virtualInstance.desiredSize) && Objects.equals(this.enableRemountOnResume, virtualInstance.enableRemountOnResume) && Objects.equals(this.id, virtualInstance.id) && Objects.equals(this.monitoringEnabled, virtualInstance.monitoringEnabled) && Objects.equals(this.mountRefreshIntervalSeconds, virtualInstance.mountRefreshIntervalSeconds) && Objects.equals((Object)this.mountType, (Object)virtualInstance.mountType) && Objects.equals(this.name, virtualInstance.name) && Objects.equals(this.resumedAt, virtualInstance.resumedAt) && Objects.equals(this.rrn, virtualInstance.rrn) && Objects.equals(this.scaledPodCount, virtualInstance.scaledPodCount) && Objects.equals((Object)this.state, (Object)virtualInstance.state) && Objects.equals(this.stats, virtualInstance.stats);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.autoScalingPolicy, this.autoSuspendSeconds, this.createdAt, this.createdBy, this.currentSize, this.defaultPodCount, this.defaultVi, this.description, this.desiredSize, this.enableRemountOnResume, this.id, this.monitoringEnabled, this.mountRefreshIntervalSeconds, this.mountType, this.name, this.resumedAt, this.rrn, this.scaledPodCount, this.state, this.stats});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VirtualInstance {\n");
        sb.append("    autoScalingPolicy: ").append(this.toIndentedString(this.autoScalingPolicy)).append("\n");
        sb.append("    autoSuspendSeconds: ").append(this.toIndentedString(this.autoSuspendSeconds)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    currentSize: ").append(this.toIndentedString((Object)this.currentSize)).append("\n");
        sb.append("    defaultPodCount: ").append(this.toIndentedString(this.defaultPodCount)).append("\n");
        sb.append("    defaultVi: ").append(this.toIndentedString(this.defaultVi)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    desiredSize: ").append(this.toIndentedString((Object)this.desiredSize)).append("\n");
        sb.append("    enableRemountOnResume: ").append(this.toIndentedString(this.enableRemountOnResume)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    monitoringEnabled: ").append(this.toIndentedString(this.monitoringEnabled)).append("\n");
        sb.append("    mountRefreshIntervalSeconds: ").append(this.toIndentedString(this.mountRefreshIntervalSeconds)).append("\n");
        sb.append("    mountType: ").append(this.toIndentedString((Object)this.mountType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    resumedAt: ").append(this.toIndentedString(this.resumedAt)).append("\n");
        sb.append("    rrn: ").append(this.toIndentedString(this.rrn)).append("\n");
        sb.append("    scaledPodCount: ").append(this.toIndentedString(this.scaledPodCount)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    stats: ").append(this.toIndentedString(this.stats)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        INITIALIZING("INITIALIZING"),
        PROVISIONING_RESOURCES("PROVISIONINGRESOURCES"),
        REBALANCING_COLLECTIONS("REBALANCINGCOLLECTIONS"),
        ACTIVE("ACTIVE"),
        SUSPENDING("SUSPENDING"),
        SUSPENDED("SUSPENDED"),
        RESUMING("RESUMING"),
        DELETED("DELETED"),
        ENABLING_DEDICATED_SERVICES("ENABLINGDEDICATEDSERVICES"),
        DISABLING_DEDICATED_SERVICES("DISABLINGDEDICATEDSERVICES");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String text) {
            for (StateEnum b : StateEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MountTypeEnum {
        LIVE("LIVE"),
        STATIC("STATIC");

        private String value;

        private MountTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MountTypeEnum fromValue(String text) {
            for (MountTypeEnum b : MountTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<MountTypeEnum> {
            public void write(JsonWriter jsonWriter, MountTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public MountTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MountTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DesiredSizeEnum {
        FREE("FREE"),
        NANO("NANO"),
        SHARED("SHARED"),
        MILLI("MILLI"),
        XSMALL("XSMALL"),
        SMALL("SMALL"),
        MEDIUM("MEDIUM"),
        LARGE("LARGE"),
        XLARGE("XLARGE"),
        XLARGE2("XLARGE2"),
        XLARGE4("XLARGE4"),
        XLARGE8("XLARGE8"),
        XLARGE16("XLARGE16");

        private String value;

        private DesiredSizeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DesiredSizeEnum fromValue(String text) {
            for (DesiredSizeEnum b : DesiredSizeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<DesiredSizeEnum> {
            public void write(JsonWriter jsonWriter, DesiredSizeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DesiredSizeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DesiredSizeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CurrentSizeEnum {
        FREE("FREE"),
        NANO("NANO"),
        SHARED("SHARED"),
        MILLI("MILLI"),
        XSMALL("XSMALL"),
        SMALL("SMALL"),
        MEDIUM("MEDIUM"),
        LARGE("LARGE"),
        XLARGE("XLARGE"),
        XLARGE2("XLARGE2"),
        XLARGE4("XLARGE4"),
        XLARGE8("XLARGE8"),
        XLARGE16("XLARGE16");

        private String value;

        private CurrentSizeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CurrentSizeEnum fromValue(String text) {
            for (CurrentSizeEnum b : CurrentSizeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CurrentSizeEnum> {
            public void write(JsonWriter jsonWriter, CurrentSizeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CurrentSizeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CurrentSizeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

