/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Workspaces are organizational containers for collections.")
public class Workspace {
    @SerializedName(value="collection_count")
    private Long collectionCount = null;
    @SerializedName(value="created_at")
    private String createdAt = null;
    @SerializedName(value="created_by")
    private String createdBy = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="name")
    private String name = null;

    public Workspace collectionCount(Long collectionCount) {
        this.collectionCount = collectionCount;
        return this;
    }

    @JsonProperty(value="collection_count")
    @ApiModelProperty(example="3", value="Number of collections that are immediate children of workspace.")
    public Long getCollectionCount() {
        return this.collectionCount;
    }

    public void setCollectionCount(Long collectionCount) {
        this.collectionCount = collectionCount;
    }

    public Workspace createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @JsonProperty(value="created_at")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="ISO-8601 date of when workspace was created.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public Workspace createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty(value="created_by")
    @ApiModelProperty(example="hello@rockset.com", value="Email of user who created the workspace.")
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Workspace description(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="description")
    @ApiModelProperty(example="Datasets of system logs for the ops team.", value="Longer explanation for the workspace.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Workspace name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @ApiModelProperty(example="event_logs", value="Descriptive label and unique identifier.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Workspace workspace = (Workspace)o;
        return Objects.equals(this.collectionCount, workspace.collectionCount) && Objects.equals(this.createdAt, workspace.createdAt) && Objects.equals(this.createdBy, workspace.createdBy) && Objects.equals(this.description, workspace.description) && Objects.equals(this.name, workspace.name);
    }

    public int hashCode() {
        return Objects.hash(this.collectionCount, this.createdAt, this.createdBy, this.description, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Workspace {\n");
        sb.append("    collectionCount: ").append(this.toIndentedString(this.collectionCount)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

