/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.jdbc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.rockset.jdbc.RocksetUtils;
import java.util.Objects;

class Column {
    private final String name;
    private ColumnTypes type;

    @JsonCreator
    public Column(@JsonProperty(value="name") String name, @JsonProperty(value="type") ColumnTypes type) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public ColumnTypes getType() {
        return this.type;
    }

    public String toString() {
        return String.format("(name=%s, jsontype=%s sqltype=%s)", this.getName(), this.getType().toString(), RocksetUtils.jsonToSqlType(this.getType()));
    }

    public static enum ColumnTypes {
        ARRAY("ARRAY"),
        BINARY("BINARY"),
        BOOLEAN("BOOLEAN"),
        MISSING("MISSING"),
        NULL("NULL"),
        NUMBER("NUMBER"),
        OBJECT("OBJECT"),
        POJO("POJO"),
        STRING("STRING"),
        DATE("DATE"),
        TIME("TIME"),
        DATETIME("DATETIME"),
        TIMESTAMP("TIMESTAMP"),
        U256("U256");

        private String value;

        public static ColumnTypes fromValue(String text) {
            for (ColumnTypes ct : ColumnTypes.values()) {
                if (!String.valueOf(ct.value).equals(text)) continue;
                return ct;
            }
            return null;
        }

        private ColumnTypes(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

