/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.jdbc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import com.rockset.jdbc.AbstractConnectionProperty;
import com.rockset.jdbc.ConnectionProperty;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

final class ConnectionProperties {
    public static final ConnectionProperty<String> USER = new User();
    public static final ConnectionProperty<String> PASSWORD = new Password();
    public static final ConnectionProperty<HostAndPort> SOCKS_PROXY = new SocksProxy();
    public static final ConnectionProperty<HostAndPort> HTTP_PROXY = new HttpProxy();
    public static final ConnectionProperty<Boolean> SSL = new Ssl();
    public static final ConnectionProperty<String> SSL_TRUST_STORE_PATH = new SslTrustStorePath();
    public static final ConnectionProperty<String> SSL_TRUST_STORE_PASSWORD = new SslTrustStorePassword();
    private static final Set<ConnectionProperty<?>> ALL_PROPERTIES = ImmutableSet.builder().add(USER).add(PASSWORD).add(SOCKS_PROXY).add(HTTP_PROXY).add(SSL).add(SSL_TRUST_STORE_PATH).add(SSL_TRUST_STORE_PASSWORD).build();
    private static final Map<String, ConnectionProperty<?>> KEY_LOOKUP = Collections.unmodifiableMap(ALL_PROPERTIES.stream().collect(Collectors.toMap(ConnectionProperty::getKey, Function.identity())));
    private static final Map<String, String> DEFAULTS;

    private ConnectionProperties() {
    }

    public static ConnectionProperty<?> forKey(String propertiesKey) {
        return KEY_LOOKUP.get(propertiesKey);
    }

    public static Set<ConnectionProperty<?>> allProperties() {
        return ALL_PROPERTIES;
    }

    public static Map<String, String> getDefaults() {
        return DEFAULTS;
    }

    static {
        ImmutableMap.Builder defaults = ImmutableMap.builder();
        for (ConnectionProperty<?> property : ALL_PROPERTIES) {
            property.getDefault().ifPresent(value -> defaults.put((Object)property.getKey(), value));
        }
        DEFAULTS = defaults.build();
    }

    private static class SslTrustStorePassword
    extends AbstractConnectionProperty<String> {
        private static final Predicate<Properties> IF_TRUST_STORE = SslTrustStorePassword.checkedPredicate(properties -> SSL_TRUST_STORE_PATH.getValue((Properties)properties).isPresent());

        public SslTrustStorePassword() {
            super("SSLTrustStorePassword", NOT_REQUIRED, IF_TRUST_STORE, STRING_CONVERTER);
        }
    }

    private static class SslTrustStorePath
    extends AbstractConnectionProperty<String> {
        private static final Predicate<Properties> IF_SSL_ENABLED = SslTrustStorePath.checkedPredicate(properties -> SSL.getValue((Properties)properties).orElse(false));

        public SslTrustStorePath() {
            super("SSLTrustStorePath", NOT_REQUIRED, IF_SSL_ENABLED, STRING_CONVERTER);
        }
    }

    private static class Ssl
    extends AbstractConnectionProperty<Boolean> {
        public Ssl() {
            super("SSL", Optional.of("false"), NOT_REQUIRED, ALLOWED, BOOLEAN_CONVERTER);
        }
    }

    private static class HttpProxy
    extends AbstractConnectionProperty<HostAndPort> {
        private static final Predicate<Properties> NO_SOCKS_PROXY = HttpProxy.checkedPredicate(properties -> !SOCKS_PROXY.getValue((Properties)properties).isPresent());

        public HttpProxy() {
            super("httpProxy", NOT_REQUIRED, NO_SOCKS_PROXY, HostAndPort::fromString);
        }
    }

    private static class SocksProxy
    extends AbstractConnectionProperty<HostAndPort> {
        private static final Predicate<Properties> NO_HTTP_PROXY = SocksProxy.checkedPredicate(properties -> !HTTP_PROXY.getValue((Properties)properties).isPresent());

        public SocksProxy() {
            super("socksProxy", NOT_REQUIRED, NO_HTTP_PROXY, HostAndPort::fromString);
        }
    }

    private static class Password
    extends AbstractConnectionProperty<String> {
        public Password() {
            super("password", NOT_REQUIRED, ALLOWED, STRING_CONVERTER);
        }
    }

    private static class User
    extends AbstractConnectionProperty<String> {
        public User() {
            super("user", REQUIRED, ALLOWED, NON_EMPTY_STRING_CONVERTER);
        }
    }
}

