/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.jdbc;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

final class LengthLimitedIterator<T>
implements Iterator<T> {
    private final Iterator<T> iterator;
    private final long limit;
    private long count;

    public LengthLimitedIterator(Iterator<T> iterator, long limit) {
        Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"limit is negative");
        this.iterator = Objects.requireNonNull(iterator, "iterator is null");
        this.limit = limit;
    }

    @Override
    public boolean hasNext() {
        return this.count < this.limit && this.iterator.hasNext();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.count;
        return this.iterator.next();
    }
}

