/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.jdbc;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.primitives.Ints;
import com.rockset.jdbc.Column;
import com.rockset.jdbc.RocksetUtils;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class RocksetArray
implements Array {
    private final String elementTypeName;
    private final int elementType;
    private final JsonNode[] array;

    RocksetArray(List<?> array) {
        Objects.requireNonNull(array, "array is null");
        JsonNode[] tmp = new JsonNode[array.size()];
        this.array = array.toArray(tmp);
        if (this.array.length > 0) {
            Column.ColumnTypes n = Column.ColumnTypes.valueOf(this.array[0].getNodeType().toString());
            this.elementTypeName = RocksetUtils.jsonToSqlTypeName(n);
            this.elementType = RocksetUtils.jsonToSqlType(n);
        } else {
            this.elementTypeName = "array";
            this.elementType = 2003;
        }
    }

    @Override
    public String getBaseTypeName() {
        return this.elementTypeName;
    }

    @Override
    public int getBaseType() {
        return this.elementType;
    }

    @Override
    public Object getArray() {
        JsonNode[] tmp = new JsonNode[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            tmp[i] = this.array[i].deepCopy();
        }
        return tmp;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("getArray not supported");
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        int arrayOffset = Ints.saturatedCast((long)(index - 1L));
        if (index < 1L || count < 0 || arrayOffset + count > this.array.length) {
            throw new SQLException("Index out of bounds");
        }
        JsonNode[] tmp = new JsonNode[count];
        for (int i = (int)(--index); i < (int)(index + (long)count); ++i) {
            tmp[i] = this.array[i].deepCopy();
        }
        return tmp;
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("getArray not supported");
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        throw new SQLFeatureNotSupportedException("getResultSet not supported");
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("getResultSet not supported");
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        throw new SQLFeatureNotSupportedException("getResultSet not supported");
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("getResultSet not supported");
    }

    @Override
    public void free() {
    }

    int size() {
        return this.array.length;
    }
}

