/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.rockset.client.RocksetClient;
import com.rockset.client.model.Collection;
import com.rockset.client.model.QueryPaginationResponse;
import com.rockset.client.model.QueryParameter;
import com.rockset.client.model.QueryRequest;
import com.rockset.client.model.QueryRequestSql;
import com.rockset.client.model.QueryResponse;
import com.rockset.client.model.Workspace;
import com.rockset.jdbc.NotImplementedException;
import com.rockset.jdbc.RocksetDatabaseMetaData;
import com.rockset.jdbc.RocksetDriver;
import com.rockset.jdbc.RocksetPreparedStatement;
import com.rockset.jdbc.RocksetStatement;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class RocksetConnection
implements Connection {
    public static final String DEFAULT_CATALOG = "rockset";
    public static final String DEFAULT_SCHEMA = "commons";
    private static final String DEFAULT_FETCH_SIZE = "defaultRowFetchSize";
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicReference<String> catalog = new AtomicReference();
    private final AtomicReference<String> schema = new AtomicReference();
    private final AtomicReference<String> timeZoneId = new AtomicReference();
    private final AtomicReference<Locale> locale = new AtomicReference();
    private final AtomicLong nextStatementId = new AtomicLong(1L);
    private final AtomicInteger fetchSize = new AtomicInteger(0);
    private final URI uri;
    private final String user;
    private final Map<String, String> clientInfo = new ConcurrentHashMap<String, String>();
    private final Map<String, String> sessionProperties = new ConcurrentHashMap<String, String>();
    private RocksetClient client;

    RocksetConnection(URI uri, Properties info) throws SQLException {
        Objects.requireNonNull(uri, "uri is null");
        this.uri = uri;
        this.user = uri.getUserInfo();
        this.schema.set(DEFAULT_SCHEMA);
        this.catalog.set(DEFAULT_CATALOG);
        String apiKey = RocksetConnection.getApiKey(info);
        String apiServer = RocksetConnection.getApiServer(uri, info);
        this.client = new RocksetClient(apiKey, apiServer, "jdbc");
        this.fetchSize.set(RocksetConnection.getFetchSizeFromProperty(info));
        this.timeZoneId.set(TimeZone.getDefault().getID());
        this.locale.set(Locale.getDefault());
    }

    @Override
    public Statement createStatement() throws SQLException {
        RocksetDriver.log("Entry: createStatement ");
        this.checkOpen();
        return new RocksetStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        RocksetDriver.log("Entry: prepareStatement ");
        this.checkOpen();
        String name = "statement" + this.nextStatementId.getAndIncrement();
        return new RocksetPreparedStatement(this, name, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new NotImplementedException("Connection", "prepareCall");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkOpen();
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkOpen();
        if (!autoCommit) {
            throw new SQLFeatureNotSupportedException("Disabling auto-commit mode not supported");
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return true;
    }

    @Override
    public void commit() throws SQLException {
        this.checkOpen();
        if (this.getAutoCommit()) {
            throw new SQLException("Connection is in auto-commit mode");
        }
        throw new NotImplementedException("Connection", "commit");
    }

    @Override
    public void rollback() throws SQLException {
        this.checkOpen();
        if (this.getAutoCommit()) {
            throw new SQLException("Connection is in auto-commit mode");
        }
        throw new NotImplementedException("Connection", "rollback");
    }

    @Override
    public void close() throws SQLException {
        this.closed.set(true);
        this.client = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed.get();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new RocksetDatabaseMetaData(this);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkOpen();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkOpen();
        this.catalog.set(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkOpen();
        return this.catalog.get();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Dhruba says that you are crazy cool!");
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkOpen();
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        RocksetDriver.log("Entry: createStatement  resultSetType " + resultSetType + " resultSetConcurrency " + resultSetConcurrency);
        RocksetConnection.checkResultSet(resultSetType, resultSetConcurrency);
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        RocksetDriver.log("Entry: prepareStatement  sql " + sql + " resultSetType " + resultSetType + " resultSetConcurrency " + resultSetConcurrency);
        RocksetConnection.checkResultSet(resultSetType, resultSetConcurrency);
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        RocksetConnection.checkResultSet(resultSetType, resultSetConcurrency);
        throw new SQLFeatureNotSupportedException("prepareCall");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLFeatureNotSupportedException("getTypeMap");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("setTypeMap");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkOpen();
        if (holdability != 1) {
            throw new SQLFeatureNotSupportedException("Changing holdability not supported");
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkOpen();
        return 1;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException("setSavepoint");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("setSavepoint");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("rollback");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("releaseSavepoint");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        RocksetDriver.log("Entry: createStatement  resultSetType " + resultSetType + " resultSetConcurrency " + resultSetConcurrency + " resultSetHoldability " + resultSetHoldability);
        RocksetConnection.checkHoldability(resultSetHoldability);
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        RocksetDriver.log("Entry: prepareStatement  sql " + sql + " resultSetType " + resultSetType + " resultSetConcurrency " + resultSetConcurrency + " resultSetHoldability " + resultSetHoldability);
        RocksetConnection.checkHoldability(resultSetHoldability);
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        RocksetConnection.checkHoldability(resultSetHoldability);
        return this.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        RocksetDriver.log("Entry: prepareStatement  sql " + sql + " autoGeneratedKeys " + autoGeneratedKeys);
        if (autoGeneratedKeys != 1) {
            throw new SQLFeatureNotSupportedException("Auto generated keys must be NO_GENERATED_KEYS");
        }
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        RocksetDriver.log("Entry: prepareStatement  sql " + sql + " columnIndexes ");
        throw new SQLFeatureNotSupportedException("prepareStatement");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        RocksetDriver.log("Entry: prepareStatement  sql " + sql + " columnNames ");
        throw new SQLFeatureNotSupportedException("prepareStatement");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("createClob");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException("createBlob");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("createNClob");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException("createSQLXML");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("Timeout is negative");
        }
        return !this.isClosed();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        Objects.requireNonNull(name, "name is null");
        if (value != null) {
            this.clientInfo.put(name, value);
        } else {
            this.clientInfo.remove(name);
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.clientInfo.putAll((Map<String, String>)Maps.fromProperties((Properties)properties));
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.clientInfo.get(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : this.clientInfo.entrySet()) {
            properties.setProperty(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLFeatureNotSupportedException("createArrayOf");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException("createStruct");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkOpen();
        RocksetDriver.log("setSchema() setting schema to " + schema);
        this.schema.set(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkOpen();
        return this.schema.get();
    }

    public String getTimeZoneId() {
        return this.timeZoneId.get();
    }

    public void setTimeZoneId(String timeZoneId) {
        Objects.requireNonNull(timeZoneId, "timeZoneId is null");
        this.timeZoneId.set(timeZoneId);
    }

    public Locale getLocale() {
        return this.locale.get();
    }

    public void setLocale(Locale locale) {
        this.locale.set(locale);
    }

    public void setSessionProperty(String name, String value) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(value, "value is null");
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"name is empty");
        CharsetEncoder charsetEncoder = StandardCharsets.US_ASCII.newEncoder();
        Preconditions.checkArgument((name.indexOf(61) < 0 ? 1 : 0) != 0, (String)"Session property name must not contain '=': %s", (Object)name);
        Preconditions.checkArgument((boolean)charsetEncoder.canEncode(name), (String)"Session property name is not US_ASCII: %s", (Object)name);
        Preconditions.checkArgument((boolean)charsetEncoder.canEncode(value), (String)"Session property value is not US_ASCII: %s", (Object)value);
        this.sessionProperties.put(name, value);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNetworkTimeout");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException("getNetworkTimeout");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException("No wrapper for " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    int getFetchSize() {
        return this.fetchSize.get();
    }

    URI getUri() {
        return this.uri;
    }

    String getUser() {
        return this.user;
    }

    QueryResponse startQuery(String sql, int fetchSize, List<QueryParameter> params, Map<String, String> sessionPropertiesOverride) throws Exception {
        QueryRequestSql q = new QueryRequestSql().query(sql);
        if (fetchSize > 0) {
            q.initialPaginateResponseDocCount(fetchSize);
        }
        if (params != null) {
            q.parameters(params);
        }
        QueryRequest request = new QueryRequest().sql(q);
        return this.client.queries.query(request);
    }

    QueryPaginationResponse getQueryPaginationResults(String queryId, String cursor, int fetchSize) throws Exception {
        return this.client.queries.get_0(queryId, cursor, fetchSize, 0);
    }

    QueryPaginationResponse getQueryPaginationResults(String queryId, String cursor, int fetchSize, int offset) throws Exception {
        return this.client.queries.get_0(queryId, cursor, fetchSize, offset);
    }

    List<Collection> listCollections(String schema) throws Exception {
        return this.client.collections.workspace(schema).getData();
    }

    List<Collection> listCollections() throws Exception {
        return this.listCollections(this.getSchema());
    }

    String quoteIdentifier(String value) {
        String result = "\"";
        result = result + value;
        result = result + "\"";
        return result;
    }

    QueryResponse describeTable(String schema, String name) throws Exception {
        RocksetDriver.log("Entry: describeTable " + name);
        String sql = String.format("describe %s.%s OPTION(max_field_depth=1)", this.quoteIdentifier(schema), this.quoteIdentifier(name));
        QueryResponse resp = this.startQuery(sql, 0, null, null);
        RocksetDriver.log("Exit: describeTable " + name);
        return resp;
    }

    QueryResponse describeTable(String name) throws Exception {
        return this.describeTable(this.getSchema(), name);
    }

    List<String> getWorkspaces() throws Exception {
        return this.client.workspaces.list().getData().stream().map(Workspace::getName).collect(Collectors.toList());
    }

    private static int getFetchSizeFromProperty(Properties info) {
        String fetchSizeStr = info.getProperty(DEFAULT_FETCH_SIZE);
        if (fetchSizeStr == null) {
            return 0;
        }
        try {
            return Integer.parseInt(fetchSizeStr);
        }
        catch (NumberFormatException e) {
            RocksetDriver.log(String.format("Invalid fetch size %s, reverting to 0", fetchSizeStr));
            return 0;
        }
    }

    private static String getApiKey(Properties info) {
        String apiKey = info.getProperty("apiKey");
        if (apiKey == null) {
            apiKey = info.getProperty("apikey");
        }
        if (info.getProperty("user") != null && info.getProperty("user").toLowerCase().equals("apikey")) {
            apiKey = info.getProperty("password");
        }
        return apiKey;
    }

    private static String getApiServer(URI uri, Properties info) {
        String apiServer = "";
        try {
            URI hostURI = new URI(uri.toString().substring("jdbc:".length()));
            apiServer = hostURI.getHost();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (apiServer.isEmpty() && info.getProperty("apiserver") != null) {
            apiServer = info.getProperty("apiserver");
        }
        if (apiServer.isEmpty() && info.getProperty("apiServer") != null) {
            apiServer = info.getProperty("apiServer");
        }
        if (apiServer.isEmpty() && info.getProperty("endpoint") != null) {
            apiServer = info.getProperty("endpoint");
        }
        return apiServer;
    }

    private void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is closed");
        }
    }

    private static void checkResultSet(int resultSetType, int resultSetConcurrency) throws SQLFeatureNotSupportedException {
        if (resultSetType != 1003) {
            throw new SQLFeatureNotSupportedException("Result set type must be TYPE_FORWARD_ONLY");
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException("Result set concurrency must be CONCUR_READ_ONLY");
        }
    }

    private static void checkHoldability(int resultSetHoldability) throws SQLFeatureNotSupportedException {
        if (resultSetHoldability != 1) {
            throw new SQLFeatureNotSupportedException("Result set holdability must be HOLD_CURSORS_OVER_COMMIT");
        }
    }
}

