/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.jdbc;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.rockset.jdbc.ConnectionProperties;
import com.rockset.jdbc.RocksetConnection;
import com.rockset.jdbc.RocksetDriverUri;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RocksetDriver
implements Driver,
Closeable {
    static final String DRIVER_NAME = "Rockset JDBC Driver";
    static final String DRIVER_VERSION;
    static final int DRIVER_VERSION_MAJOR;
    static final int DRIVER_VERSION_MINOR;
    public static final String JDBC_URL_START = "jdbc:";
    private static final String ROCKSET_DRIVER_URL_START;
    private static boolean debugLogs;
    private static BufferedWriter debugWriter;
    private static String logfile;

    @Override
    public void close() {
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        RocksetDriver.log("Entry: Connect " + url);
        if (!this.acceptsURL(url)) {
            RocksetDriver.log("Exit: Connect bad url" + url);
            return null;
        }
        URI uri = null;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new SQLException("Bad url format " + url + " exception", e);
        }
        RocksetConnection conn = new RocksetConnection(uri, info);
        Statement stmt = conn.createStatement();
        ResultSet res = stmt.executeQuery("select 1");
        res.close();
        stmt.close();
        RocksetDriver.log("Exit: Connect " + url);
        return conn;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        RocksetDriver.log("Entry: acceptsURL " + url);
        return url.startsWith(ROCKSET_DRIVER_URL_START);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        RocksetDriver.log("Entry: getPropertyInfo " + url);
        Properties properties = new RocksetDriverUri(url, info).getProperties();
        return (DriverPropertyInfo[])ConnectionProperties.allProperties().stream().map(property -> property.getDriverPropertyInfo(properties)).toArray(DriverPropertyInfo[]::new);
    }

    @Override
    public int getMajorVersion() {
        RocksetDriver.log("Entry: getMajorVersion ");
        return DRIVER_VERSION_MAJOR;
    }

    @Override
    public int getMinorVersion() {
        RocksetDriver.log("Entry: getMinorVersion ");
        return DRIVER_VERSION_MINOR;
    }

    @Override
    public boolean jdbcCompliant() {
        RocksetDriver.log("Entry: jdbcCompliant ");
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static void log(String msg) {
        if (debugLogs) {
            RocksetDriver.doLog(msg);
        }
    }

    static synchronized void doLog(String msg) {
        try {
            if (debugWriter == null) {
                debugWriter = new BufferedWriter(new FileWriter(logfile));
            }
            debugWriter.write(msg + "\n");
            debugWriter.flush();
        }
        catch (Exception e) {
            System.out.println("Unable to log to file " + logfile);
        }
    }

    static {
        ROCKSET_DRIVER_URL_START = JDBC_URL_START.concat("rockset:");
        debugLogs = false;
        logfile = "/tmp/rockset-jdbc.log";
        String version = Strings.nullToEmpty((String)RocksetDriver.class.getPackage().getImplementationVersion());
        Matcher matcher = Pattern.compile("^(\\d+)\\.(\\d+)($|[.-])").matcher(version);
        if (!matcher.find()) {
            DRIVER_VERSION = "unknown";
            DRIVER_VERSION_MAJOR = 0;
            DRIVER_VERSION_MINOR = 0;
        } else {
            DRIVER_VERSION = version;
            DRIVER_VERSION_MAJOR = Integer.parseInt(matcher.group(1));
            DRIVER_VERSION_MINOR = Integer.parseInt(matcher.group(2));
        }
        try {
            DriverManager.registerDriver(new RocksetDriver());
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

