/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.jdbc;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.net.HostAndPort;
import com.rockset.jdbc.ConnectionProperties;
import com.rockset.jdbc.ConnectionProperty;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

final class RocksetDriverUri {
    private static final String JDBC_URL_START = "jdbc:";
    private static final Splitter QUERY_SPLITTER = Splitter.on((char)'&').omitEmptyStrings();
    private static final Splitter ARG_SPLITTER = Splitter.on((char)'=').limit(2);
    private final HostAndPort address;
    private final URI uri;
    private final Properties properties;
    private String catalog;
    private String schema;
    private final boolean useSecureConnection;

    public RocksetDriverUri(String url, Properties driverProperties) throws SQLException {
        this(RocksetDriverUri.parseDriverUrl(url), driverProperties);
    }

    private RocksetDriverUri(URI uri, Properties driverProperties) throws SQLException {
        this.uri = Objects.requireNonNull(uri, "uri is null");
        this.address = HostAndPort.fromParts((String)uri.getHost(), (int)uri.getPort());
        this.properties = RocksetDriverUri.mergeConnectionProperties(uri, driverProperties);
        RocksetDriverUri.validateConnectionProperties(this.properties);
        this.useSecureConnection = ConnectionProperties.SSL.getRequiredValue(this.properties);
        this.initCatalogAndSchema();
    }

    public URI getJdbcUri() {
        return this.uri;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public URI getHttpUri() {
        return this.buildHttpUri();
    }

    public String getUser() throws SQLException {
        return ConnectionProperties.USER.getRequiredValue(this.properties);
    }

    public Properties getProperties() {
        return this.properties;
    }

    private static Map<String, String> parseParameters(String query) throws SQLException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (query != null) {
            Iterable queryArgs = QUERY_SPLITTER.split((CharSequence)query);
            for (String queryArg : queryArgs) {
                List parts = ARG_SPLITTER.splitToList((CharSequence)queryArg);
                if (result.put((String)parts.get(0), (String)parts.get(1)) == null) continue;
                throw new SQLException(String.format("Connection property '%s' is in URL multiple times", parts.get(0)));
            }
        }
        return result;
    }

    private static URI parseDriverUrl(String url) throws SQLException {
        URI uri;
        try {
            uri = new URI(url.substring(JDBC_URL_START.length()));
        }
        catch (URISyntaxException e) {
            throw new SQLException("Invalid JDBC URL: " + url, e);
        }
        if (Strings.isNullOrEmpty((String)uri.getHost())) {
            throw new SQLException("No host specified: " + url);
        }
        if (uri.getPort() == -1) {
            throw new SQLException("No port number specified: " + url);
        }
        if (uri.getPort() < 1 || uri.getPort() > 65535) {
            throw new SQLException("Invalid port number: " + url);
        }
        return uri;
    }

    private URI buildHttpUri() {
        String scheme = this.useSecureConnection ? "https" : "http";
        try {
            return new URI(scheme, null, this.address.getHost(), this.address.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void initCatalogAndSchema() throws SQLException {
        String path = this.uri.getPath();
        if (Strings.isNullOrEmpty((String)this.uri.getPath()) || path.equals("/")) {
            return;
        }
        if (!path.startsWith("/")) {
            throw new SQLException("Path does not start with a slash: " + this.uri);
        }
        path = path.substring(1);
        List parts = Splitter.on((String)"/").splitToList((CharSequence)path);
        if (((String)parts.get(parts.size() - 1)).isEmpty()) {
            parts = parts.subList(0, parts.size() - 1);
        }
        if (parts.size() > 2) {
            throw new SQLException("Invalid path segments in URL: " + this.uri);
        }
        if (((String)parts.get(0)).isEmpty()) {
            throw new SQLException("Catalog name is empty: " + this.uri);
        }
        this.catalog = (String)parts.get(0);
        if (parts.size() > 1) {
            if (((String)parts.get(1)).isEmpty()) {
                throw new SQLException("Schema name is empty: " + this.uri);
            }
            this.schema = (String)parts.get(1);
        }
    }

    private static Properties mergeConnectionProperties(URI uri, Properties driverProperties) throws SQLException {
        Map<String, String> defaults = ConnectionProperties.getDefaults();
        Map<String, String> urlProperties = RocksetDriverUri.parseParameters(uri.getQuery());
        ImmutableMap suppliedProperties = Maps.fromProperties((Properties)driverProperties);
        for (String key : urlProperties.keySet()) {
            if (!suppliedProperties.containsKey(key)) continue;
            throw new SQLException(String.format("Connection property '%s' is both in the URL and an argument", key));
        }
        Properties result = new Properties();
        RocksetDriverUri.setProperties(result, defaults);
        RocksetDriverUri.setProperties(result, urlProperties);
        RocksetDriverUri.setProperties(result, (Map<String, String>)suppliedProperties);
        return result;
    }

    private static void setProperties(Properties properties, Map<String, String> values) {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            properties.setProperty(entry.getKey(), entry.getValue());
        }
    }

    private static void validateConnectionProperties(Properties connectionProperties) throws SQLException {
        for (String string : connectionProperties.stringPropertyNames()) {
            if (ConnectionProperties.forKey(string) != null) continue;
            throw new SQLException(String.format("Unrecognized connection property '%s'", string));
        }
        for (ConnectionProperty connectionProperty : ConnectionProperties.allProperties()) {
            connectionProperty.validate(connectionProperties);
        }
    }
}

