/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.jdbc;

import com.google.common.primitives.Ints;
import com.rockset.client.model.QueryParameter;
import com.rockset.jdbc.NotImplementedException;
import com.rockset.jdbc.ObjectCasts;
import com.rockset.jdbc.RocksetConnection;
import com.rockset.jdbc.RocksetDriver;
import com.rockset.jdbc.RocksetResultSet;
import com.rockset.jdbc.RocksetStatement;
import com.rockset.jdbc.RocksetUtils;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class RocksetPreparedStatement
extends RocksetStatement
implements PreparedStatement {
    private final Map<Integer, Params> parameters = new HashMap<Integer, Params>();
    private final String statementName;
    private final String originalSql;
    private final AtomicLong executeCount;

    RocksetPreparedStatement(RocksetConnection connection, String statementName, String sql) throws SQLException {
        super(connection);
        this.statementName = Objects.requireNonNull(statementName, "statementName is null");
        this.originalSql = Objects.requireNonNull(sql, "sql is null");
        this.executeCount = new AtomicLong(0L);
    }

    @Override
    public void close() throws SQLException {
        RocksetDriver.log("Enter : RocksetPreparedStatement close");
        super.close();
        RocksetDriver.log("Exit : RocksetPreparedStatement close");
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        RocksetDriver.log("Enter : RocksetPreparedStatement executeQuery");
        if (!this.getExecuteSql()) {
            throw new SQLException("Prepared SQL statement is not a query: " + this.originalSql);
        }
        RocksetDriver.log("Exit : RocksetPreparedStatement executeQuery");
        return this.getResultSet();
    }

    @Override
    public int executeUpdate() throws SQLException {
        RocksetDriver.log("Enter : RocksetPreparedStatement executeUpdate");
        return Ints.saturatedCast((long)this.executeLargeUpdate());
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        RocksetDriver.log("Enter : RocksetPreparedStatement executeLargeUpdate");
        if (!this.getExecuteSql()) {
            throw new SQLException("Prepared SQL is not an update statement: " + this.originalSql);
        }
        RocksetDriver.log("Exit : RocksetPreparedStatement executeLargeUpdate");
        return this.getLargeUpdateCount();
    }

    @Override
    public boolean execute() throws SQLException {
        RocksetDriver.log("Enter : RocksetPreparedStatement execute");
        boolean ret = this.getExecuteSql();
        RocksetDriver.log("Exit : RocksetPreparedStatement execute");
        return ret;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        RocksetDriver.log("Enter : RocksetPreparedStatement setNull");
        this.checkOpen();
        this.setParameter(parameterIndex, RocksetUtils.sqlTypeToRocksetTypeNames(sqlType), RocksetPreparedStatement.typedNull(sqlType));
        RocksetDriver.log("Exit : RocksetPreparedStatement setNull");
    }

    private void setNull(int parameterIndex, String rocksetType) throws SQLException {
        this.checkOpen();
        this.setParameter(parameterIndex, rocksetType, RocksetPreparedStatement.typedNull(rocksetType));
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        RocksetDriver.log("Enter : RocksetPreparedStatement setBoolean");
        this.checkOpen();
        this.setParameter(parameterIndex, "bool", String.valueOf(x));
        RocksetDriver.log("Exit : RocksetPreparedStatement setBoolean");
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        RocksetDriver.log("Enter : RocksetPreparedStatement setByte");
        this.checkOpen();
        this.setParameter(parameterIndex, "int", Byte.toString(x));
        RocksetDriver.log("Exit : RocksetPreparedStatement setByte");
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        RocksetDriver.log("Enter : RocksetPreparedStatement setShort");
        this.checkOpen();
        this.setParameter(parameterIndex, "int", Short.toString(x));
        RocksetDriver.log("Exit : RocksetPreparedStatement setShort");
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        RocksetDriver.log("Enter : RocksetPreparedStatement setInt");
        this.checkOpen();
        this.setParameter(parameterIndex, "int", Integer.toString(x));
        RocksetDriver.log("Exit : RocksetPreparedStatement setInt");
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        RocksetDriver.log("Enter : RocksetPreparedStatement setLong");
        this.checkOpen();
        this.setParameter(parameterIndex, "int", Long.toString(x));
        RocksetDriver.log("Exit : RocksetPreparedStatement setLong");
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        RocksetDriver.log("Enter : RocksetPreparedStatement setFloat");
        this.checkOpen();
        this.setParameter(parameterIndex, "float", Float.toString(x));
        RocksetDriver.log("Exit : RocksetPreparedStatement setFloat");
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkOpen();
        this.setParameter(parameterIndex, "float", Double.toString(x));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkOpen();
        if (x == null) {
            this.setNull(parameterIndex, "float");
        } else {
            this.setParameter(parameterIndex, "float", x.toString());
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkOpen();
        if (x == null) {
            this.setNull(parameterIndex, "string");
        } else {
            this.setParameter(parameterIndex, "string", x);
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkOpen();
        if (x == null) {
            this.setNull(parameterIndex, "bytes");
        } else {
            this.setParameter(parameterIndex, "bytes", new String(x, StandardCharsets.UTF_8));
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkOpen();
        if (x == null) {
            this.setNull(parameterIndex, "date");
        } else {
            this.setParameter(parameterIndex, "date", RocksetResultSet.DATE_FORMATTER.print(x.getTime()));
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkOpen();
        if (x == null) {
            this.setNull(parameterIndex, "time");
        } else {
            this.setParameter(parameterIndex, "time", RocksetResultSet.TIME_FORMATTER.print(x.getTime()));
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkOpen();
        if (x == null) {
            this.setNull(parameterIndex, "timestamp");
        } else {
            this.setParameter(parameterIndex, "timestamp", RocksetResultSet.TIMESTAMP_FORMATTER.print(x.getTime()));
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new NotImplementedException("PreparedStatement", "setAsciiStream");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setUnicodeStream");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new NotImplementedException("PreparedStatement", "setBinaryStream");
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkOpen();
        this.parameters.clear();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.checkOpen();
        if (x == null) {
            this.setNull(parameterIndex, targetSqlType);
            return;
        }
        switch (targetSqlType) {
            case -7: 
            case 16: {
                this.setBoolean(parameterIndex, ObjectCasts.castToBoolean(x, targetSqlType));
                return;
            }
            case -6: {
                this.setByte(parameterIndex, ObjectCasts.castToByte(x, targetSqlType));
                return;
            }
            case 5: {
                this.setShort(parameterIndex, ObjectCasts.castToShort(x, targetSqlType));
                return;
            }
            case 4: {
                this.setInt(parameterIndex, ObjectCasts.castToInt(x, targetSqlType));
                return;
            }
            case -5: {
                this.setLong(parameterIndex, ObjectCasts.castToLong(x, targetSqlType));
                return;
            }
            case 6: 
            case 7: {
                this.setFloat(parameterIndex, ObjectCasts.castToFloat(x, targetSqlType));
                return;
            }
            case 8: {
                this.setDouble(parameterIndex, ObjectCasts.castToDouble(x, targetSqlType));
                return;
            }
            case 2: 
            case 3: {
                this.setBigDecimal(parameterIndex, ObjectCasts.castToBigDecimal(x, targetSqlType));
                return;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                this.setString(parameterIndex, x.toString());
                return;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setBytes(parameterIndex, ObjectCasts.castToBinary(x, targetSqlType));
                return;
            }
            case 91: {
                this.setDate(parameterIndex, ObjectCasts.castToDate(x, targetSqlType));
                return;
            }
            case 92: {
                this.setTime(parameterIndex, ObjectCasts.castToTime(x, targetSqlType));
                return;
            }
            case 93: {
                this.setTimestamp(parameterIndex, ObjectCasts.castToTimestamp(x, targetSqlType));
                return;
            }
        }
        throw new SQLException("Unsupported target SQL type: " + targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType.getVendorTypeNumber());
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkOpen();
        if (x == null) {
            this.setNull(parameterIndex, 0);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else {
            throw new SQLException("Unsupported object type: " + x.getClass().getName());
        }
    }

    @Override
    public void addBatch() throws SQLException {
        throw new NotImplementedException("PreparedStatement", "addBatch");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new NotImplementedException("PreparedStatement", "setCharacterStream");
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setRef");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setBlob");
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setClob");
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setArray");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        RocksetDriver.log("Enter : RocksetPreparedStatement getMetaData");
        if (this.executeCount.get() == 0L) {
            this.getExecuteSql();
        }
        ResultSetMetaData meta = this.getResultSet().getMetaData();
        RocksetDriver.log("Exit : RocksetPreparedStatement getMetaData");
        return meta;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        throw new NotImplementedException("PreparedStatement", "setDate");
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw new NotImplementedException("PreparedStatement", "setTime");
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        throw new NotImplementedException("PreparedStatement", "setTimestamp");
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setURL");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new NotImplementedException("PreparedStatement", "getParameterMetaData");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setRowId");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNCharacterStream");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNClob");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setClob");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setBlob");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNClob");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("setSQLXML");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException("setObject");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new NotImplementedException("PreparedStatement", "setAsciiStream");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new NotImplementedException("PreparedStatement", "setBinaryStream");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new NotImplementedException("PreparedStatement", "setCharacterStream");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setAsciiStream");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setBinaryStream");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("setCharacterStream");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNCharacterStream");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("setClob");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("setBlob");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNClob");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    private void setParameter(int parameterIndex, String type, String value) throws SQLException {
        if (parameterIndex < 1) {
            throw new SQLException("Parameter index out of bounds: " + parameterIndex);
        }
        this.parameters.put(parameterIndex - 1, new Params(type, value));
    }

    private List<QueryParameter> convertParameters() throws SQLException {
        ArrayList<QueryParameter> values = new ArrayList<QueryParameter>();
        for (int index = 0; index < this.parameters.size(); ++index) {
            if (!this.parameters.containsKey(index)) {
                throw new SQLException("No value specified for parameter " + (index + 1));
            }
            Params params = this.parameters.get(index);
            values.add(new QueryParameter().type(params.type).value(params.value));
        }
        return values;
    }

    private boolean getExecuteSql() throws SQLException {
        boolean ret = super.executeWithParams(this.originalSql, this.convertParameters());
        if (ret) {
            this.executeCount.incrementAndGet();
        }
        return ret;
    }

    private static String typedNull(int targetSqlType) throws SQLException {
        switch (targetSqlType) {
            case -7: 
            case 16: {
                return RocksetPreparedStatement.typedNull("BOOLEAN");
            }
            case -6: {
                return RocksetPreparedStatement.typedNull("TINYINT");
            }
            case 5: {
                return RocksetPreparedStatement.typedNull("SMALLINT");
            }
            case 4: {
                return RocksetPreparedStatement.typedNull("INTEGER");
            }
            case -5: {
                return RocksetPreparedStatement.typedNull("BIGINT");
            }
            case 6: 
            case 7: {
                return RocksetPreparedStatement.typedNull("REAL");
            }
            case 8: {
                return RocksetPreparedStatement.typedNull("DOUBLE");
            }
            case 2: 
            case 3: {
                return RocksetPreparedStatement.typedNull("DECIMAL");
            }
            case -15: 
            case 1: {
                return RocksetPreparedStatement.typedNull("CHAR");
            }
            case -16: 
            case -9: 
            case -1: 
            case 12: 
            case 2005: 
            case 2011: {
                return RocksetPreparedStatement.typedNull("VARCHAR");
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return RocksetPreparedStatement.typedNull("VARBINARY");
            }
            case 91: {
                return RocksetPreparedStatement.typedNull("DATE");
            }
            case 92: {
                return RocksetPreparedStatement.typedNull("TIME");
            }
            case 93: {
                return RocksetPreparedStatement.typedNull("TIMESTAMP");
            }
            case 0: {
                return "NULL";
            }
        }
        throw new SQLException("Unsupported target SQL type: " + targetSqlType);
    }

    private static String typedNull(String type) {
        return String.format("CAST(NULL AS %s)", type);
    }

    public class Params {
        String type;
        String value;

        Params(String type, String value) {
            this.type = type;
            this.value = value;
        }
    }
}

