/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.jdbc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.ImmutableMap;
import com.rockset.client.model.QueryFieldType;
import com.rockset.client.model.QueryPaginationResponse;
import com.rockset.client.model.QueryResponse;
import com.rockset.jdbc.Column;
import com.rockset.jdbc.NotImplementedException;
import com.rockset.jdbc.RocksetArray;
import com.rockset.jdbc.RocksetDriver;
import com.rockset.jdbc.RocksetResultSetMetaData;
import com.rockset.jdbc.RocksetResultSetPaginationParams;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.ISODateTimeFormat;

public class RocksetResultSet
implements ResultSet {
    static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    static final DateTimeFormatter DATE_FORMATTER = ISODateTimeFormat.date();
    static final DateTimeParser MICROSECOND_PARSER = new DateTimeFormatterBuilder().appendPattern(".").appendFractionOfSecond(1, 6).toParser();
    static final DateTimeParser SECOND_PARSER = new DateTimeFormatterBuilder().appendPattern(":ss").appendOptional(MICROSECOND_PARSER).toParser();
    static final DateTimeFormatter TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("HH:mm").appendOptional(SECOND_PARSER).toFormatter();
    static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS");
    static final java.time.format.DateTimeFormatter DATETIME_PARSE_FORMAT = new java.time.format.DateTimeFormatterBuilder().appendPattern("uuuu-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.MICRO_OF_SECOND, 0, 6, true).toFormatter();
    static final java.time.format.DateTimeFormatter TIMESTAMP_PARSE_FORMAT = new java.time.format.DateTimeFormatterBuilder().appendPattern("uuuu-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.MICRO_OF_SECOND, 0, 6, true).appendPattern("'Z'").toFormatter();
    private static final int YEAR_FIELD = 0;
    private static final int MONTH_FIELD = 1;
    private static final int DAY_FIELD = 3;
    private static final int HOUR_FIELD = 4;
    private static final int MINUTE_FIELD = 5;
    private static final int SECOND_FIELD = 6;
    private static final int MILLIS_FIELD = 7;
    private static boolean debugLogs = false;
    private List<Object> resultSet;
    private final DateTimeZone sessionTimeZone;
    private final Map<String, Integer> fieldMap;
    private final List<Column> columns;
    private final ResultSetMetaData resultSetMetaData;
    private final AtomicInteger rowIndex = new AtomicInteger(-1);
    private JsonNode currentDocRootNode;
    private final long maxRows;
    private final int columnCount;
    private final AtomicBoolean wasNull = new AtomicBoolean();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final String prefix;
    private static final AtomicInteger queryId = new AtomicInteger(0);
    private final RocksetResultSetPaginationParams rocksetResultSetPaginationParams;

    public RocksetResultSet(String queryStr, QueryResponse response, long maxRows, RocksetResultSetPaginationParams rocksetResultSetPaginationParams) throws SQLException {
        this(queryStr, maxRows, rocksetResultSetPaginationParams, RocksetResultSet.getColumns(response), response.getResults());
    }

    private RocksetResultSet(String queryStr, long maxRows, RocksetResultSetPaginationParams rocksetResultSetPaginationParams, List<Column> columns, List<Object> resultSet) {
        this.maxRows = maxRows;
        this.rocksetResultSetPaginationParams = rocksetResultSetPaginationParams;
        this.sessionTimeZone = DateTimeZone.forID((String)TimeZone.getDefault().getID());
        this.columns = columns;
        this.columnCount = this.columns.size();
        this.fieldMap = RocksetResultSet.getFieldMap(columns);
        this.resultSet = resultSet;
        this.resultSetMetaData = new RocksetResultSetMetaData(this.columns);
        if (debugLogs) {
            int myid = queryId.getAndIncrement();
            this.prefix = String.format("RocksetResultSet[%d] ", myid);
            RocksetResultSet.log("RocksetResultSet '" + queryStr + "' id = " + myid + " created with numrows = " + this.resultSet.size() + " " + this.resultSetMetaData);
        } else {
            this.prefix = "";
        }
    }

    public RocksetResultSet(List<Column> columns, List<Object> resultSet) {
        this(null, Long.MAX_VALUE, null, columns, resultSet);
    }

    private boolean doNextIfPaginationDisabled() throws SQLException {
        if (this.rowIndex.get() >= this.resultSet.size()) {
            RocksetResultSet.log(this.prefix + " Thread " + Thread.currentThread().getName() + " no more data " + this.rowIndex.get());
            return false;
        }
        RocksetResultSet.log(this.prefix + " Thread " + Thread.currentThread().getName() + " positioned at " + this.rowIndex.get());
        return true;
    }

    private List<Object> getPaginationResults() throws SQLException {
        try {
            QueryPaginationResponse response = this.rocksetResultSetPaginationParams.getConnection().getQueryPaginationResults(this.rocksetResultSetPaginationParams.getLastQueryId(), this.rocksetResultSetPaginationParams.getCurrentCursor(), this.rocksetResultSetPaginationParams.getFetchSize());
            this.rocksetResultSetPaginationParams.setCurrentCursor(response.getPagination().getNextCursor());
            return response.getResults();
        }
        catch (RuntimeException e) {
            String msg = "Error retriving pagination info from query Id '" + this.rocksetResultSetPaginationParams.getLastQueryId() + "' error =  " + e.getMessage();
            RocksetDriver.log(msg);
            throw new SQLException(msg, e);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    private boolean doNextIfPaginationEnabled() throws SQLException {
        if (this.rowIndex.get() >= this.resultSet.size()) {
            if (this.rocksetResultSetPaginationParams == null || this.rocksetResultSetPaginationParams.getCurrentCursor() == null) {
                this.resultSet = new ArrayList<Object>();
            } else {
                this.resultSet = this.getPaginationResults();
                this.rowIndex.set(0);
            }
            if (this.resultSet.size() == 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean next() throws SQLException {
        boolean hasNext = this.doNext();
        this.currentDocRootNode = hasNext ? this.parseCurrentDocRootNode() : null;
        return hasNext;
    }

    @Override
    public void close() throws SQLException {
        RocksetResultSet.log(this.prefix + "closed");
        this.closed.set(true);
    }

    @Override
    public boolean wasNull() throws SQLException {
        boolean result = this.wasNull.get();
        RocksetResultSet.log(this.prefix + "wasNull is " + result);
        return result;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        RocksetResultSet.log(this.prefix + "columnIndex getString " + columnIndex);
        JsonNode value = this.column(columnIndex);
        String ret = value != null ? value.asText() : null;
        RocksetResultSet.log(this.prefix + "columnIndex getString " + columnIndex + " returning " + ret);
        return ret;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        RocksetResultSet.log(this.prefix + "columnIndex getBoolean " + columnIndex);
        JsonNode value = this.column(columnIndex);
        return value != null && value.booleanValue();
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        RocksetResultSet.log(this.prefix + "columnIndex getByte " + columnIndex);
        return RocksetResultSet.toNumber(this.column(columnIndex)).byteValue();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        RocksetResultSet.log(this.prefix + "columnIndex getShort " + columnIndex);
        return RocksetResultSet.toNumber(this.column(columnIndex)).shortValue();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        RocksetResultSet.log(this.prefix + "columnIndex getInt " + columnIndex);
        int ret = RocksetResultSet.toNumber(this.column(columnIndex)).intValue();
        RocksetResultSet.log(this.prefix + "columnIndex getInt " + columnIndex + " returning " + Integer.toString(ret));
        return ret;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        RocksetResultSet.log(this.prefix + "columnIndex getLong " + columnIndex);
        long ret = RocksetResultSet.toNumber(this.column(columnIndex)).longValue();
        RocksetResultSet.log(this.prefix + "columnIndex getLong " + columnIndex + " returning " + Long.toString(ret));
        return ret;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        RocksetResultSet.log(this.prefix + "columnIndex getFloat " + columnIndex);
        return RocksetResultSet.toNumber(this.column(columnIndex)).floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        RocksetResultSet.log(this.prefix + "columnIndex getDouble " + columnIndex);
        double ret = RocksetResultSet.toNumber(this.column(columnIndex)).doubleValue();
        RocksetResultSet.log(this.prefix + "columnIndex getDouble " + columnIndex + " returning " + Double.toString(ret));
        return ret;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        RocksetResultSet.log(this.prefix + "columnIndex getBigDecimal " + columnIndex);
        BigDecimal bigDecimal = this.getBigDecimal(columnIndex);
        if (bigDecimal != null) {
            bigDecimal = bigDecimal.setScale(scale, 4);
        }
        return bigDecimal;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        RocksetResultSet.log(this.prefix + "columnIndex getBytes " + columnIndex);
        try {
            return this.column(columnIndex).binaryValue();
        }
        catch (Exception e) {
            throw new SQLException("Error processing getBytes for column index " + columnIndex + " exception " + e.getMessage(), e);
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        RocksetResultSet.log(this.prefix + "columnIndex getDate " + columnIndex);
        return this.getDate(columnIndex, this.sessionTimeZone);
    }

    private Date getDate(int columnIndex, DateTimeZone localTimeZone) throws SQLException {
        RocksetResultSet.log(this.prefix + "columnIndex getDate " + columnIndex);
        JsonNode value = this.column(columnIndex);
        if (value == null || value.get("value") == null) {
            this.wasNull.set(true);
            return null;
        }
        this.wasNull.set(false);
        String date = value.get("value").asText();
        try {
            return Date.valueOf(date);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Invalid date from server: " + date, e);
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getTime(columnIndex, this.sessionTimeZone);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, this.sessionTimeZone);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        RocksetResultSet.log(this.prefix + "getAsciiStream");
        throw new NotImplementedException("ResultSet", "getAsciiStream");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        RocksetResultSet.log(this.prefix + "getUnicodeStream");
        throw new SQLFeatureNotSupportedException("getUnicodeStream");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        RocksetResultSet.log(this.prefix + "getBinaryStream");
        throw new NotImplementedException("ResultSet", "getBinaryStream");
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        RocksetResultSet.log(this.prefix + "columnLabel");
        JsonNode value = this.column(columnLabel);
        return value != null ? value.asText() : null;
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        RocksetResultSet.log(this.prefix + "getBoolean " + columnLabel);
        JsonNode value = this.column(columnLabel);
        return value != null && value.booleanValue();
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        RocksetResultSet.log(this.prefix + "getByte " + columnLabel);
        return RocksetResultSet.toNumber(this.column(columnLabel)).byteValue();
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        RocksetResultSet.log(this.prefix + "getShort " + columnLabel);
        return RocksetResultSet.toNumber(this.column(columnLabel)).shortValue();
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        RocksetResultSet.log(this.prefix + "getInt " + columnLabel);
        return RocksetResultSet.toNumber(this.column(columnLabel)).intValue();
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        RocksetResultSet.log(this.prefix + "getLong " + columnLabel);
        return RocksetResultSet.toNumber(this.column(columnLabel)).longValue();
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        RocksetResultSet.log(this.prefix + "getFloat " + columnLabel);
        return RocksetResultSet.toNumber(this.column(columnLabel)).floatValue();
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        RocksetResultSet.log(this.prefix + "getDouble " + columnLabel);
        return RocksetResultSet.toNumber(this.column(columnLabel)).doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        RocksetResultSet.log(this.prefix + "getBigDecimal " + columnLabel);
        return this.getBigDecimal(this.columnIndex(columnLabel), scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        try {
            RocksetResultSet.log(this.prefix + "getBytes " + columnLabel);
            return this.column(columnLabel).binaryValue();
        }
        catch (Exception e) {
            throw new SQLException("Error processing getBytes for column label " + columnLabel + " exception " + e.getMessage(), e);
        }
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        RocksetResultSet.log(this.prefix + "getDate " + columnLabel);
        return this.getDate(this.columnIndex(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        RocksetResultSet.log(this.prefix + "getTime " + columnLabel);
        return this.getTime(this.columnIndex(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.columnIndex(columnLabel));
    }

    public BigInteger getU256(int columnIndex) throws SQLException {
        JsonNode value = this.column(columnIndex);
        if (value == null || value.get("value") == null) {
            return null;
        }
        String bigInt = value.get("value").asText();
        try {
            return new BigInteger(bigInt);
        }
        catch (NumberFormatException e) {
            throw new SQLException("Invalid U256 from server: " + bigInt, e);
        }
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        RocksetResultSet.log(this.prefix + "getAsciiStream " + columnLabel);
        throw new NotImplementedException("ResultSet", "getAsciiStream");
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        RocksetResultSet.log(this.prefix + "getUnicodeStream " + columnLabel);
        throw new SQLFeatureNotSupportedException("getUnicodeStream");
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        RocksetResultSet.log(this.prefix + "getBinaryStream " + columnLabel);
        throw new NotImplementedException("ResultSet", "getBinaryStream");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
    }

    @Override
    public String getCursorName() throws SQLException {
        RocksetResultSet.log(this.prefix + "getCursorName ");
        throw new SQLFeatureNotSupportedException("getCursorName");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        RocksetResultSet.log(this.prefix + "getMetaData ");
        return this.resultSetMetaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        RocksetResultSet.log(this.prefix + "getObject columnIndex " + columnIndex);
        int sqlType = this.resultSetMetaData.getColumnType(columnIndex);
        switch (sqlType) {
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 93: 
            case 2014: {
                return this.getTimestamp(columnIndex);
            }
            case 2003: {
                return this.getArray(columnIndex);
            }
            case 3: {
                return this.getBigDecimal(columnIndex);
            }
            case -5: {
                return this.getU256(columnIndex);
            }
        }
        RocksetResultSet.log(this.prefix + "getObject columnIndex " + columnIndex + " no Type " + sqlType);
        return this.column(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.columnIndex(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkOpen();
        return this.columnIndex(columnLabel);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        RocksetResultSet.log(this.prefix + "getCharacterStream columnIndex " + columnIndex);
        throw new NotImplementedException("ResultSet", "getCharacterStream");
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        RocksetResultSet.log(this.prefix + "getCharacterStream columnLabel " + columnLabel);
        throw new NotImplementedException("ResultSet", "getCharacterStream");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        RocksetResultSet.log(this.prefix + "getBigDecimal columnIndex " + columnIndex);
        JsonNode value = this.column(columnIndex);
        if (value == null) {
            return null;
        }
        return new BigDecimal(String.valueOf(value));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.columnIndex(columnLabel));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        RocksetResultSet.log("RocksetResultSet isBeforeFirst");
        throw new SQLFeatureNotSupportedException("isBeforeFirst");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        RocksetResultSet.log("RocksetResultSet isAfterLast");
        throw new SQLFeatureNotSupportedException("isAfterLast");
    }

    @Override
    public boolean isFirst() throws SQLException {
        RocksetResultSet.log("RocksetResultSet isFirst");
        throw new SQLFeatureNotSupportedException("isFirst");
    }

    @Override
    public boolean isLast() throws SQLException {
        RocksetResultSet.log("RocksetResultSet isLast");
        throw new SQLFeatureNotSupportedException("isLast");
    }

    @Override
    public void beforeFirst() throws SQLException {
        RocksetResultSet.log("RocksetResultSet beforeFirst");
        throw new SQLFeatureNotSupportedException("beforeFirst");
    }

    @Override
    public void afterLast() throws SQLException {
        RocksetResultSet.log("RocksetResultSet afterLast");
        throw new SQLFeatureNotSupportedException("afterLast");
    }

    @Override
    public boolean first() throws SQLException {
        RocksetResultSet.log("RocksetResultSet first");
        throw new SQLFeatureNotSupportedException("first");
    }

    @Override
    public boolean last() throws SQLException {
        RocksetResultSet.log("RocksetResultSet last");
        throw new SQLFeatureNotSupportedException("last");
    }

    @Override
    public int getRow() throws SQLException {
        RocksetResultSet.log("RocksetResultSet getRow");
        throw new SQLFeatureNotSupportedException("getRow");
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        RocksetResultSet.log("RocksetResultSet absolute");
        throw new SQLFeatureNotSupportedException("absolute");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        RocksetResultSet.log("RocksetResultSet relative");
        throw new SQLFeatureNotSupportedException("relative");
    }

    @Override
    public boolean previous() throws SQLException {
        RocksetResultSet.log("RocksetResultSet previous");
        throw new SQLFeatureNotSupportedException("previous");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkOpen();
        if (direction != 1000) {
            RocksetResultSet.log("RocksetResultSet setFetchDirection error");
            throw new SQLException("Fetch direction must be FETCH_FORWARD");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
        if (rows < 0) {
            throw new SQLException("Rows is negative");
        }
        this.rocksetResultSetPaginationParams.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return this.rocksetResultSetPaginationParams.getFetchSize();
    }

    @Override
    public int getType() throws SQLException {
        this.checkOpen();
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkOpen();
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLFeatureNotSupportedException("rowUpdated");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLFeatureNotSupportedException("rowInserted");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLFeatureNotSupportedException("rowDeleted");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNull");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBoolean");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateByte");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateShort");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateInt");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateLong");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateFloat");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateDouble");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBigDecimal");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateString");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBytes");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateDate");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateTime");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateTimestamp");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNull");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBoolean");
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateByte");
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateShort");
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateInt");
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateLong");
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateFloat");
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateDouble");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBigDecimal");
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateString");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBytes");
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateDate");
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateTime");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateTimestamp");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("insertRow");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("updateRow");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("deleteRow");
    }

    @Override
    public void refreshRow() throws SQLException {
        RocksetResultSet.log("RocksetResultSet refreshRow");
        throw new SQLFeatureNotSupportedException("refreshRow");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLFeatureNotSupportedException("cancelRowUpdates");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("moveToInsertRow");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        RocksetResultSet.log("RocksetResultSet moveToCurrentRow");
        throw new SQLFeatureNotSupportedException("moveToCurrentRow");
    }

    @Override
    public Statement getStatement() throws SQLException {
        RocksetResultSet.log("RocksetResultSet getStatement");
        throw new NotImplementedException("ResultSet", "getStatement");
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        RocksetResultSet.log(this.prefix + "getObject with column index " + columnIndex);
        throw new SQLFeatureNotSupportedException("getObject");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        RocksetResultSet.log(this.prefix + "getRef column index " + columnIndex);
        throw new SQLFeatureNotSupportedException("getRef");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        RocksetResultSet.log(this.prefix + "getBlob column index " + columnIndex);
        throw new SQLFeatureNotSupportedException("getBlob");
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        RocksetResultSet.log(this.prefix + "getClob column index " + columnIndex);
        throw new SQLFeatureNotSupportedException("getClob");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        RocksetResultSet.log(this.prefix + "getArray column index " + columnIndex);
        JsonNode value = this.column(columnIndex);
        if (value == null) {
            return null;
        }
        ArrayList arr = new ArrayList();
        Iterator iter = value.iterator();
        while (iter.hasNext()) {
            arr.add(iter.next());
        }
        return new RocksetArray(arr);
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        RocksetResultSet.log(this.prefix + "getObject columnLabel " + columnLabel);
        throw new SQLFeatureNotSupportedException("getObject");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        RocksetResultSet.log(this.prefix + "getRef column label " + columnLabel);
        throw new SQLFeatureNotSupportedException("getRef");
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        RocksetResultSet.log(this.prefix + "getBlob column label " + columnLabel);
        throw new SQLFeatureNotSupportedException("getBlob");
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        RocksetResultSet.log(this.prefix + "getClob column label " + columnLabel);
        throw new SQLFeatureNotSupportedException("getClob");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.columnIndex(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getDate(columnIndex, DateTimeZone.forTimeZone((TimeZone)cal.getTimeZone()));
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.columnIndex(columnLabel), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getTime(columnIndex, DateTimeZone.forTimeZone((TimeZone)cal.getTimeZone()));
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.columnIndex(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(columnIndex, DateTimeZone.forTimeZone((TimeZone)cal.getTimeZone()));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.columnIndex(columnLabel), cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        RocksetResultSet.log(this.prefix + "getUrl column index " + columnIndex);
        throw new SQLFeatureNotSupportedException("getURL");
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getURL");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateRef");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateRef");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateArray");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateArray");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getRowId");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getRowId");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateRowId");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateRowId");
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkOpen();
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed.get();
    }

    @Override
    public void updateNString(int columnIndex, String nstring) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNString");
    }

    @Override
    public void updateNString(String columnLabel, String nstring) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNString");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nclob) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nclob) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNClob");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNClob");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getSQLXML");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getSQLXML");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateSQLXML");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateSQLXML");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNString");
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNString");
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNCharacterStream");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException("getObject");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException("getObject");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException("No wrapper for " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    private void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("ResultSet is closed");
        }
    }

    private void checkValidRow() throws SQLException {
        int cur = this.rowIndex.get();
        if (cur >= this.resultSet.size()) {
            throw new SQLException("Not on a valid row  current row " + cur + " total " + this.resultSet.size());
        }
    }

    private JsonNode column(int index) throws SQLException {
        this.checkOpen();
        this.checkValidRow();
        if (index <= 0 || index > this.columnCount) {
            throw new SQLException("Invalid column index: " + index);
        }
        String columnName = this.columnInfo(index).getName();
        try {
            JsonNode value = this.currentDocRootNode.get(columnName);
            this.wasNull.set(value == null || value instanceof NullNode);
            return value;
        }
        catch (Exception e) {
            throw new SQLException("Error processing column index " + index + " exception", e);
        }
    }

    private Column columnInfo(int index) throws SQLException {
        this.checkOpen();
        this.checkValidRow();
        if (index <= 0 || index > this.columnCount) {
            throw new SQLException("Invalid column index: " + index);
        }
        return this.columns.get(index - 1);
    }

    private JsonNode column(String label) throws SQLException {
        return this.column(this.columnIndex(label));
    }

    private int columnIndex(String label) throws SQLException {
        if (label == null) {
            throw new SQLException("Column label is null");
        }
        Integer index = this.fieldMap.get(label.toLowerCase(Locale.ENGLISH));
        if (index == null) {
            throw new SQLException("Invalid column label: " + label);
        }
        return index;
    }

    private Time getTime(int columnIndex, DateTimeZone localTimeZone) throws SQLException {
        RocksetResultSet.log(this.prefix + "columnIndex getTime " + columnIndex);
        JsonNode value = this.column(columnIndex);
        if (value == null || value.get("value") == null) {
            this.wasNull.set(true);
            return null;
        }
        this.wasNull.set(false);
        Column columnInfo = this.columnInfo(columnIndex);
        if (columnInfo.getType() == Column.ColumnTypes.TIME) {
            String time = value.get("value").asText();
            try {
                LocalTime localTime = LocalTime.parse((String)time, (DateTimeFormatter)TIME_FORMATTER);
                return new Time(localTime.getHourOfDay(), localTime.getMinuteOfHour(), localTime.getSecondOfMinute());
            }
            catch (IllegalArgumentException e) {
                throw new SQLException("Invalid time from server: " + time, e);
            }
        }
        throw new IllegalArgumentException("Expected column to be a time type but is " + (Object)((Object)columnInfo.getType()));
    }

    private Timestamp getTimestamp(int columnIndex, DateTimeZone localTimeZone) throws SQLException {
        RocksetResultSet.log(this.prefix + "columnIndex getTimestamp " + columnIndex);
        JsonNode value = this.column(columnIndex);
        if (value == null) {
            this.wasNull.set(true);
            return null;
        }
        this.wasNull.set(false);
        Column columnInfo = this.columnInfo(columnIndex);
        if (columnInfo.getType() == Column.ColumnTypes.DATETIME) {
            if (value.get("value") == null) {
                this.wasNull.set(true);
                return null;
            }
            try {
                LocalDateTime dateTime = LocalDateTime.parse(value.get("value").asText(), DATETIME_PARSE_FORMAT);
                ZonedDateTime zonedDateTime = dateTime.atZone(ZoneId.of("UTC"));
                Instant instant = zonedDateTime.toInstant();
                return Timestamp.from(instant);
            }
            catch (Exception e) {
                throw new SQLException("Invalid datetime from server: " + value, e);
            }
        }
        if (columnInfo.getType() == Column.ColumnTypes.TIMESTAMP) {
            if (value.asText().equals("null")) {
                this.wasNull.set(true);
                return null;
            }
            try {
                LocalDateTime dateTime = LocalDateTime.parse(value.asText(), TIMESTAMP_PARSE_FORMAT);
                ZonedDateTime zonedDateTime = dateTime.atZone(ZoneId.of("UTC"));
                Instant instant = zonedDateTime.toInstant();
                return Timestamp.from(instant);
            }
            catch (Exception e) {
                throw new SQLException("Invalid timestamp from server: " + value, e);
            }
        }
        throw new IllegalArgumentException("Expected column to be a datetime/timestamp type but is " + (Object)((Object)columnInfo.getType()));
    }

    private static Number toNumber(Object value) throws SQLException {
        String val;
        if (value == null) {
            return 0;
        }
        if (value instanceof NumericNode) {
            return ((NumericNode)value).doubleValue();
        }
        if (value instanceof BooleanNode) {
            BooleanNode n = (BooleanNode)value;
            return n.asBoolean() ? 1 : 0;
        }
        if (value instanceof TextNode && (val = value.toString().substring(1, value.toString().length() - 1)).isEmpty()) {
            return 0;
        }
        if (value instanceof NullNode) {
            return 0;
        }
        RocksetResultSet.log("Value is not a number");
        throw new SQLException("Value is not a number: " + value.getClass().getCanonicalName());
    }

    private static void log(String msg) {
        if (debugLogs) {
            RocksetDriver.log(msg);
        }
    }

    private static List<Column> getColumns(QueryResponse response) throws SQLException {
        ArrayList<Column> out = new ArrayList<Column>();
        try {
            if (!response.getResults().isEmpty()) {
                List orderedFields = Collections.emptyList();
                if (response.getColumnFields() != null) {
                    orderedFields = response.getColumnFields().stream().map(QueryFieldType::getName).collect(Collectors.toList());
                }
                HashMap<String, Column.ColumnTypes> fieldTypes = new HashMap<String, Column.ColumnTypes>();
                for (int i = 0; i < response.getResults().size(); ++i) {
                    RocksetResultSet.log("Extracting column information from record " + i + " in resultset");
                    Object onedoc = response.getResults().get(i);
                    JsonNode jsonNode = OBJECT_MAPPER.readTree(OBJECT_MAPPER.writeValueAsString(onedoc));
                    Iterator it = jsonNode.fields();
                    while (it.hasNext()) {
                        Map.Entry field = (Map.Entry)it.next();
                        String fieldName = (String)field.getKey();
                        if (fieldTypes.containsKey(fieldName) && !((Column.ColumnTypes)((Object)fieldTypes.get(fieldName))).equals((Object)Column.ColumnTypes.NULL)) continue;
                        JsonNode value = (JsonNode)field.getValue();
                        Column.ColumnTypes type = RocksetResultSet.valueToColumnType(value);
                        RocksetResultSet.log("getColumns::column name " + fieldName + " type: " + type.toString());
                        fieldTypes.put(fieldName, type);
                    }
                }
                Collection<Object> fields = orderedFields.isEmpty() ? fieldTypes.keySet() : orderedFields;
                for (String string : fields) {
                    out.add(new Column(string, (Column.ColumnTypes)((Object)fieldTypes.get(string))));
                }
            } else if (response.getColumnFields() != null && !response.getColumnFields().isEmpty()) {
                RocksetResultSet.log("Extracting column information from explicit fields");
                for (QueryFieldType field : response.getColumnFields()) {
                    Column.ColumnTypes valueType = Column.ColumnTypes.fromValue(field.getType());
                    if (valueType == null) {
                        valueType = Column.ColumnTypes.STRING;
                    }
                    Column c = new Column(field.getName(), valueType);
                    out.add(c);
                }
            }
            return out;
        }
        catch (Exception e) {
            RocksetResultSet.log("Error processing row to extract column info exception" + e.getMessage());
            throw new SQLException("Error processing row to extract column info exception", e);
        }
    }

    @Nullable
    private static Column.ColumnTypes valueToColumnType(JsonNode value) {
        Column.ColumnTypes type = Column.ColumnTypes.fromValue(value.getNodeType().toString());
        if (type.equals((Object)Column.ColumnTypes.STRING)) {
            java.time.format.DateTimeFormatter format = TIMESTAMP_PARSE_FORMAT;
            try {
                LocalDateTime.parse(value.asText(), format);
                type = Column.ColumnTypes.TIMESTAMP;
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        if (type.equals((Object)Column.ColumnTypes.OBJECT) && value.get("__rockset_type") != null) {
            type = Column.ColumnTypes.fromValue(value.get("__rockset_type").asText());
        }
        return type;
    }

    private static Map<String, Integer> getFieldMap(List<Column> columns) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < columns.size(); ++i) {
            String name = columns.get(i).getName().toLowerCase(Locale.ENGLISH);
            if (map.containsKey(name)) continue;
            map.put(name, i + 1);
        }
        return ImmutableMap.copyOf(map);
    }

    private boolean doNext() throws SQLException {
        this.checkOpen();
        this.rowIndex.getAndIncrement();
        if (this.rocksetResultSetPaginationParams != null && this.rocksetResultSetPaginationParams.getFetchSize() > 0) {
            return this.doNextIfPaginationEnabled();
        }
        return this.doNextIfPaginationDisabled();
    }

    private JsonNode parseCurrentDocRootNode() throws SQLException {
        int index = this.rowIndex.get();
        Object onedoc = this.resultSet.get(index);
        try {
            String asJson = OBJECT_MAPPER.writeValueAsString(onedoc);
            return OBJECT_MAPPER.readTree(asJson);
        }
        catch (JsonProcessingException e) {
            throw new SQLException("Error caching document root node at row index " + index, e);
        }
    }
}

