/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.jdbc;

import com.google.common.collect.ImmutableList;
import com.rockset.jdbc.Column;
import com.rockset.jdbc.RocksetUtils;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class RocksetResultSetMetaData
implements ResultSetMetaData {
    private final List<Column> columnInfo;

    RocksetResultSetMetaData() {
        this.columnInfo = new LinkedList<Column>();
    }

    RocksetResultSetMetaData(List<Column> columnInfo) {
        this.columnInfo = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnInfo, "columnInfo is null"));
    }

    @Override
    public int getColumnCount() {
        return this.columnInfo.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 1;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return true;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return 10;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.column(column).getName();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.column(column).getName();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return 2;
    }

    @Override
    public int getScale(int column) throws SQLException {
        return 2;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "commons";
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "rockset";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        Column.ColumnTypes type = this.column(column).getType();
        return RocksetUtils.jsonToSqlType(type);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        Column.ColumnTypes type = this.column(column).getType();
        return RocksetUtils.jsonToSqlTypeName(type);
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        switch (this.getColumnType(column)) {
            case 2: 
            case 3: {
                return BigDecimal.class.getName();
            }
            case -7: 
            case 16: {
                return Boolean.class.getName();
            }
            case -6: {
                return Byte.class.getName();
            }
            case 5: {
                return Short.class.getName();
            }
            case 4: {
                return Integer.class.getName();
            }
            case -5: {
                return Long.class.getName();
            }
            case 7: {
                return Float.class.getName();
            }
            case 6: 
            case 8: {
                return Double.class.getName();
            }
            case -4: 
            case -3: 
            case -2: {
                return "byte[]";
            }
            case 91: {
                return Date.class.getName();
            }
            case 92: {
                return Time.class.getName();
            }
            case 93: {
                return Timestamp.class.getName();
            }
            case 2004: {
                return Blob.class.getName();
            }
            case 2005: {
                return Clob.class.getName();
            }
            case 2003: {
                return Array.class.getName();
            }
        }
        return String.class.getName();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException("No wrapper for " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    private Column column(int column) throws SQLException {
        if (column <= 0 || column > this.columnInfo.size()) {
            throw new SQLException("Invalid column index: " + column);
        }
        return this.columnInfo.get(column - 1);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int num = 0;
        for (Column c : this.columnInfo) {
            buf.append(c.toString());
            if (++num >= this.getColumnCount()) continue;
            buf.append(",");
        }
        return buf.toString();
    }
}

