/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.jdbc;

import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import com.rockset.client.model.QueryParameter;
import com.rockset.client.model.QueryResponse;
import com.rockset.jdbc.RocksetConnection;
import com.rockset.jdbc.RocksetDriver;
import com.rockset.jdbc.RocksetResultSet;
import com.rockset.jdbc.RocksetResultSetPaginationParams;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class RocksetStatement
implements Statement {
    private final AtomicLong maxRows = new AtomicLong();
    private final AtomicInteger queryTimeoutSeconds = new AtomicInteger();
    private final AtomicInteger fetchSize = new AtomicInteger();
    private final AtomicBoolean escapeProcessing = new AtomicBoolean(true);
    private final AtomicBoolean closeOnCompletion = new AtomicBoolean();
    private final AtomicReference<RocksetConnection> connection;
    private final AtomicReference<ResultSet> currentResult = new AtomicReference();
    private final AtomicLong currentUpdateCount = new AtomicLong(-1L);

    RocksetStatement(RocksetConnection connection) {
        this.connection = new AtomicReference<RocksetConnection>(Objects.requireNonNull(connection, "connection is null"));
        this.fetchSize.set(this.connection.get().getFetchSize());
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (!this.execute(sql)) {
            throw new SQLException("SQL statement is not a query: " + sql);
        }
        return this.currentResult.get();
    }

    @Override
    public void close() throws SQLException {
        if (this.connection.getAndSet(null) != null) {
            // empty if block
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkOpen();
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkOpen();
        if (max < 0) {
            throw new SQLException("Max field size must be positive");
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        long result = this.getLargeMaxRows();
        if (result > Integer.MAX_VALUE) {
            throw new SQLException("Max rows exceeds limit of 2147483647");
        }
        return Math.toIntExact(result);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        this.checkOpen();
        return this.maxRows.get();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.setLargeMaxRows(max);
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.checkOpen();
        if (max < 0L) {
            throw new SQLException("Max rows must be positive");
        }
        this.maxRows.set(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkOpen();
        this.escapeProcessing.set(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkOpen();
        return this.queryTimeoutSeconds.get();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkOpen();
        if (seconds < 0) {
            throw new SQLException("Query timeout seconds must be positive");
        }
        this.queryTimeoutSeconds.set(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("You have to live with it!");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkOpen();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.executeWithParams(sql, null);
    }

    private static String getNextCursorFromQueryResponse(QueryResponse response) {
        if (response.getPagination() != null) {
            return response.getPagination().getNextCursor();
        }
        return null;
    }

    private static String getQueryIdFromQueryResponse(QueryResponse response) {
        return response.getQueryId();
    }

    protected boolean executeWithParams(String sql, List<QueryParameter> params) throws SQLException {
        this.clearCurrentResults();
        this.checkOpen();
        String schema = this.connection.get().getSchema();
        String sqlWithWorkspace = schema.equals("commons") ? sql : String.format("OPTION(default_workspace='%s')\n %s", schema, sql);
        ResultSet resultSet = null;
        try {
            QueryResponse resp = this.connection().startQuery(sqlWithWorkspace, this.fetchSize.get(), params, this.getStatementSessionProperties());
            resultSet = new RocksetResultSet(sqlWithWorkspace, resp, this.maxRows.get(), RocksetResultSetPaginationParams.builder().connection(this.connection()).fetchSize(this.fetchSize.get()).lastQueryId(RocksetStatement.getQueryIdFromQueryResponse(resp)).currentCursor(RocksetStatement.getNextCursorFromQueryResponse(resp)).build());
            this.currentResult.set(resultSet);
            boolean bl = true;
            return bl;
        }
        catch (RuntimeException e) {
            String msg = "Error executing query '" + sqlWithWorkspace + "' error =  " + e.getMessage();
            RocksetDriver.log(msg);
            throw new SQLException(msg, e);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), e);
        }
        finally {
            if (this.currentResult.get() == null && resultSet != null) {
                resultSet.close();
            }
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        return this.currentResult.get();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return Ints.saturatedCast((long)this.getLargeUpdateCount());
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.checkOpen();
        return this.currentUpdateCount.get();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        RocksetDriver.log("Entry: Statement getMoreResults");
        this.checkOpen();
        this.currentResult.get().close();
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkOpen();
        if (!RocksetStatement.validFetchDirection(direction)) {
            throw new SQLException("Invalid fetch direction");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
        if (rows < 0) {
            throw new SQLException("Fetch size must be positive");
        }
        this.fetchSize.set(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return this.fetchSize.get();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkOpen();
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Batches not supported");
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Batches not supported");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Batches not supported");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkOpen();
        if (current == 1) {
            this.currentResult.get().close();
            return false;
        }
        if (current != 2 && current != 3) {
            throw new SQLException("Invalid argument: " + current);
        }
        throw new SQLFeatureNotSupportedException("Multiple open results not supported");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException("getGeneratedKeys");
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return Ints.saturatedCast((long)this.executeLargeUpdate(sql));
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        if (this.execute(sql)) {
            throw new SQLException("SQL is not an update statement: " + sql);
        }
        return this.currentUpdateCount.get();
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeLargeUpdate(sql);
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeLargeUpdate(sql);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeLargeUpdate(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connection.get() == null;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkOpen();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkOpen();
        this.closeOnCompletion.set(true);
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkOpen();
        return this.closeOnCompletion.get();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException("No wrapper for " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    protected void checkOpen() throws SQLException {
        this.connection();
    }

    private RocksetConnection connection() throws SQLException {
        RocksetConnection connection = this.connection.get();
        if (connection == null) {
            throw new SQLException("Statement is closed");
        }
        if (connection.isClosed()) {
            throw new SQLException("Connection is closed");
        }
        return connection;
    }

    private static boolean validFetchDirection(int direction) {
        return direction == 1000 || direction == 1001 || direction == 1002;
    }

    private Map<String, String> getStatementSessionProperties() {
        ImmutableMap.Builder sessionProperties = ImmutableMap.builder();
        if (this.queryTimeoutSeconds.get() > 0) {
            sessionProperties.put((Object)"query_max_run_time", (Object)(this.queryTimeoutSeconds.get() + "s"));
        }
        return sessionProperties.build();
    }

    private void clearCurrentResults() {
        this.currentResult.set(null);
        this.currentUpdateCount.set(-1L);
    }
}

