/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.jdbc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.rockset.client.model.QueryResponse;
import com.rockset.jdbc.Column;
import com.rockset.jdbc.RocksetArray;
import com.rockset.jdbc.RocksetResultSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

class RocksetTable {
    private String catalog;
    private String schema;
    private String tableName;
    private QueryResponse response;
    private RocksetResultSet describe;
    final ObjectMapper mapper;
    final int fieldNameIndex = 1;
    final int fieldTypeIndex = 2;

    public RocksetTable(String catalog, String schema, String tableNamePattern, QueryResponse response) throws SQLException {
        this.catalog = catalog;
        this.schema = schema;
        this.tableName = Objects.requireNonNull(tableNamePattern, "tableName is null");
        this.response = Objects.requireNonNull(response, "tableName is null");
        this.mapper = new ObjectMapper();
        this.dump(response);
        this.describe = null;
    }

    public ResultSet getColumns() throws Exception {
        if (this.describe == null) {
            ArrayList<Column> incol = new ArrayList<Column>();
            incol.add(new Column("field", Column.ColumnTypes.ARRAY));
            incol.add(new Column("type", Column.ColumnTypes.STRING));
            incol.add(new Column("occurrences", Column.ColumnTypes.NUMBER));
            incol.add(new Column("total", Column.ColumnTypes.NUMBER));
            List<Object> fieldsDescription = this.response.getResults();
            this.describe = new RocksetResultSet(incol, fieldsDescription);
        }
        Column col1 = new Column("TABLE_CAT", Column.ColumnTypes.STRING);
        Column col2 = new Column("TABLE_SCHEM", Column.ColumnTypes.STRING);
        Column col3 = new Column("TABLE_NAME", Column.ColumnTypes.STRING);
        Column col4 = new Column("COLUMN_NAME", Column.ColumnTypes.STRING);
        Column col5 = new Column("DATA_TYPE", Column.ColumnTypes.NUMBER);
        Column col6 = new Column("TYPE_NAME", Column.ColumnTypes.STRING);
        Column col7 = new Column("COLUMN_SIZE", Column.ColumnTypes.NUMBER);
        Column col8 = new Column("BUFFER_LENGTH", Column.ColumnTypes.STRING);
        Column col9 = new Column("DECIMAL_DIGITS", Column.ColumnTypes.NUMBER);
        Column col10 = new Column("NUM_PREC_RADIX", Column.ColumnTypes.NUMBER);
        Column col11 = new Column("NULLABLE", Column.ColumnTypes.NUMBER);
        Column col12 = new Column("REMARKS", Column.ColumnTypes.STRING);
        Column col13 = new Column("COLUMN_DEF", Column.ColumnTypes.STRING);
        Column col14 = new Column("SQL_DATA_TYPE", Column.ColumnTypes.NUMBER);
        Column col15 = new Column("SQL_DATETIME_SUB", Column.ColumnTypes.NUMBER);
        Column col16 = new Column("CHAR_OCTET_LENGTH", Column.ColumnTypes.NUMBER);
        Column col17 = new Column("ORDINAL_POSITION", Column.ColumnTypes.NUMBER);
        Column col18 = new Column("IS_NULLABLE", Column.ColumnTypes.STRING);
        Column col19 = new Column("SCOPE_CATALOG", Column.ColumnTypes.STRING);
        Column col20 = new Column("SCOPE_SCHEMA", Column.ColumnTypes.STRING);
        Column col21 = new Column("SCOPE_TABLE", Column.ColumnTypes.STRING);
        Column col22 = new Column("SOURCE_DATA_TYPE", Column.ColumnTypes.NUMBER);
        Column col23 = new Column("IS_AUTOINCREMENT", Column.ColumnTypes.STRING);
        Column col24 = new Column("IS_GENERATEDCOLUMN", Column.ColumnTypes.STRING);
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(col1);
        columns.add(col2);
        columns.add(col3);
        columns.add(col4);
        columns.add(col5);
        columns.add(col6);
        columns.add(col7);
        columns.add(col8);
        columns.add(col9);
        columns.add(col10);
        columns.add(col11);
        columns.add(col12);
        columns.add(col13);
        columns.add(col14);
        columns.add(col15);
        columns.add(col16);
        columns.add(col17);
        columns.add(col18);
        columns.add(col19);
        columns.add(col20);
        columns.add(col21);
        columns.add(col22);
        columns.add(col23);
        columns.add(col24);
        HashMap<String, RocksetArray> arrayAndObjectFields = new HashMap<String, RocksetArray>();
        ArrayList<Object> data = new ArrayList<Object>();
        int position = 0;
        String fieldName = "";
        String prevFieldName = "";
        ArrayList<JsonNode> fieldNameGroupedList = new ArrayList<JsonNode>();
        JsonNode docRootNodeOfNullDataType = null;
        while (this.describe.next()) {
            RocksetArray arr = (RocksetArray)this.describe.getObject("field");
            JsonNode[] nodes = (JsonNode[])arr.getArray(1L, 1);
            fieldName = nodes[0].asText();
            if (arr.size() > 1 && arrayAndObjectFields.containsKey(fieldName)) continue;
            boolean foundWildcard = false;
            for (int i = 1; i < nodes.length; ++i) {
                JsonNode n = nodes[i];
                if (n.asText().equals("*")) {
                    foundWildcard = true;
                    break;
                }
                fieldName = String.format("%s.%s", fieldName, n.asText());
                System.err.println("X1 " + fieldName);
            }
            if (foundWildcard) continue;
            String rockType = ((JsonNode)this.describe.getObject("type")).asText();
            int sqlType = 1111;
            String sqlTypeName = "";
            boolean isChar = false;
            boolean isNumber = false;
            if (rockType.equals("array")) {
                arrayAndObjectFields.put(fieldName, arr);
                sqlType = 2003;
                sqlTypeName = "array";
            } else if (rockType.equals("int")) {
                sqlType = -5;
                sqlTypeName = "bigint";
                isNumber = true;
            } else if (rockType.equals("string")) {
                sqlType = 12;
                sqlTypeName = "varchar";
                isChar = true;
            } else if (rockType.equals("object")) {
                arrayAndObjectFields.put(fieldName, arr);
                sqlType = 2000;
                sqlTypeName = "object";
            } else if (rockType.equals("float")) {
                sqlType = 8;
                sqlTypeName = "double";
                isNumber = true;
            } else if (rockType.equals("bool")) {
                sqlType = 16;
                sqlTypeName = "boolean";
            } else if (rockType.equals("bytes")) {
                sqlType = -2;
                sqlTypeName = "binary";
            } else if (rockType.equals("date")) {
                sqlType = 91;
                sqlTypeName = "date";
            } else if (rockType.equals("datetime")) {
                sqlType = 93;
                sqlTypeName = "datetime";
            } else if (rockType.equals("time")) {
                sqlType = 92;
                sqlTypeName = "time";
            } else if (rockType.equals("timestamp")) {
                sqlType = 93;
                sqlTypeName = "timestamp";
            } else if (rockType.equals("null")) {
                sqlType = 0;
                sqlTypeName = "null";
            } else if (rockType.equals("geography")) {
                sqlType = 2000;
                sqlTypeName = "object";
            } else if (rockType.equals("u256")) {
                sqlType = -5;
                sqlTypeName = "bigint";
            } else {
                throw new Exception("Unknown rockset type " + rockType);
            }
            String str = "{\"TABLE_CAT\": \"" + this.catalog + "\", \"TABLE_SCHEM\": \"" + this.schema + "\", \"TABLE_NAME\": \"" + this.tableName + "\"";
            str = str + ", \"COLUMN_NAME\": \"" + fieldName + "\"";
            str = str + ", \"DATA_TYPE\": " + sqlType;
            str = str + ", \"TYPE_NAME\": \"" + sqlTypeName + "\"";
            str = str + ", \"COLUMN_SIZE\": 255";
            str = str + ", \"DECIMAL_DIGITS\": " + (isNumber ? 2 : 0);
            str = str + ", \"NUM_PREC_RADIX\": 2";
            str = str + ", \"NULLABLE\": 1";
            str = str + ", \"REMARKS\": \"\"";
            str = str + ", \"COLUMN_DEF\": \"\"";
            str = str + ", \"CHAR_OCTET_LENGTH\": " + (isChar ? 255 : 0);
            str = str + ", \"ORDINAL_POSITION\": " + position;
            str = str + ", \"IS_NULLABLE\": \"YES\"";
            str = str + ", \"SCOPE_CATALOG\": \"\"";
            str = str + ", \"SCOPE_SCHEMA\": \"\"";
            str = str + ", \"SCOPE_TABLE\": \"\"";
            str = str + ", \"SOURCE_DATA_TYPE\": " + sqlType;
            str = str + ", \"IS_AUTOINCREMENT\": \"\"";
            str = str + ", \"IS_GENERATEDCOLUMN\": \"\"";
            str = str + " }";
            if (!fieldName.equals(prevFieldName)) {
                docRootNodeOfNullDataType = null;
                for (JsonNode docRootNode : fieldNameGroupedList) {
                    if (docRootNode.get("DATA_TYPE").asInt() == 0) {
                        docRootNodeOfNullDataType = docRootNode;
                        continue;
                    }
                    data.add(docRootNode);
                }
                if (docRootNodeOfNullDataType != null) {
                    data.add(docRootNodeOfNullDataType);
                }
                prevFieldName = fieldName;
                fieldNameGroupedList.clear();
            }
            fieldNameGroupedList.add(this.mapper.readTree(str));
            ++position;
        }
        docRootNodeOfNullDataType = null;
        for (JsonNode docRootNode : fieldNameGroupedList) {
            if (docRootNode.get("DATA_TYPE").asInt() == 0) {
                docRootNodeOfNullDataType = docRootNode;
                continue;
            }
            data.add(docRootNode);
        }
        if (docRootNodeOfNullDataType != null) {
            data.add(docRootNodeOfNullDataType);
        }
        return new RocksetResultSet(columns, data);
    }

    private void dump(QueryResponse resp) {
        try {
            List<Object> results = resp.getResults();
            int i = 0;
            for (Object onerow : results) {
                System.err.println(String.format("[%d] %s", i, this.mapper.writeValueAsString(onerow)));
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("Error in dump " + e.getMessage());
        }
    }
}

