/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.jdbc;

import com.rockset.jdbc.Column;
import java.sql.SQLException;

class RocksetUtils {
    RocksetUtils() {
    }

    static int jsonToSqlType(Column.ColumnTypes type) {
        int stype = 1111;
        switch (type) {
            case ARRAY: {
                stype = 2003;
                break;
            }
            case BINARY: {
                stype = -2;
                break;
            }
            case BOOLEAN: {
                stype = 16;
                break;
            }
            case MISSING: 
            case NULL: {
                stype = 0;
                break;
            }
            case NUMBER: {
                stype = 8;
                break;
            }
            case OBJECT: 
            case POJO: {
                stype = 2000;
                break;
            }
            case STRING: {
                stype = 12;
                break;
            }
            case TIMESTAMP: {
                stype = 93;
                break;
            }
            case DATETIME: {
                stype = 93;
                break;
            }
            case TIME: {
                stype = 92;
                break;
            }
            case DATE: {
                stype = 91;
                break;
            }
            case U256: {
                stype = -5;
            }
        }
        return stype;
    }

    static String jsonToSqlTypeName(Column.ColumnTypes type) {
        String stype = "other";
        switch (type) {
            case ARRAY: {
                stype = "array";
                break;
            }
            case BINARY: {
                stype = "binary";
                break;
            }
            case BOOLEAN: {
                stype = "boolean";
                break;
            }
            case MISSING: 
            case NULL: {
                stype = "null";
                break;
            }
            case NUMBER: {
                stype = "bigint";
                break;
            }
            case OBJECT: 
            case POJO: {
                stype = "object";
                break;
            }
            case STRING: {
                stype = "varchar";
                break;
            }
            case DATE: {
                stype = "date";
                break;
            }
            case TIME: {
                stype = "time";
                break;
            }
            case DATETIME: {
                stype = "datetime";
                break;
            }
            case TIMESTAMP: {
                stype = "timestamp";
                break;
            }
        }
        return stype;
    }

    static String sqlTypeToRocksetTypeNames(int sqlType) throws SQLException {
        String rtype = "";
        switch (sqlType) {
            case 2003: {
                rtype = "array";
                break;
            }
            case -2: {
                rtype = "bytes";
                break;
            }
            case 16: {
                rtype = "bool";
                break;
            }
            case 0: {
                rtype = "null";
                break;
            }
            case 2: {
                rtype = "int";
                break;
            }
            case 12: {
                rtype = "string";
                break;
            }
            case 93: {
                rtype = "timestamp";
                break;
            }
            case 92: {
                rtype = "time";
                break;
            }
            case 91: {
                rtype = "date";
                break;
            }
            default: {
                throw new SQLException("Unknown sql type  " + sqlType);
            }
        }
        return rtype;
    }
}

