package com.rojoma.json.v3
package `-impl`.codec

import com.rojoma.json.v3.codec._
import com.rojoma.json.v3.codec.JsonDecode.DecodeResult
import com.rojoma.json.v3.ast.{JValue, JArray}

class TupleDecode {
  implicit def tuple2Decode[A,B]( implicit cA: JsonDecode[A],cB: JsonDecode[B]) = new JsonDecode[(A,B)] {
    private def pathErr(err: DecodeError, n: Int) = Left(err.prefix(n - 1))
    def decode(jvalue: JValue): DecodeResult[(A,B)] = jvalue match {
      case JArray(Seq(eA,eB)) =>
        val dA = cA.decode(eA) match { case Right(result) => result; case Left(err) => return pathErr(err, 1) }
        val dB = cB.decode(eB) match { case Right(result) => result; case Left(err) => return pathErr(err, 2) }
        Right((dA,dB))
      case arr: JArray =>
        Left(DecodeError.InvalidLength(expected = 2, got = arr.length))
      case other =>
        Left(DecodeError.InvalidType(expected = JArray, got = other.jsonType))
    }
  }
  implicit def tuple3Decode[A,B,C]( implicit cA: JsonDecode[A],cB: JsonDecode[B],cC: JsonDecode[C]) = new JsonDecode[(A,B,C)] {
    private def pathErr(err: DecodeError, n: Int) = Left(err.prefix(n - 1))
    def decode(jvalue: JValue): DecodeResult[(A,B,C)] = jvalue match {
      case JArray(Seq(eA,eB,eC)) =>
        val dA = cA.decode(eA) match { case Right(result) => result; case Left(err) => return pathErr(err, 1) }
        val dB = cB.decode(eB) match { case Right(result) => result; case Left(err) => return pathErr(err, 2) }
        val dC = cC.decode(eC) match { case Right(result) => result; case Left(err) => return pathErr(err, 3) }
        Right((dA,dB,dC))
      case arr: JArray =>
        Left(DecodeError.InvalidLength(expected = 3, got = arr.length))
      case other =>
        Left(DecodeError.InvalidType(expected = JArray, got = other.jsonType))
    }
  }
  implicit def tuple4Decode[A,B,C,D]( implicit cA: JsonDecode[A],cB: JsonDecode[B],cC: JsonDecode[C],cD: JsonDecode[D]) = new JsonDecode[(A,B,C,D)] {
    private def pathErr(err: DecodeError, n: Int) = Left(err.prefix(n - 1))
    def decode(jvalue: JValue): DecodeResult[(A,B,C,D)] = jvalue match {
      case JArray(Seq(eA,eB,eC,eD)) =>
        val dA = cA.decode(eA) match { case Right(result) => result; case Left(err) => return pathErr(err, 1) }
        val dB = cB.decode(eB) match { case Right(result) => result; case Left(err) => return pathErr(err, 2) }
        val dC = cC.decode(eC) match { case Right(result) => result; case Left(err) => return pathErr(err, 3) }
        val dD = cD.decode(eD) match { case Right(result) => result; case Left(err) => return pathErr(err, 4) }
        Right((dA,dB,dC,dD))
      case arr: JArray =>
        Left(DecodeError.InvalidLength(expected = 4, got = arr.length))
      case other =>
        Left(DecodeError.InvalidType(expected = JArray, got = other.jsonType))
    }
  }
  implicit def tuple5Decode[A,B,C,D,E]( implicit cA: JsonDecode[A],cB: JsonDecode[B],cC: JsonDecode[C],cD: JsonDecode[D],cE: JsonDecode[E]) = new JsonDecode[(A,B,C,D,E)] {
    private def pathErr(err: DecodeError, n: Int) = Left(err.prefix(n - 1))
    def decode(jvalue: JValue): DecodeResult[(A,B,C,D,E)] = jvalue match {
      case JArray(Seq(eA,eB,eC,eD,eE)) =>
        val dA = cA.decode(eA) match { case Right(result) => result; case Left(err) => return pathErr(err, 1) }
        val dB = cB.decode(eB) match { case Right(result) => result; case Left(err) => return pathErr(err, 2) }
        val dC = cC.decode(eC) match { case Right(result) => result; case Left(err) => return pathErr(err, 3) }
        val dD = cD.decode(eD) match { case Right(result) => result; case Left(err) => return pathErr(err, 4) }
        val dE = cE.decode(eE) match { case Right(result) => result; case Left(err) => return pathErr(err, 5) }
        Right((dA,dB,dC,dD,dE))
      case arr: JArray =>
        Left(DecodeError.InvalidLength(expected = 5, got = arr.length))
      case other =>
        Left(DecodeError.InvalidType(expected = JArray, got = other.jsonType))
    }
  }
  implicit def tuple6Decode[A,B,C,D,E,F]( implicit cA: JsonDecode[A],cB: JsonDecode[B],cC: JsonDecode[C],cD: JsonDecode[D],cE: JsonDecode[E],cF: JsonDecode[F]) = new JsonDecode[(A,B,C,D,E,F)] {
    private def pathErr(err: DecodeError, n: Int) = Left(err.prefix(n - 1))
    def decode(jvalue: JValue): DecodeResult[(A,B,C,D,E,F)] = jvalue match {
      case JArray(Seq(eA,eB,eC,eD,eE,eF)) =>
        val dA = cA.decode(eA) match { case Right(result) => result; case Left(err) => return pathErr(err, 1) }
        val dB = cB.decode(eB) match { case Right(result) => result; case Left(err) => return pathErr(err, 2) }
        val dC = cC.decode(eC) match { case Right(result) => result; case Left(err) => return pathErr(err, 3) }
        val dD = cD.decode(eD) match { case Right(result) => result; case Left(err) => return pathErr(err, 4) }
        val dE = cE.decode(eE) match { case Right(result) => result; case Left(err) => return pathErr(err, 5) }
        val dF = cF.decode(eF) match { case Right(result) => result; case Left(err) => return pathErr(err, 6) }
        Right((dA,dB,dC,dD,dE,dF))
      case arr: JArray =>
        Left(DecodeError.InvalidLength(expected = 6, got = arr.length))
      case other =>
        Left(DecodeError.InvalidType(expected = JArray, got = other.jsonType))
    }
  }
  implicit def tuple7Decode[A,B,C,D,E,F,G]( implicit cA: JsonDecode[A],cB: JsonDecode[B],cC: JsonDecode[C],cD: JsonDecode[D],cE: JsonDecode[E],cF: JsonDecode[F],cG: JsonDecode[G]) = new JsonDecode[(A,B,C,D,E,F,G)] {
    private def pathErr(err: DecodeError, n: Int) = Left(err.prefix(n - 1))
    def decode(jvalue: JValue): DecodeResult[(A,B,C,D,E,F,G)] = jvalue match {
      case JArray(Seq(eA,eB,eC,eD,eE,eF,eG)) =>
        val dA = cA.decode(eA) match { case Right(result) => result; case Left(err) => return pathErr(err, 1) }
        val dB = cB.decode(eB) match { case Right(result) => result; case Left(err) => return pathErr(err, 2) }
        val dC = cC.decode(eC) match { case Right(result) => result; case Left(err) => return pathErr(err, 3) }
        val dD = cD.decode(eD) match { case Right(result) => result; case Left(err) => return pathErr(err, 4) }
        val dE = cE.decode(eE) match { case Right(result) => result; case Left(err) => return pathErr(err, 5) }
        val dF = cF.decode(eF) match { case Right(result) => result; case Left(err) => return pathErr(err, 6) }
        val dG = cG.decode(eG) match { case Right(result) => result; case Left(err) => return pathErr(err, 7) }
        Right((dA,dB,dC,dD,dE,dF,dG))
      case arr: JArray =>
        Left(DecodeError.InvalidLength(expected = 7, got = arr.length))
      case other =>
        Left(DecodeError.InvalidType(expected = JArray, got = other.jsonType))
    }
  }
  implicit def tuple8Decode[A,B,C,D,E,F,G,H]( implicit cA: JsonDecode[A],cB: JsonDecode[B],cC: JsonDecode[C],cD: JsonDecode[D],cE: JsonDecode[E],cF: JsonDecode[F],cG: JsonDecode[G],cH: JsonDecode[H]) = new JsonDecode[(A,B,C,D,E,F,G,H)] {
    private def pathErr(err: DecodeError, n: Int) = Left(err.prefix(n - 1))
    def decode(jvalue: JValue): DecodeResult[(A,B,C,D,E,F,G,H)] = jvalue match {
      case JArray(Seq(eA,eB,eC,eD,eE,eF,eG,eH)) =>
        val dA = cA.decode(eA) match { case Right(result) => result; case Left(err) => return pathErr(err, 1) }
        val dB = cB.decode(eB) match { case Right(result) => result; case Left(err) => return pathErr(err, 2) }
        val dC = cC.decode(eC) match { case Right(result) => result; case Left(err) => return pathErr(err, 3) }
        val dD = cD.decode(eD) match { case Right(result) => result; case Left(err) => return pathErr(err, 4) }
        val dE = cE.decode(eE) match { case Right(result) => result; case Left(err) => return pathErr(err, 5) }
        val dF = cF.decode(eF) match { case Right(result) => result; case Left(err) => return pathErr(err, 6) }
        val dG = cG.decode(eG) match { case Right(result) => result; case Left(err) => return pathErr(err, 7) }
        val dH = cH.decode(eH) match { case Right(result) => result; case Left(err) => return pathErr(err, 8) }
        Right((dA,dB,dC,dD,dE,dF,dG,dH))
      case arr: JArray =>
        Left(DecodeError.InvalidLength(expected = 8, got = arr.length))
      case other =>
        Left(DecodeError.InvalidType(expected = JArray, got = other.jsonType))
    }
  }
  implicit def tuple9Decode[A,B,C,D,E,F,G,H,I]( implicit cA: JsonDecode[A],cB: JsonDecode[B],cC: JsonDecode[C],cD: JsonDecode[D],cE: JsonDecode[E],cF: JsonDecode[F],cG: JsonDecode[G],cH: JsonDecode[H],cI: JsonDecode[I]) = new JsonDecode[(A,B,C,D,E,F,G,H,I)] {
    private def pathErr(err: DecodeError, n: Int) = Left(err.prefix(n - 1))
    def decode(jvalue: JValue): DecodeResult[(A,B,C,D,E,F,G,H,I)] = jvalue match {
      case JArray(Seq(eA,eB,eC,eD,eE,eF,eG,eH,eI)) =>
        val dA = cA.decode(eA) match { case Right(result) => result; case Left(err) => return pathErr(err, 1) }
        val dB = cB.decode(eB) match { case Right(result) => result; case Left(err) => return pathErr(err, 2) }
        val dC = cC.decode(eC) match { case Right(result) => result; case Left(err) => return pathErr(err, 3) }
        val dD = cD.decode(eD) match { case Right(result) => result; case Left(err) => return pathErr(err, 4) }
        val dE = cE.decode(eE) match { case Right(result) => result; case Left(err) => return pathErr(err, 5) }
        val dF = cF.decode(eF) match { case Right(result) => result; case Left(err) => return pathErr(err, 6) }
        val dG = cG.decode(eG) match { case Right(result) => result; case Left(err) => return pathErr(err, 7) }
        val dH = cH.decode(eH) match { case Right(result) => result; case Left(err) => return pathErr(err, 8) }
        val dI = cI.decode(eI) match { case Right(result) => result; case Left(err) => return pathErr(err, 9) }
        Right((dA,dB,dC,dD,dE,dF,dG,dH,dI))
      case arr: JArray =>
        Left(DecodeError.InvalidLength(expected = 9, got = arr.length))
      case other =>
        Left(DecodeError.InvalidType(expected = JArray, got = other.jsonType))
    }
  }
  implicit def tuple10Decode[A,B,C,D,E,F,G,H,I,J]( implicit cA: JsonDecode[A],cB: JsonDecode[B],cC: JsonDecode[C],cD: JsonDecode[D],cE: JsonDecode[E],cF: JsonDecode[F],cG: JsonDecode[G],cH: JsonDecode[H],cI: JsonDecode[I],cJ: JsonDecode[J]) = new JsonDecode[(A,B,C,D,E,F,G,H,I,J)] {
    private def pathErr(err: DecodeError, n: Int) = Left(err.prefix(n - 1))
    def decode(jvalue: JValue): DecodeResult[(A,B,C,D,E,F,G,H,I,J)] = jvalue match {
      case JArray(Seq(eA,eB,eC,eD,eE,eF,eG,eH,eI,eJ)) =>
        val dA = cA.decode(eA) match { case Right(result) => result; case Left(err) => return pathErr(err, 1) }
        val dB = cB.decode(eB) match { case Right(result) => result; case Left(err) => return pathErr(err, 2) }
        val dC = cC.decode(eC) match { case Right(result) => result; case Left(err) => return pathErr(err, 3) }
        val dD = cD.decode(eD) match { case Right(result) => result; case Left(err) => return pathErr(err, 4) }
        val dE = cE.decode(eE) match { case Right(result) => result; case Left(err) => return pathErr(err, 5) }
        val dF = cF.decode(eF) match { case Right(result) => result; case Left(err) => return pathErr(err, 6) }
        val dG = cG.decode(eG) match { case Right(result) => result; case Left(err) => return pathErr(err, 7) }
        val dH = cH.decode(eH) match { case Right(result) => result; case Left(err) => return pathErr(err, 8) }
        val dI = cI.decode(eI) match { case Right(result) => result; case Left(err) => return pathErr(err, 9) }
        val dJ = cJ.decode(eJ) match { case Right(result) => result; case Left(err) => return pathErr(err, 10) }
        Right((dA,dB,dC,dD,dE,dF,dG,dH,dI,dJ))
      case arr: JArray =>
        Left(DecodeError.InvalidLength(expected = 10, got = arr.length))
      case other =>
        Left(DecodeError.InvalidType(expected = JArray, got = other.jsonType))
    }
  }
  implicit def tuple11Decode[A,B,C,D,E,F,G,H,I,J,K]( implicit cA: JsonDecode[A],cB: JsonDecode[B],cC: JsonDecode[C],cD: JsonDecode[D],cE: JsonDecode[E],cF: JsonDecode[F],cG: JsonDecode[G],cH: JsonDecode[H],cI: JsonDecode[I],cJ: JsonDecode[J],cK: JsonDecode[K]) = new JsonDecode[(A,B,C,D,E,F,G,H,I,J,K)] {
    private def pathErr(err: DecodeError, n: Int) = Left(err.prefix(n - 1))
    def decode(jvalue: JValue): DecodeResult[(A,B,C,D,E,F,G,H,I,J,K)] = jvalue match {
      case JArray(Seq(eA,eB,eC,eD,eE,eF,eG,eH,eI,eJ,eK)) =>
        val dA = cA.decode(eA) match { case Right(result) => result; case Left(err) => return pathErr(err, 1) }
        val dB = cB.decode(eB) match { case Right(result) => result; case Left(err) => return pathErr(err, 2) }
        val dC = cC.decode(eC) match { case Right(result) => result; case Left(err) => return pathErr(err, 3) }
        val dD = cD.decode(eD) match { case Right(result) => result; case Left(err) => return pathErr(err, 4) }
        val dE = cE.decode(eE) match { case Right(result) => result; case Left(err) => return pathErr(err, 5) }
        val dF = cF.decode(eF) match { case Right(result) => result; case Left(err) => return pathErr(err, 6) }
        val dG = cG.decode(eG) match { case Right(result) => result; case Left(err) => return pathErr(err, 7) }
        val dH = cH.decode(eH) match { case Right(result) => result; case Left(err) => return pathErr(err, 8) }
        val dI = cI.decode(eI) match { case Right(result) => result; case Left(err) => return pathErr(err, 9) }
        val dJ = cJ.decode(eJ) match { case Right(result) => result; case Left(err) => return pathErr(err, 10) }
        val dK = cK.decode(eK) match { case Right(result) => result; case Left(err) => return pathErr(err, 11) }
        Right((dA,dB,dC,dD,dE,dF,dG,dH,dI,dJ,dK))
      case arr: JArray =>
        Left(DecodeError.InvalidLength(expected = 11, got = arr.length))
      case other =>
        Left(DecodeError.InvalidType(expected = JArray, got = other.jsonType))
    }
  }
  implicit def tuple12Decode[A,B,C,D,E,F,G,H,I,J,K,L]( implicit cA: JsonDecode[A],cB: JsonDecode[B],cC: JsonDecode[C],cD: JsonDecode[D],cE: JsonDecode[E],cF: JsonDecode[F],cG: JsonDecode[G],cH: JsonDecode[H],cI: JsonDecode[I],cJ: JsonDecode[J],cK: JsonDecode[K],cL: JsonDecode[L]) = new JsonDecode[(A,B,C,D,E,F,G,H,I,J,K,L)] {
    private def pathErr(err: DecodeError, n: Int) = Left(err.prefix(n - 1))
    def decode(jvalue: JValue): DecodeResult[(A,B,C,D,E,F,G,H,I,J,K,L)] = jvalue match {
      case JArray(Seq(eA,eB,eC,eD,eE,eF,eG,eH,eI,eJ,eK,eL)) =>
        val dA = cA.decode(eA) match { case Right(result) => result; case Left(err) => return pathErr(err, 1) }
        val dB = cB.decode(eB) match { case Right(result) => result; case Left(err) => return pathErr(err, 2) }
        val dC = cC.decode(eC) match { case Right(result) => result; case Left(err) => return pathErr(err, 3) }
        val dD = cD.decode(eD) match { case Right(result) => result; case Left(err) => return pathErr(err, 4) }
        val dE = cE.decode(eE) match { case Right(result) => result; case Left(err) => return pathErr(err, 5) }
        val dF = cF.decode(eF) match { case Right(result) => result; case Left(err) => return pathErr(err, 6) }
        val dG = cG.decode(eG) match { case Right(result) => result; case Left(err) => return pathErr(err, 7) }
        val dH = cH.decode(eH) match { case Right(result) => result; case Left(err) => return pathErr(err, 8) }
        val dI = cI.decode(eI) match { case Right(result) => result; case Left(err) => return pathErr(err, 9) }
        val dJ = cJ.decode(eJ) match { case Right(result) => result; case Left(err) => return pathErr(err, 10) }
        val dK = cK.decode(eK) match { case Right(result) => result; case Left(err) => return pathErr(err, 11) }
        val dL = cL.decode(eL) match { case Right(result) => result; case Left(err) => return pathErr(err, 12) }
        Right((dA,dB,dC,dD,dE,dF,dG,dH,dI,dJ,dK,dL))
      case arr: JArray =>
        Left(DecodeError.InvalidLength(expected = 12, got = arr.length))
      case other =>
        Left(DecodeError.InvalidType(expected = JArray, got = other.jsonType))
    }
  }
  implicit def tuple13Decode[A,B,C,D,E,F,G,H,I,J,K,L,M]( implicit cA: JsonDecode[A],cB: JsonDecode[B],cC: JsonDecode[C],cD: JsonDecode[D],cE: JsonDecode[E],cF: JsonDecode[F],cG: JsonDecode[G],cH: JsonDecode[H],cI: JsonDecode[I],cJ: JsonDecode[J],cK: JsonDecode[K],cL: JsonDecode[L],cM: JsonDecode[M]) = new JsonDecode[(A,B,C,D,E,F,G,H,I,J,K,L,M)] {
    private def pathErr(err: DecodeError, n: Int) = Left(err.prefix(n - 1))
    def decode(jvalue: JValue): DecodeResult[(A,B,C,D,E,F,G,H,I,J,K,L,M)] = jvalue match {
      case JArray(Seq(eA,eB,eC,eD,eE,eF,eG,eH,eI,eJ,eK,eL,eM)) =>
        val dA = cA.decode(eA) match { case Right(result) => result; case Left(err) => return pathErr(err, 1) }
        val dB = cB.decode(eB) match { case Right(result) => result; case Left(err) => return pathErr(err, 2) }
        val dC = cC.decode(eC) match { case Right(result) => result; case Left(err) => return pathErr(err, 3) }
        val dD = cD.decode(eD) match { case Right(result) => result; case Left(err) => return pathErr(err, 4) }
        val dE = cE.decode(eE) match { case Right(result) => result; case Left(err) => return pathErr(err, 5) }
        val dF = cF.decode(eF) match { case Right(result) => result; case Left(err) => return pathErr(err, 6) }
        val dG = cG.decode(eG) match { case Right(result) => result; case Left(err) => return pathErr(err, 7) }
        val dH = cH.decode(eH) match { case Right(result) => result; case Left(err) => return pathErr(err, 8) }
        val dI = cI.decode(eI) match { case Right(result) => result; case Left(err) => return pathErr(err, 9) }
        val dJ = cJ.decode(eJ) match { case Right(result) => result; case Left(err) => return pathErr(err, 10) }
        val dK = cK.decode(eK) match { case Right(result) => result; case Left(err) => return pathErr(err, 11) }
        val dL = cL.decode(eL) match { case Right(result) => result; case Left(err) => return pathErr(err, 12) }
        val dM = cM.decode(eM) match { case Right(result) => result; case Left(err) => return pathErr(err, 13) }
        Right((dA,dB,dC,dD,dE,dF,dG,dH,dI,dJ,dK,dL,dM))
      case arr: JArray =>
        Left(DecodeError.InvalidLength(expected = 13, got = arr.length))
      case other =>
        Left(DecodeError.InvalidType(expected = JArray, got = other.jsonType))
    }
  }
  implicit def tuple14Decode[A,B,C,D,E,F,G,H,I,J,K,L,M,N]( implicit cA: JsonDecode[A],cB: JsonDecode[B],cC: JsonDecode[C],cD: JsonDecode[D],cE: JsonDecode[E],cF: JsonDecode[F],cG: JsonDecode[G],cH: JsonDecode[H],cI: JsonDecode[I],cJ: JsonDecode[J],cK: JsonDecode[K],cL: JsonDecode[L],cM: JsonDecode[M],cN: JsonDecode[N]) = new JsonDecode[(A,B,C,D,E,F,G,H,I,J,K,L,M,N)] {
    private def pathErr(err: DecodeError, n: Int) = Left(err.prefix(n - 1))
    def decode(jvalue: JValue): DecodeResult[(A,B,C,D,E,F,G,H,I,J,K,L,M,N)] = jvalue match {
      case JArray(Seq(eA,eB,eC,eD,eE,eF,eG,eH,eI,eJ,eK,eL,eM,eN)) =>
        val dA = cA.decode(eA) match { case Right(result) => result; case Left(err) => return pathErr(err, 1) }
        val dB = cB.decode(eB) match { case Right(result) => result; case Left(err) => return pathErr(err, 2) }
        val dC = cC.decode(eC) match { case Right(result) => result; case Left(err) => return pathErr(err, 3) }
        val dD = cD.decode(eD) match { case Right(result) => result; case Left(err) => return pathErr(err, 4) }
        val dE = cE.decode(eE) match { case Right(result) => result; case Left(err) => return pathErr(err, 5) }
        val dF = cF.decode(eF) match { case Right(result) => result; case Left(err) => return pathErr(err, 6) }
        val dG = cG.decode(eG) match { case Right(result) => result; case Left(err) => return pathErr(err, 7) }
        val dH = cH.decode(eH) match { case Right(result) => result; case Left(err) => return pathErr(err, 8) }
        val dI = cI.decode(eI) match { case Right(result) => result; case Left(err) => return pathErr(err, 9) }
        val dJ = cJ.decode(eJ) match { case Right(result) => result; case Left(err) => return pathErr(err, 10) }
        val dK = cK.decode(eK) match { case Right(result) => result; case Left(err) => return pathErr(err, 11) }
        val dL = cL.decode(eL) match { case Right(result) => result; case Left(err) => return pathErr(err, 12) }
        val dM = cM.decode(eM) match { case Right(result) => result; case Left(err) => return pathErr(err, 13) }
        val dN = cN.decode(eN) match { case Right(result) => result; case Left(err) => return pathErr(err, 14) }
        Right((dA,dB,dC,dD,dE,dF,dG,dH,dI,dJ,dK,dL,dM,dN))
      case arr: JArray =>
        Left(DecodeError.InvalidLength(expected = 14, got = arr.length))
      case other =>
        Left(DecodeError.InvalidType(expected = JArray, got = other.jsonType))
    }
  }
  implicit def tuple15Decode[A,B,C,D,E,F,G,H,I,J,K,L,M,N,O]( implicit cA: JsonDecode[A],cB: JsonDecode[B],cC: JsonDecode[C],cD: JsonDecode[D],cE: JsonDecode[E],cF: JsonDecode[F],cG: JsonDecode[G],cH: JsonDecode[H],cI: JsonDecode[I],cJ: JsonDecode[J],cK: JsonDecode[K],cL: JsonDecode[L],cM: JsonDecode[M],cN: JsonDecode[N],cO: JsonDecode[O]) = new JsonDecode[(A,B,C,D,E,F,G,H,I,J,K,L,M,N,O)] {
    private def pathErr(err: DecodeError, n: Int) = Left(err.prefix(n - 1))
    def decode(jvalue: JValue): DecodeResult[(A,B,C,D,E,F,G,H,I,J,K,L,M,N,O)] = jvalue match {
      case JArray(Seq(eA,eB,eC,eD,eE,eF,eG,eH,eI,eJ,eK,eL,eM,eN,eO)) =>
        val dA = cA.decode(eA) match { case Right(result) => result; case Left(err) => return pathErr(err, 1) }
        val dB = cB.decode(eB) match { case Right(result) => result; case Left(err) => return pathErr(err, 2) }
        val dC = cC.decode(eC) match { case Right(result) => result; case Left(err) => return pathErr(err, 3) }
        val dD = cD.decode(eD) match { case Right(result) => result; case Left(err) => return pathErr(err, 4) }
        val dE = cE.decode(eE) match { case Right(result) => result; case Left(err) => return pathErr(err, 5) }
        val dF = cF.decode(eF) match { case Right(result) => result; case Left(err) => return pathErr(err, 6) }
        val dG = cG.decode(eG) match { case Right(result) => result; case Left(err) => return pathErr(err, 7) }
        val dH = cH.decode(eH) match { case Right(result) => result; case Left(err) => return pathErr(err, 8) }
        val dI = cI.decode(eI) match { case Right(result) => result; case Left(err) => return pathErr(err, 9) }
        val dJ = cJ.decode(eJ) match { case Right(result) => result; case Left(err) => return pathErr(err, 10) }
        val dK = cK.decode(eK) match { case Right(result) => result; case Left(err) => return pathErr(err, 11) }
        val dL = cL.decode(eL) match { case Right(result) => result; case Left(err) => return pathErr(err, 12) }
        val dM = cM.decode(eM) match { case Right(result) => result; case Left(err) => return pathErr(err, 13) }
        val dN = cN.decode(eN) match { case Right(result) => result; case Left(err) => return pathErr(err, 14) }
        val dO = cO.decode(eO) match { case Right(result) => result; case Left(err) => return pathErr(err, 15) }
        Right((dA,dB,dC,dD,dE,dF,dG,dH,dI,dJ,dK,dL,dM,dN,dO))
      case arr: JArray =>
        Left(DecodeError.InvalidLength(expected = 15, got = arr.length))
      case other =>
        Left(DecodeError.InvalidType(expected = JArray, got = other.jsonType))
    }
  }
  implicit def tuple16Decode[A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P]( implicit cA: JsonDecode[A],cB: JsonDecode[B],cC: JsonDecode[C],cD: JsonDecode[D],cE: JsonDecode[E],cF: JsonDecode[F],cG: JsonDecode[G],cH: JsonDecode[H],cI: JsonDecode[I],cJ: JsonDecode[J],cK: JsonDecode[K],cL: JsonDecode[L],cM: JsonDecode[M],cN: JsonDecode[N],cO: JsonDecode[O],cP: JsonDecode[P]) = new JsonDecode[(A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P)] {
    private def pathErr(err: DecodeError, n: Int) = Left(err.prefix(n - 1))
    def decode(jvalue: JValue): DecodeResult[(A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P)] = jvalue match {
      case JArray(Seq(eA,eB,eC,eD,eE,eF,eG,eH,eI,eJ,eK,eL,eM,eN,eO,eP)) =>
        val dA = cA.decode(eA) match { case Right(result) => result; case Left(err) => return pathErr(err, 1) }
        val dB = cB.decode(eB) match { case Right(result) => result; case Left(err) => return pathErr(err, 2) }
        val dC = cC.decode(eC) match { case Right(result) => result; case Left(err) => return pathErr(err, 3) }
        val dD = cD.decode(eD) match { case Right(result) => result; case Left(err) => return pathErr(err, 4) }
        val dE = cE.decode(eE) match { case Right(result) => result; case Left(err) => return pathErr(err, 5) }
        val dF = cF.decode(eF) match { case Right(result) => result; case Left(err) => return pathErr(err, 6) }
        val dG = cG.decode(eG) match { case Right(result) => result; case Left(err) => return pathErr(err, 7) }
        val dH = cH.decode(eH) match { case Right(result) => result; case Left(err) => return pathErr(err, 8) }
        val dI = cI.decode(eI) match { case Right(result) => result; case Left(err) => return pathErr(err, 9) }
        val dJ = cJ.decode(eJ) match { case Right(result) => result; case Left(err) => return pathErr(err, 10) }
        val dK = cK.decode(eK) match { case Right(result) => result; case Left(err) => return pathErr(err, 11) }
        val dL = cL.decode(eL) match { case Right(result) => result; case Left(err) => return pathErr(err, 12) }
        val dM = cM.decode(eM) match { case Right(result) => result; case Left(err) => return pathErr(err, 13) }
        val dN = cN.decode(eN) match { case Right(result) => result; case Left(err) => return pathErr(err, 14) }
        val dO = cO.decode(eO) match { case Right(result) => result; case Left(err) => return pathErr(err, 15) }
        val dP = cP.decode(eP) match { case Right(result) => result; case Left(err) => return pathErr(err, 16) }
        Right((dA,dB,dC,dD,dE,dF,dG,dH,dI,dJ,dK,dL,dM,dN,dO,dP))
      case arr: JArray =>
        Left(DecodeError.InvalidLength(expected = 16, got = arr.length))
      case other =>
        Left(DecodeError.InvalidType(expected = JArray, got = other.jsonType))
    }
  }
  implicit def tuple17Decode[A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q]( implicit cA: JsonDecode[A],cB: JsonDecode[B],cC: JsonDecode[C],cD: JsonDecode[D],cE: JsonDecode[E],cF: JsonDecode[F],cG: JsonDecode[G],cH: JsonDecode[H],cI: JsonDecode[I],cJ: JsonDecode[J],cK: JsonDecode[K],cL: JsonDecode[L],cM: JsonDecode[M],cN: JsonDecode[N],cO: JsonDecode[O],cP: JsonDecode[P],cQ: JsonDecode[Q]) = new JsonDecode[(A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q)] {
    private def pathErr(err: DecodeError, n: Int) = Left(err.prefix(n - 1))
    def decode(jvalue: JValue): DecodeResult[(A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q)] = jvalue match {
      case JArray(Seq(eA,eB,eC,eD,eE,eF,eG,eH,eI,eJ,eK,eL,eM,eN,eO,eP,eQ)) =>
        val dA = cA.decode(eA) match { case Right(result) => result; case Left(err) => return pathErr(err, 1) }
        val dB = cB.decode(eB) match { case Right(result) => result; case Left(err) => return pathErr(err, 2) }
        val dC = cC.decode(eC) match { case Right(result) => result; case Left(err) => return pathErr(err, 3) }
        val dD = cD.decode(eD) match { case Right(result) => result; case Left(err) => return pathErr(err, 4) }
        val dE = cE.decode(eE) match { case Right(result) => result; case Left(err) => return pathErr(err, 5) }
        val dF = cF.decode(eF) match { case Right(result) => result; case Left(err) => return pathErr(err, 6) }
        val dG = cG.decode(eG) match { case Right(result) => result; case Left(err) => return pathErr(err, 7) }
        val dH = cH.decode(eH) match { case Right(result) => result; case Left(err) => return pathErr(err, 8) }
        val dI = cI.decode(eI) match { case Right(result) => result; case Left(err) => return pathErr(err, 9) }
        val dJ = cJ.decode(eJ) match { case Right(result) => result; case Left(err) => return pathErr(err, 10) }
        val dK = cK.decode(eK) match { case Right(result) => result; case Left(err) => return pathErr(err, 11) }
        val dL = cL.decode(eL) match { case Right(result) => result; case Left(err) => return pathErr(err, 12) }
        val dM = cM.decode(eM) match { case Right(result) => result; case Left(err) => return pathErr(err, 13) }
        val dN = cN.decode(eN) match { case Right(result) => result; case Left(err) => return pathErr(err, 14) }
        val dO = cO.decode(eO) match { case Right(result) => result; case Left(err) => return pathErr(err, 15) }
        val dP = cP.decode(eP) match { case Right(result) => result; case Left(err) => return pathErr(err, 16) }
        val dQ = cQ.decode(eQ) match { case Right(result) => result; case Left(err) => return pathErr(err, 17) }
        Right((dA,dB,dC,dD,dE,dF,dG,dH,dI,dJ,dK,dL,dM,dN,dO,dP,dQ))
      case arr: JArray =>
        Left(DecodeError.InvalidLength(expected = 17, got = arr.length))
      case other =>
        Left(DecodeError.InvalidType(expected = JArray, got = other.jsonType))
    }
  }
  implicit def tuple18Decode[A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R]( implicit cA: JsonDecode[A],cB: JsonDecode[B],cC: JsonDecode[C],cD: JsonDecode[D],cE: JsonDecode[E],cF: JsonDecode[F],cG: JsonDecode[G],cH: JsonDecode[H],cI: JsonDecode[I],cJ: JsonDecode[J],cK: JsonDecode[K],cL: JsonDecode[L],cM: JsonDecode[M],cN: JsonDecode[N],cO: JsonDecode[O],cP: JsonDecode[P],cQ: JsonDecode[Q],cR: JsonDecode[R]) = new JsonDecode[(A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R)] {
    private def pathErr(err: DecodeError, n: Int) = Left(err.prefix(n - 1))
    def decode(jvalue: JValue): DecodeResult[(A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R)] = jvalue match {
      case JArray(Seq(eA,eB,eC,eD,eE,eF,eG,eH,eI,eJ,eK,eL,eM,eN,eO,eP,eQ,eR)) =>
        val dA = cA.decode(eA) match { case Right(result) => result; case Left(err) => return pathErr(err, 1) }
        val dB = cB.decode(eB) match { case Right(result) => result; case Left(err) => return pathErr(err, 2) }
        val dC = cC.decode(eC) match { case Right(result) => result; case Left(err) => return pathErr(err, 3) }
        val dD = cD.decode(eD) match { case Right(result) => result; case Left(err) => return pathErr(err, 4) }
        val dE = cE.decode(eE) match { case Right(result) => result; case Left(err) => return pathErr(err, 5) }
        val dF = cF.decode(eF) match { case Right(result) => result; case Left(err) => return pathErr(err, 6) }
        val dG = cG.decode(eG) match { case Right(result) => result; case Left(err) => return pathErr(err, 7) }
        val dH = cH.decode(eH) match { case Right(result) => result; case Left(err) => return pathErr(err, 8) }
        val dI = cI.decode(eI) match { case Right(result) => result; case Left(err) => return pathErr(err, 9) }
        val dJ = cJ.decode(eJ) match { case Right(result) => result; case Left(err) => return pathErr(err, 10) }
        val dK = cK.decode(eK) match { case Right(result) => result; case Left(err) => return pathErr(err, 11) }
        val dL = cL.decode(eL) match { case Right(result) => result; case Left(err) => return pathErr(err, 12) }
        val dM = cM.decode(eM) match { case Right(result) => result; case Left(err) => return pathErr(err, 13) }
        val dN = cN.decode(eN) match { case Right(result) => result; case Left(err) => return pathErr(err, 14) }
        val dO = cO.decode(eO) match { case Right(result) => result; case Left(err) => return pathErr(err, 15) }
        val dP = cP.decode(eP) match { case Right(result) => result; case Left(err) => return pathErr(err, 16) }
        val dQ = cQ.decode(eQ) match { case Right(result) => result; case Left(err) => return pathErr(err, 17) }
        val dR = cR.decode(eR) match { case Right(result) => result; case Left(err) => return pathErr(err, 18) }
        Right((dA,dB,dC,dD,dE,dF,dG,dH,dI,dJ,dK,dL,dM,dN,dO,dP,dQ,dR))
      case arr: JArray =>
        Left(DecodeError.InvalidLength(expected = 18, got = arr.length))
      case other =>
        Left(DecodeError.InvalidType(expected = JArray, got = other.jsonType))
    }
  }
  implicit def tuple19Decode[A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S]( implicit cA: JsonDecode[A],cB: JsonDecode[B],cC: JsonDecode[C],cD: JsonDecode[D],cE: JsonDecode[E],cF: JsonDecode[F],cG: JsonDecode[G],cH: JsonDecode[H],cI: JsonDecode[I],cJ: JsonDecode[J],cK: JsonDecode[K],cL: JsonDecode[L],cM: JsonDecode[M],cN: JsonDecode[N],cO: JsonDecode[O],cP: JsonDecode[P],cQ: JsonDecode[Q],cR: JsonDecode[R],cS: JsonDecode[S]) = new JsonDecode[(A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S)] {
    private def pathErr(err: DecodeError, n: Int) = Left(err.prefix(n - 1))
    def decode(jvalue: JValue): DecodeResult[(A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S)] = jvalue match {
      case JArray(Seq(eA,eB,eC,eD,eE,eF,eG,eH,eI,eJ,eK,eL,eM,eN,eO,eP,eQ,eR,eS)) =>
        val dA = cA.decode(eA) match { case Right(result) => result; case Left(err) => return pathErr(err, 1) }
        val dB = cB.decode(eB) match { case Right(result) => result; case Left(err) => return pathErr(err, 2) }
        val dC = cC.decode(eC) match { case Right(result) => result; case Left(err) => return pathErr(err, 3) }
        val dD = cD.decode(eD) match { case Right(result) => result; case Left(err) => return pathErr(err, 4) }
        val dE = cE.decode(eE) match { case Right(result) => result; case Left(err) => return pathErr(err, 5) }
        val dF = cF.decode(eF) match { case Right(result) => result; case Left(err) => return pathErr(err, 6) }
        val dG = cG.decode(eG) match { case Right(result) => result; case Left(err) => return pathErr(err, 7) }
        val dH = cH.decode(eH) match { case Right(result) => result; case Left(err) => return pathErr(err, 8) }
        val dI = cI.decode(eI) match { case Right(result) => result; case Left(err) => return pathErr(err, 9) }
        val dJ = cJ.decode(eJ) match { case Right(result) => result; case Left(err) => return pathErr(err, 10) }
        val dK = cK.decode(eK) match { case Right(result) => result; case Left(err) => return pathErr(err, 11) }
        val dL = cL.decode(eL) match { case Right(result) => result; case Left(err) => return pathErr(err, 12) }
        val dM = cM.decode(eM) match { case Right(result) => result; case Left(err) => return pathErr(err, 13) }
        val dN = cN.decode(eN) match { case Right(result) => result; case Left(err) => return pathErr(err, 14) }
        val dO = cO.decode(eO) match { case Right(result) => result; case Left(err) => return pathErr(err, 15) }
        val dP = cP.decode(eP) match { case Right(result) => result; case Left(err) => return pathErr(err, 16) }
        val dQ = cQ.decode(eQ) match { case Right(result) => result; case Left(err) => return pathErr(err, 17) }
        val dR = cR.decode(eR) match { case Right(result) => result; case Left(err) => return pathErr(err, 18) }
        val dS = cS.decode(eS) match { case Right(result) => result; case Left(err) => return pathErr(err, 19) }
        Right((dA,dB,dC,dD,dE,dF,dG,dH,dI,dJ,dK,dL,dM,dN,dO,dP,dQ,dR,dS))
      case arr: JArray =>
        Left(DecodeError.InvalidLength(expected = 19, got = arr.length))
      case other =>
        Left(DecodeError.InvalidType(expected = JArray, got = other.jsonType))
    }
  }
  implicit def tuple20Decode[A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T]( implicit cA: JsonDecode[A],cB: JsonDecode[B],cC: JsonDecode[C],cD: JsonDecode[D],cE: JsonDecode[E],cF: JsonDecode[F],cG: JsonDecode[G],cH: JsonDecode[H],cI: JsonDecode[I],cJ: JsonDecode[J],cK: JsonDecode[K],cL: JsonDecode[L],cM: JsonDecode[M],cN: JsonDecode[N],cO: JsonDecode[O],cP: JsonDecode[P],cQ: JsonDecode[Q],cR: JsonDecode[R],cS: JsonDecode[S],cT: JsonDecode[T]) = new JsonDecode[(A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T)] {
    private def pathErr(err: DecodeError, n: Int) = Left(err.prefix(n - 1))
    def decode(jvalue: JValue): DecodeResult[(A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T)] = jvalue match {
      case JArray(Seq(eA,eB,eC,eD,eE,eF,eG,eH,eI,eJ,eK,eL,eM,eN,eO,eP,eQ,eR,eS,eT)) =>
        val dA = cA.decode(eA) match { case Right(result) => result; case Left(err) => return pathErr(err, 1) }
        val dB = cB.decode(eB) match { case Right(result) => result; case Left(err) => return pathErr(err, 2) }
        val dC = cC.decode(eC) match { case Right(result) => result; case Left(err) => return pathErr(err, 3) }
        val dD = cD.decode(eD) match { case Right(result) => result; case Left(err) => return pathErr(err, 4) }
        val dE = cE.decode(eE) match { case Right(result) => result; case Left(err) => return pathErr(err, 5) }
        val dF = cF.decode(eF) match { case Right(result) => result; case Left(err) => return pathErr(err, 6) }
        val dG = cG.decode(eG) match { case Right(result) => result; case Left(err) => return pathErr(err, 7) }
        val dH = cH.decode(eH) match { case Right(result) => result; case Left(err) => return pathErr(err, 8) }
        val dI = cI.decode(eI) match { case Right(result) => result; case Left(err) => return pathErr(err, 9) }
        val dJ = cJ.decode(eJ) match { case Right(result) => result; case Left(err) => return pathErr(err, 10) }
        val dK = cK.decode(eK) match { case Right(result) => result; case Left(err) => return pathErr(err, 11) }
        val dL = cL.decode(eL) match { case Right(result) => result; case Left(err) => return pathErr(err, 12) }
        val dM = cM.decode(eM) match { case Right(result) => result; case Left(err) => return pathErr(err, 13) }
        val dN = cN.decode(eN) match { case Right(result) => result; case Left(err) => return pathErr(err, 14) }
        val dO = cO.decode(eO) match { case Right(result) => result; case Left(err) => return pathErr(err, 15) }
        val dP = cP.decode(eP) match { case Right(result) => result; case Left(err) => return pathErr(err, 16) }
        val dQ = cQ.decode(eQ) match { case Right(result) => result; case Left(err) => return pathErr(err, 17) }
        val dR = cR.decode(eR) match { case Right(result) => result; case Left(err) => return pathErr(err, 18) }
        val dS = cS.decode(eS) match { case Right(result) => result; case Left(err) => return pathErr(err, 19) }
        val dT = cT.decode(eT) match { case Right(result) => result; case Left(err) => return pathErr(err, 20) }
        Right((dA,dB,dC,dD,dE,dF,dG,dH,dI,dJ,dK,dL,dM,dN,dO,dP,dQ,dR,dS,dT))
      case arr: JArray =>
        Left(DecodeError.InvalidLength(expected = 20, got = arr.length))
      case other =>
        Left(DecodeError.InvalidType(expected = JArray, got = other.jsonType))
    }
  }
  implicit def tuple21Decode[A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U]( implicit cA: JsonDecode[A],cB: JsonDecode[B],cC: JsonDecode[C],cD: JsonDecode[D],cE: JsonDecode[E],cF: JsonDecode[F],cG: JsonDecode[G],cH: JsonDecode[H],cI: JsonDecode[I],cJ: JsonDecode[J],cK: JsonDecode[K],cL: JsonDecode[L],cM: JsonDecode[M],cN: JsonDecode[N],cO: JsonDecode[O],cP: JsonDecode[P],cQ: JsonDecode[Q],cR: JsonDecode[R],cS: JsonDecode[S],cT: JsonDecode[T],cU: JsonDecode[U]) = new JsonDecode[(A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U)] {
    private def pathErr(err: DecodeError, n: Int) = Left(err.prefix(n - 1))
    def decode(jvalue: JValue): DecodeResult[(A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U)] = jvalue match {
      case JArray(Seq(eA,eB,eC,eD,eE,eF,eG,eH,eI,eJ,eK,eL,eM,eN,eO,eP,eQ,eR,eS,eT,eU)) =>
        val dA = cA.decode(eA) match { case Right(result) => result; case Left(err) => return pathErr(err, 1) }
        val dB = cB.decode(eB) match { case Right(result) => result; case Left(err) => return pathErr(err, 2) }
        val dC = cC.decode(eC) match { case Right(result) => result; case Left(err) => return pathErr(err, 3) }
        val dD = cD.decode(eD) match { case Right(result) => result; case Left(err) => return pathErr(err, 4) }
        val dE = cE.decode(eE) match { case Right(result) => result; case Left(err) => return pathErr(err, 5) }
        val dF = cF.decode(eF) match { case Right(result) => result; case Left(err) => return pathErr(err, 6) }
        val dG = cG.decode(eG) match { case Right(result) => result; case Left(err) => return pathErr(err, 7) }
        val dH = cH.decode(eH) match { case Right(result) => result; case Left(err) => return pathErr(err, 8) }
        val dI = cI.decode(eI) match { case Right(result) => result; case Left(err) => return pathErr(err, 9) }
        val dJ = cJ.decode(eJ) match { case Right(result) => result; case Left(err) => return pathErr(err, 10) }
        val dK = cK.decode(eK) match { case Right(result) => result; case Left(err) => return pathErr(err, 11) }
        val dL = cL.decode(eL) match { case Right(result) => result; case Left(err) => return pathErr(err, 12) }
        val dM = cM.decode(eM) match { case Right(result) => result; case Left(err) => return pathErr(err, 13) }
        val dN = cN.decode(eN) match { case Right(result) => result; case Left(err) => return pathErr(err, 14) }
        val dO = cO.decode(eO) match { case Right(result) => result; case Left(err) => return pathErr(err, 15) }
        val dP = cP.decode(eP) match { case Right(result) => result; case Left(err) => return pathErr(err, 16) }
        val dQ = cQ.decode(eQ) match { case Right(result) => result; case Left(err) => return pathErr(err, 17) }
        val dR = cR.decode(eR) match { case Right(result) => result; case Left(err) => return pathErr(err, 18) }
        val dS = cS.decode(eS) match { case Right(result) => result; case Left(err) => return pathErr(err, 19) }
        val dT = cT.decode(eT) match { case Right(result) => result; case Left(err) => return pathErr(err, 20) }
        val dU = cU.decode(eU) match { case Right(result) => result; case Left(err) => return pathErr(err, 21) }
        Right((dA,dB,dC,dD,dE,dF,dG,dH,dI,dJ,dK,dL,dM,dN,dO,dP,dQ,dR,dS,dT,dU))
      case arr: JArray =>
        Left(DecodeError.InvalidLength(expected = 21, got = arr.length))
      case other =>
        Left(DecodeError.InvalidType(expected = JArray, got = other.jsonType))
    }
  }
  implicit def tuple22Decode[A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V]( implicit cA: JsonDecode[A],cB: JsonDecode[B],cC: JsonDecode[C],cD: JsonDecode[D],cE: JsonDecode[E],cF: JsonDecode[F],cG: JsonDecode[G],cH: JsonDecode[H],cI: JsonDecode[I],cJ: JsonDecode[J],cK: JsonDecode[K],cL: JsonDecode[L],cM: JsonDecode[M],cN: JsonDecode[N],cO: JsonDecode[O],cP: JsonDecode[P],cQ: JsonDecode[Q],cR: JsonDecode[R],cS: JsonDecode[S],cT: JsonDecode[T],cU: JsonDecode[U],cV: JsonDecode[V]) = new JsonDecode[(A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V)] {
    private def pathErr(err: DecodeError, n: Int) = Left(err.prefix(n - 1))
    def decode(jvalue: JValue): DecodeResult[(A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V)] = jvalue match {
      case JArray(Seq(eA,eB,eC,eD,eE,eF,eG,eH,eI,eJ,eK,eL,eM,eN,eO,eP,eQ,eR,eS,eT,eU,eV)) =>
        val dA = cA.decode(eA) match { case Right(result) => result; case Left(err) => return pathErr(err, 1) }
        val dB = cB.decode(eB) match { case Right(result) => result; case Left(err) => return pathErr(err, 2) }
        val dC = cC.decode(eC) match { case Right(result) => result; case Left(err) => return pathErr(err, 3) }
        val dD = cD.decode(eD) match { case Right(result) => result; case Left(err) => return pathErr(err, 4) }
        val dE = cE.decode(eE) match { case Right(result) => result; case Left(err) => return pathErr(err, 5) }
        val dF = cF.decode(eF) match { case Right(result) => result; case Left(err) => return pathErr(err, 6) }
        val dG = cG.decode(eG) match { case Right(result) => result; case Left(err) => return pathErr(err, 7) }
        val dH = cH.decode(eH) match { case Right(result) => result; case Left(err) => return pathErr(err, 8) }
        val dI = cI.decode(eI) match { case Right(result) => result; case Left(err) => return pathErr(err, 9) }
        val dJ = cJ.decode(eJ) match { case Right(result) => result; case Left(err) => return pathErr(err, 10) }
        val dK = cK.decode(eK) match { case Right(result) => result; case Left(err) => return pathErr(err, 11) }
        val dL = cL.decode(eL) match { case Right(result) => result; case Left(err) => return pathErr(err, 12) }
        val dM = cM.decode(eM) match { case Right(result) => result; case Left(err) => return pathErr(err, 13) }
        val dN = cN.decode(eN) match { case Right(result) => result; case Left(err) => return pathErr(err, 14) }
        val dO = cO.decode(eO) match { case Right(result) => result; case Left(err) => return pathErr(err, 15) }
        val dP = cP.decode(eP) match { case Right(result) => result; case Left(err) => return pathErr(err, 16) }
        val dQ = cQ.decode(eQ) match { case Right(result) => result; case Left(err) => return pathErr(err, 17) }
        val dR = cR.decode(eR) match { case Right(result) => result; case Left(err) => return pathErr(err, 18) }
        val dS = cS.decode(eS) match { case Right(result) => result; case Left(err) => return pathErr(err, 19) }
        val dT = cT.decode(eT) match { case Right(result) => result; case Left(err) => return pathErr(err, 20) }
        val dU = cU.decode(eU) match { case Right(result) => result; case Left(err) => return pathErr(err, 21) }
        val dV = cV.decode(eV) match { case Right(result) => result; case Left(err) => return pathErr(err, 22) }
        Right((dA,dB,dC,dD,dE,dF,dG,dH,dI,dJ,dK,dL,dM,dN,dO,dP,dQ,dR,dS,dT,dU,dV))
      case arr: JArray =>
        Left(DecodeError.InvalidLength(expected = 22, got = arr.length))
      case other =>
        Left(DecodeError.InvalidType(expected = JArray, got = other.jsonType))
    }
  }
}
