package com.rojoma.json.v3
package util

import scala.reflect.ClassTag

import ast._
import codec._
import matcher._

import `-impl`.util._

object SimpleJsonCodecBuilder {
  private def t[A](implicit m: ClassTag[A]): Class[_] = m.runtimeClass

  private def findCtor(baseClass: Class[_])(fieldClasses: Class[_]*) = {
    baseClass.getConstructor(fieldClasses : _*)
  }

  // the horror, the horror
  private def extract[A](implicit jcooA: JsonCodecOrOption[A]) = jcooA match {
    case jc@JsonCodecVersion(enc, dec) =>
      val varA = Variable[jc.RealType]()(dec, enc)
      val assignA = (varA := _).asInstanceOf[Any => Pattern.Results => Pattern.Results]
      val retrieveA = varA(_: Pattern.Results).asInstanceOf[AnyRef]
      (assignA, retrieveA, varA)
    case o@OptionVersion(enc, dec) =>
      val varA = Variable[o.RealType]()(dec, enc)
      val assignA = (varA :=? _).asInstanceOf[Any => Pattern.Results => Pattern.Results]
      val retrieveA = varA.get(_: Pattern.Results).asInstanceOf[AnyRef]
      (assignA, retrieveA, POption(varA).orNull)
  }

  class FixedSimpleJsonCodecBuilder[TT: ClassTag] {
def build[A: JsonCodecOrOption: ClassTag](fA: String, aA: TT => A): JsonEncode[TT] with JsonDecode[TT] = {
  val ctor = findCtor(t[TT])(t[A])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val pattern = PObject(fA -> patTargetA)
  new JsonEncode[TT] with JsonDecode[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)))
    def decode(x: JValue): Either[DecodeError, TT] =
      pattern.matches(x) match {
        case Right(results) =>
          val params = Array(retrieveA(results))
          try {
            Right(ctor.newInstance(params: _*).asInstanceOf[TT])
          } catch {
            case e: java.lang.reflect.InvocationTargetException => throw e.getCause
          }
        case Left(err) =>
          Left(err)
      }
  }
}
def build[A: JsonCodecOrOption: ClassTag, B: JsonCodecOrOption: ClassTag](fA: String, aA: TT => A, fB: String, aB: TT => B): JsonEncode[TT] with JsonDecode[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB)
  new JsonEncode[TT] with JsonDecode[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)))
    def decode(x: JValue): Either[DecodeError, TT] =
      pattern.matches(x) match {
        case Right(results) =>
          val params = Array(retrieveA(results), retrieveB(results))
          try {
            Right(ctor.newInstance(params: _*).asInstanceOf[TT])
          } catch {
            case e: java.lang.reflect.InvocationTargetException => throw e.getCause
          }
        case Left(err) =>
          Left(err)
      }
  }
}
def build[A: JsonCodecOrOption: ClassTag, B: JsonCodecOrOption: ClassTag, C: JsonCodecOrOption: ClassTag](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C): JsonEncode[TT] with JsonDecode[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC)
  new JsonEncode[TT] with JsonDecode[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)))
    def decode(x: JValue): Either[DecodeError, TT] =
      pattern.matches(x) match {
        case Right(results) =>
          val params = Array(retrieveA(results), retrieveB(results), retrieveC(results))
          try {
            Right(ctor.newInstance(params: _*).asInstanceOf[TT])
          } catch {
            case e: java.lang.reflect.InvocationTargetException => throw e.getCause
          }
        case Left(err) =>
          Left(err)
      }
  }
}
def build[A: JsonCodecOrOption: ClassTag, B: JsonCodecOrOption: ClassTag, C: JsonCodecOrOption: ClassTag, D: JsonCodecOrOption: ClassTag](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D): JsonEncode[TT] with JsonDecode[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD)
  new JsonEncode[TT] with JsonDecode[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)))
    def decode(x: JValue): Either[DecodeError, TT] =
      pattern.matches(x) match {
        case Right(results) =>
          val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results))
          try {
            Right(ctor.newInstance(params: _*).asInstanceOf[TT])
          } catch {
            case e: java.lang.reflect.InvocationTargetException => throw e.getCause
          }
        case Left(err) =>
          Left(err)
      }
  }
}
def build[A: JsonCodecOrOption: ClassTag, B: JsonCodecOrOption: ClassTag, C: JsonCodecOrOption: ClassTag, D: JsonCodecOrOption: ClassTag, E: JsonCodecOrOption: ClassTag](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E): JsonEncode[TT] with JsonDecode[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE)
  new JsonEncode[TT] with JsonDecode[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)))
    def decode(x: JValue): Either[DecodeError, TT] =
      pattern.matches(x) match {
        case Right(results) =>
          val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results))
          try {
            Right(ctor.newInstance(params: _*).asInstanceOf[TT])
          } catch {
            case e: java.lang.reflect.InvocationTargetException => throw e.getCause
          }
        case Left(err) =>
          Left(err)
      }
  }
}
def build[A: JsonCodecOrOption: ClassTag, B: JsonCodecOrOption: ClassTag, C: JsonCodecOrOption: ClassTag, D: JsonCodecOrOption: ClassTag, E: JsonCodecOrOption: ClassTag, F: JsonCodecOrOption: ClassTag](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F): JsonEncode[TT] with JsonDecode[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF)
  new JsonEncode[TT] with JsonDecode[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)))
    def decode(x: JValue): Either[DecodeError, TT] =
      pattern.matches(x) match {
        case Right(results) =>
          val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results))
          try {
            Right(ctor.newInstance(params: _*).asInstanceOf[TT])
          } catch {
            case e: java.lang.reflect.InvocationTargetException => throw e.getCause
          }
        case Left(err) =>
          Left(err)
      }
  }
}
def build[A: JsonCodecOrOption: ClassTag, B: JsonCodecOrOption: ClassTag, C: JsonCodecOrOption: ClassTag, D: JsonCodecOrOption: ClassTag, E: JsonCodecOrOption: ClassTag, F: JsonCodecOrOption: ClassTag, G: JsonCodecOrOption: ClassTag](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G): JsonEncode[TT] with JsonDecode[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG)
  new JsonEncode[TT] with JsonDecode[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)))
    def decode(x: JValue): Either[DecodeError, TT] =
      pattern.matches(x) match {
        case Right(results) =>
          val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results))
          try {
            Right(ctor.newInstance(params: _*).asInstanceOf[TT])
          } catch {
            case e: java.lang.reflect.InvocationTargetException => throw e.getCause
          }
        case Left(err) =>
          Left(err)
      }
  }
}
def build[A: JsonCodecOrOption: ClassTag, B: JsonCodecOrOption: ClassTag, C: JsonCodecOrOption: ClassTag, D: JsonCodecOrOption: ClassTag, E: JsonCodecOrOption: ClassTag, F: JsonCodecOrOption: ClassTag, G: JsonCodecOrOption: ClassTag, H: JsonCodecOrOption: ClassTag](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H): JsonEncode[TT] with JsonDecode[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH)
  new JsonEncode[TT] with JsonDecode[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)))
    def decode(x: JValue): Either[DecodeError, TT] =
      pattern.matches(x) match {
        case Right(results) =>
          val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results))
          try {
            Right(ctor.newInstance(params: _*).asInstanceOf[TT])
          } catch {
            case e: java.lang.reflect.InvocationTargetException => throw e.getCause
          }
        case Left(err) =>
          Left(err)
      }
  }
}
def build[A: JsonCodecOrOption: ClassTag, B: JsonCodecOrOption: ClassTag, C: JsonCodecOrOption: ClassTag, D: JsonCodecOrOption: ClassTag, E: JsonCodecOrOption: ClassTag, F: JsonCodecOrOption: ClassTag, G: JsonCodecOrOption: ClassTag, H: JsonCodecOrOption: ClassTag, I: JsonCodecOrOption: ClassTag](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H, fI: String, aI: TT => I): JsonEncode[TT] with JsonDecode[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H], t[I])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val (assignI, retrieveI, patTargetI) = extract[I]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH, fI -> patTargetI)
  new JsonEncode[TT] with JsonDecode[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)), assignI(aI(x)))
    def decode(x: JValue): Either[DecodeError, TT] =
      pattern.matches(x) match {
        case Right(results) =>
          val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results), retrieveI(results))
          try {
            Right(ctor.newInstance(params: _*).asInstanceOf[TT])
          } catch {
            case e: java.lang.reflect.InvocationTargetException => throw e.getCause
          }
        case Left(err) =>
          Left(err)
      }
  }
}
def build[A: JsonCodecOrOption: ClassTag, B: JsonCodecOrOption: ClassTag, C: JsonCodecOrOption: ClassTag, D: JsonCodecOrOption: ClassTag, E: JsonCodecOrOption: ClassTag, F: JsonCodecOrOption: ClassTag, G: JsonCodecOrOption: ClassTag, H: JsonCodecOrOption: ClassTag, I: JsonCodecOrOption: ClassTag, J: JsonCodecOrOption: ClassTag](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H, fI: String, aI: TT => I, fJ: String, aJ: TT => J): JsonEncode[TT] with JsonDecode[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H], t[I], t[J])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val (assignI, retrieveI, patTargetI) = extract[I]
  val (assignJ, retrieveJ, patTargetJ) = extract[J]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH, fI -> patTargetI, fJ -> patTargetJ)
  new JsonEncode[TT] with JsonDecode[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)), assignI(aI(x)), assignJ(aJ(x)))
    def decode(x: JValue): Either[DecodeError, TT] =
      pattern.matches(x) match {
        case Right(results) =>
          val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results), retrieveI(results), retrieveJ(results))
          try {
            Right(ctor.newInstance(params: _*).asInstanceOf[TT])
          } catch {
            case e: java.lang.reflect.InvocationTargetException => throw e.getCause
          }
        case Left(err) =>
          Left(err)
      }
  }
}
def build[A: JsonCodecOrOption: ClassTag, B: JsonCodecOrOption: ClassTag, C: JsonCodecOrOption: ClassTag, D: JsonCodecOrOption: ClassTag, E: JsonCodecOrOption: ClassTag, F: JsonCodecOrOption: ClassTag, G: JsonCodecOrOption: ClassTag, H: JsonCodecOrOption: ClassTag, I: JsonCodecOrOption: ClassTag, J: JsonCodecOrOption: ClassTag, K: JsonCodecOrOption: ClassTag](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H, fI: String, aI: TT => I, fJ: String, aJ: TT => J, fK: String, aK: TT => K): JsonEncode[TT] with JsonDecode[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H], t[I], t[J], t[K])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val (assignI, retrieveI, patTargetI) = extract[I]
  val (assignJ, retrieveJ, patTargetJ) = extract[J]
  val (assignK, retrieveK, patTargetK) = extract[K]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH, fI -> patTargetI, fJ -> patTargetJ, fK -> patTargetK)
  new JsonEncode[TT] with JsonDecode[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)), assignI(aI(x)), assignJ(aJ(x)), assignK(aK(x)))
    def decode(x: JValue): Either[DecodeError, TT] =
      pattern.matches(x) match {
        case Right(results) =>
          val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results), retrieveI(results), retrieveJ(results), retrieveK(results))
          try {
            Right(ctor.newInstance(params: _*).asInstanceOf[TT])
          } catch {
            case e: java.lang.reflect.InvocationTargetException => throw e.getCause
          }
        case Left(err) =>
          Left(err)
      }
  }
}
def build[A: JsonCodecOrOption: ClassTag, B: JsonCodecOrOption: ClassTag, C: JsonCodecOrOption: ClassTag, D: JsonCodecOrOption: ClassTag, E: JsonCodecOrOption: ClassTag, F: JsonCodecOrOption: ClassTag, G: JsonCodecOrOption: ClassTag, H: JsonCodecOrOption: ClassTag, I: JsonCodecOrOption: ClassTag, J: JsonCodecOrOption: ClassTag, K: JsonCodecOrOption: ClassTag, L: JsonCodecOrOption: ClassTag](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H, fI: String, aI: TT => I, fJ: String, aJ: TT => J, fK: String, aK: TT => K, fL: String, aL: TT => L): JsonEncode[TT] with JsonDecode[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H], t[I], t[J], t[K], t[L])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val (assignI, retrieveI, patTargetI) = extract[I]
  val (assignJ, retrieveJ, patTargetJ) = extract[J]
  val (assignK, retrieveK, patTargetK) = extract[K]
  val (assignL, retrieveL, patTargetL) = extract[L]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH, fI -> patTargetI, fJ -> patTargetJ, fK -> patTargetK, fL -> patTargetL)
  new JsonEncode[TT] with JsonDecode[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)), assignI(aI(x)), assignJ(aJ(x)), assignK(aK(x)), assignL(aL(x)))
    def decode(x: JValue): Either[DecodeError, TT] =
      pattern.matches(x) match {
        case Right(results) =>
          val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results), retrieveI(results), retrieveJ(results), retrieveK(results), retrieveL(results))
          try {
            Right(ctor.newInstance(params: _*).asInstanceOf[TT])
          } catch {
            case e: java.lang.reflect.InvocationTargetException => throw e.getCause
          }
        case Left(err) =>
          Left(err)
      }
  }
}
def build[A: JsonCodecOrOption: ClassTag, B: JsonCodecOrOption: ClassTag, C: JsonCodecOrOption: ClassTag, D: JsonCodecOrOption: ClassTag, E: JsonCodecOrOption: ClassTag, F: JsonCodecOrOption: ClassTag, G: JsonCodecOrOption: ClassTag, H: JsonCodecOrOption: ClassTag, I: JsonCodecOrOption: ClassTag, J: JsonCodecOrOption: ClassTag, K: JsonCodecOrOption: ClassTag, L: JsonCodecOrOption: ClassTag, M: JsonCodecOrOption: ClassTag](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H, fI: String, aI: TT => I, fJ: String, aJ: TT => J, fK: String, aK: TT => K, fL: String, aL: TT => L, fM: String, aM: TT => M): JsonEncode[TT] with JsonDecode[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H], t[I], t[J], t[K], t[L], t[M])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val (assignI, retrieveI, patTargetI) = extract[I]
  val (assignJ, retrieveJ, patTargetJ) = extract[J]
  val (assignK, retrieveK, patTargetK) = extract[K]
  val (assignL, retrieveL, patTargetL) = extract[L]
  val (assignM, retrieveM, patTargetM) = extract[M]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH, fI -> patTargetI, fJ -> patTargetJ, fK -> patTargetK, fL -> patTargetL, fM -> patTargetM)
  new JsonEncode[TT] with JsonDecode[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)), assignI(aI(x)), assignJ(aJ(x)), assignK(aK(x)), assignL(aL(x)), assignM(aM(x)))
    def decode(x: JValue): Either[DecodeError, TT] =
      pattern.matches(x) match {
        case Right(results) =>
          val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results), retrieveI(results), retrieveJ(results), retrieveK(results), retrieveL(results), retrieveM(results))
          try {
            Right(ctor.newInstance(params: _*).asInstanceOf[TT])
          } catch {
            case e: java.lang.reflect.InvocationTargetException => throw e.getCause
          }
        case Left(err) =>
          Left(err)
      }
  }
}
def build[A: JsonCodecOrOption: ClassTag, B: JsonCodecOrOption: ClassTag, C: JsonCodecOrOption: ClassTag, D: JsonCodecOrOption: ClassTag, E: JsonCodecOrOption: ClassTag, F: JsonCodecOrOption: ClassTag, G: JsonCodecOrOption: ClassTag, H: JsonCodecOrOption: ClassTag, I: JsonCodecOrOption: ClassTag, J: JsonCodecOrOption: ClassTag, K: JsonCodecOrOption: ClassTag, L: JsonCodecOrOption: ClassTag, M: JsonCodecOrOption: ClassTag, N: JsonCodecOrOption: ClassTag](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H, fI: String, aI: TT => I, fJ: String, aJ: TT => J, fK: String, aK: TT => K, fL: String, aL: TT => L, fM: String, aM: TT => M, fN: String, aN: TT => N): JsonEncode[TT] with JsonDecode[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H], t[I], t[J], t[K], t[L], t[M], t[N])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val (assignI, retrieveI, patTargetI) = extract[I]
  val (assignJ, retrieveJ, patTargetJ) = extract[J]
  val (assignK, retrieveK, patTargetK) = extract[K]
  val (assignL, retrieveL, patTargetL) = extract[L]
  val (assignM, retrieveM, patTargetM) = extract[M]
  val (assignN, retrieveN, patTargetN) = extract[N]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH, fI -> patTargetI, fJ -> patTargetJ, fK -> patTargetK, fL -> patTargetL, fM -> patTargetM, fN -> patTargetN)
  new JsonEncode[TT] with JsonDecode[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)), assignI(aI(x)), assignJ(aJ(x)), assignK(aK(x)), assignL(aL(x)), assignM(aM(x)), assignN(aN(x)))
    def decode(x: JValue): Either[DecodeError, TT] =
      pattern.matches(x) match {
        case Right(results) =>
          val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results), retrieveI(results), retrieveJ(results), retrieveK(results), retrieveL(results), retrieveM(results), retrieveN(results))
          try {
            Right(ctor.newInstance(params: _*).asInstanceOf[TT])
          } catch {
            case e: java.lang.reflect.InvocationTargetException => throw e.getCause
          }
        case Left(err) =>
          Left(err)
      }
  }
}
def build[A: JsonCodecOrOption: ClassTag, B: JsonCodecOrOption: ClassTag, C: JsonCodecOrOption: ClassTag, D: JsonCodecOrOption: ClassTag, E: JsonCodecOrOption: ClassTag, F: JsonCodecOrOption: ClassTag, G: JsonCodecOrOption: ClassTag, H: JsonCodecOrOption: ClassTag, I: JsonCodecOrOption: ClassTag, J: JsonCodecOrOption: ClassTag, K: JsonCodecOrOption: ClassTag, L: JsonCodecOrOption: ClassTag, M: JsonCodecOrOption: ClassTag, N: JsonCodecOrOption: ClassTag, O: JsonCodecOrOption: ClassTag](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H, fI: String, aI: TT => I, fJ: String, aJ: TT => J, fK: String, aK: TT => K, fL: String, aL: TT => L, fM: String, aM: TT => M, fN: String, aN: TT => N, fO: String, aO: TT => O): JsonEncode[TT] with JsonDecode[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H], t[I], t[J], t[K], t[L], t[M], t[N], t[O])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val (assignI, retrieveI, patTargetI) = extract[I]
  val (assignJ, retrieveJ, patTargetJ) = extract[J]
  val (assignK, retrieveK, patTargetK) = extract[K]
  val (assignL, retrieveL, patTargetL) = extract[L]
  val (assignM, retrieveM, patTargetM) = extract[M]
  val (assignN, retrieveN, patTargetN) = extract[N]
  val (assignO, retrieveO, patTargetO) = extract[O]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH, fI -> patTargetI, fJ -> patTargetJ, fK -> patTargetK, fL -> patTargetL, fM -> patTargetM, fN -> patTargetN, fO -> patTargetO)
  new JsonEncode[TT] with JsonDecode[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)), assignI(aI(x)), assignJ(aJ(x)), assignK(aK(x)), assignL(aL(x)), assignM(aM(x)), assignN(aN(x)), assignO(aO(x)))
    def decode(x: JValue): Either[DecodeError, TT] =
      pattern.matches(x) match {
        case Right(results) =>
          val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results), retrieveI(results), retrieveJ(results), retrieveK(results), retrieveL(results), retrieveM(results), retrieveN(results), retrieveO(results))
          try {
            Right(ctor.newInstance(params: _*).asInstanceOf[TT])
          } catch {
            case e: java.lang.reflect.InvocationTargetException => throw e.getCause
          }
        case Left(err) =>
          Left(err)
      }
  }
}
def build[A: JsonCodecOrOption: ClassTag, B: JsonCodecOrOption: ClassTag, C: JsonCodecOrOption: ClassTag, D: JsonCodecOrOption: ClassTag, E: JsonCodecOrOption: ClassTag, F: JsonCodecOrOption: ClassTag, G: JsonCodecOrOption: ClassTag, H: JsonCodecOrOption: ClassTag, I: JsonCodecOrOption: ClassTag, J: JsonCodecOrOption: ClassTag, K: JsonCodecOrOption: ClassTag, L: JsonCodecOrOption: ClassTag, M: JsonCodecOrOption: ClassTag, N: JsonCodecOrOption: ClassTag, O: JsonCodecOrOption: ClassTag, P: JsonCodecOrOption: ClassTag](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H, fI: String, aI: TT => I, fJ: String, aJ: TT => J, fK: String, aK: TT => K, fL: String, aL: TT => L, fM: String, aM: TT => M, fN: String, aN: TT => N, fO: String, aO: TT => O, fP: String, aP: TT => P): JsonEncode[TT] with JsonDecode[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H], t[I], t[J], t[K], t[L], t[M], t[N], t[O], t[P])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val (assignI, retrieveI, patTargetI) = extract[I]
  val (assignJ, retrieveJ, patTargetJ) = extract[J]
  val (assignK, retrieveK, patTargetK) = extract[K]
  val (assignL, retrieveL, patTargetL) = extract[L]
  val (assignM, retrieveM, patTargetM) = extract[M]
  val (assignN, retrieveN, patTargetN) = extract[N]
  val (assignO, retrieveO, patTargetO) = extract[O]
  val (assignP, retrieveP, patTargetP) = extract[P]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH, fI -> patTargetI, fJ -> patTargetJ, fK -> patTargetK, fL -> patTargetL, fM -> patTargetM, fN -> patTargetN, fO -> patTargetO, fP -> patTargetP)
  new JsonEncode[TT] with JsonDecode[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)), assignI(aI(x)), assignJ(aJ(x)), assignK(aK(x)), assignL(aL(x)), assignM(aM(x)), assignN(aN(x)), assignO(aO(x)), assignP(aP(x)))
    def decode(x: JValue): Either[DecodeError, TT] =
      pattern.matches(x) match {
        case Right(results) =>
          val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results), retrieveI(results), retrieveJ(results), retrieveK(results), retrieveL(results), retrieveM(results), retrieveN(results), retrieveO(results), retrieveP(results))
          try {
            Right(ctor.newInstance(params: _*).asInstanceOf[TT])
          } catch {
            case e: java.lang.reflect.InvocationTargetException => throw e.getCause
          }
        case Left(err) =>
          Left(err)
      }
  }
}
def build[A: JsonCodecOrOption: ClassTag, B: JsonCodecOrOption: ClassTag, C: JsonCodecOrOption: ClassTag, D: JsonCodecOrOption: ClassTag, E: JsonCodecOrOption: ClassTag, F: JsonCodecOrOption: ClassTag, G: JsonCodecOrOption: ClassTag, H: JsonCodecOrOption: ClassTag, I: JsonCodecOrOption: ClassTag, J: JsonCodecOrOption: ClassTag, K: JsonCodecOrOption: ClassTag, L: JsonCodecOrOption: ClassTag, M: JsonCodecOrOption: ClassTag, N: JsonCodecOrOption: ClassTag, O: JsonCodecOrOption: ClassTag, P: JsonCodecOrOption: ClassTag, Q: JsonCodecOrOption: ClassTag](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H, fI: String, aI: TT => I, fJ: String, aJ: TT => J, fK: String, aK: TT => K, fL: String, aL: TT => L, fM: String, aM: TT => M, fN: String, aN: TT => N, fO: String, aO: TT => O, fP: String, aP: TT => P, fQ: String, aQ: TT => Q): JsonEncode[TT] with JsonDecode[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H], t[I], t[J], t[K], t[L], t[M], t[N], t[O], t[P], t[Q])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val (assignI, retrieveI, patTargetI) = extract[I]
  val (assignJ, retrieveJ, patTargetJ) = extract[J]
  val (assignK, retrieveK, patTargetK) = extract[K]
  val (assignL, retrieveL, patTargetL) = extract[L]
  val (assignM, retrieveM, patTargetM) = extract[M]
  val (assignN, retrieveN, patTargetN) = extract[N]
  val (assignO, retrieveO, patTargetO) = extract[O]
  val (assignP, retrieveP, patTargetP) = extract[P]
  val (assignQ, retrieveQ, patTargetQ) = extract[Q]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH, fI -> patTargetI, fJ -> patTargetJ, fK -> patTargetK, fL -> patTargetL, fM -> patTargetM, fN -> patTargetN, fO -> patTargetO, fP -> patTargetP, fQ -> patTargetQ)
  new JsonEncode[TT] with JsonDecode[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)), assignI(aI(x)), assignJ(aJ(x)), assignK(aK(x)), assignL(aL(x)), assignM(aM(x)), assignN(aN(x)), assignO(aO(x)), assignP(aP(x)), assignQ(aQ(x)))
    def decode(x: JValue): Either[DecodeError, TT] =
      pattern.matches(x) match {
        case Right(results) =>
          val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results), retrieveI(results), retrieveJ(results), retrieveK(results), retrieveL(results), retrieveM(results), retrieveN(results), retrieveO(results), retrieveP(results), retrieveQ(results))
          try {
            Right(ctor.newInstance(params: _*).asInstanceOf[TT])
          } catch {
            case e: java.lang.reflect.InvocationTargetException => throw e.getCause
          }
        case Left(err) =>
          Left(err)
      }
  }
}
def build[A: JsonCodecOrOption: ClassTag, B: JsonCodecOrOption: ClassTag, C: JsonCodecOrOption: ClassTag, D: JsonCodecOrOption: ClassTag, E: JsonCodecOrOption: ClassTag, F: JsonCodecOrOption: ClassTag, G: JsonCodecOrOption: ClassTag, H: JsonCodecOrOption: ClassTag, I: JsonCodecOrOption: ClassTag, J: JsonCodecOrOption: ClassTag, K: JsonCodecOrOption: ClassTag, L: JsonCodecOrOption: ClassTag, M: JsonCodecOrOption: ClassTag, N: JsonCodecOrOption: ClassTag, O: JsonCodecOrOption: ClassTag, P: JsonCodecOrOption: ClassTag, Q: JsonCodecOrOption: ClassTag, R: JsonCodecOrOption: ClassTag](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H, fI: String, aI: TT => I, fJ: String, aJ: TT => J, fK: String, aK: TT => K, fL: String, aL: TT => L, fM: String, aM: TT => M, fN: String, aN: TT => N, fO: String, aO: TT => O, fP: String, aP: TT => P, fQ: String, aQ: TT => Q, fR: String, aR: TT => R): JsonEncode[TT] with JsonDecode[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H], t[I], t[J], t[K], t[L], t[M], t[N], t[O], t[P], t[Q], t[R])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val (assignI, retrieveI, patTargetI) = extract[I]
  val (assignJ, retrieveJ, patTargetJ) = extract[J]
  val (assignK, retrieveK, patTargetK) = extract[K]
  val (assignL, retrieveL, patTargetL) = extract[L]
  val (assignM, retrieveM, patTargetM) = extract[M]
  val (assignN, retrieveN, patTargetN) = extract[N]
  val (assignO, retrieveO, patTargetO) = extract[O]
  val (assignP, retrieveP, patTargetP) = extract[P]
  val (assignQ, retrieveQ, patTargetQ) = extract[Q]
  val (assignR, retrieveR, patTargetR) = extract[R]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH, fI -> patTargetI, fJ -> patTargetJ, fK -> patTargetK, fL -> patTargetL, fM -> patTargetM, fN -> patTargetN, fO -> patTargetO, fP -> patTargetP, fQ -> patTargetQ, fR -> patTargetR)
  new JsonEncode[TT] with JsonDecode[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)), assignI(aI(x)), assignJ(aJ(x)), assignK(aK(x)), assignL(aL(x)), assignM(aM(x)), assignN(aN(x)), assignO(aO(x)), assignP(aP(x)), assignQ(aQ(x)), assignR(aR(x)))
    def decode(x: JValue): Either[DecodeError, TT] =
      pattern.matches(x) match {
        case Right(results) =>
          val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results), retrieveI(results), retrieveJ(results), retrieveK(results), retrieveL(results), retrieveM(results), retrieveN(results), retrieveO(results), retrieveP(results), retrieveQ(results), retrieveR(results))
          try {
            Right(ctor.newInstance(params: _*).asInstanceOf[TT])
          } catch {
            case e: java.lang.reflect.InvocationTargetException => throw e.getCause
          }
        case Left(err) =>
          Left(err)
      }
  }
}
def build[A: JsonCodecOrOption: ClassTag, B: JsonCodecOrOption: ClassTag, C: JsonCodecOrOption: ClassTag, D: JsonCodecOrOption: ClassTag, E: JsonCodecOrOption: ClassTag, F: JsonCodecOrOption: ClassTag, G: JsonCodecOrOption: ClassTag, H: JsonCodecOrOption: ClassTag, I: JsonCodecOrOption: ClassTag, J: JsonCodecOrOption: ClassTag, K: JsonCodecOrOption: ClassTag, L: JsonCodecOrOption: ClassTag, M: JsonCodecOrOption: ClassTag, N: JsonCodecOrOption: ClassTag, O: JsonCodecOrOption: ClassTag, P: JsonCodecOrOption: ClassTag, Q: JsonCodecOrOption: ClassTag, R: JsonCodecOrOption: ClassTag, S: JsonCodecOrOption: ClassTag](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H, fI: String, aI: TT => I, fJ: String, aJ: TT => J, fK: String, aK: TT => K, fL: String, aL: TT => L, fM: String, aM: TT => M, fN: String, aN: TT => N, fO: String, aO: TT => O, fP: String, aP: TT => P, fQ: String, aQ: TT => Q, fR: String, aR: TT => R, fS: String, aS: TT => S): JsonEncode[TT] with JsonDecode[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H], t[I], t[J], t[K], t[L], t[M], t[N], t[O], t[P], t[Q], t[R], t[S])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val (assignI, retrieveI, patTargetI) = extract[I]
  val (assignJ, retrieveJ, patTargetJ) = extract[J]
  val (assignK, retrieveK, patTargetK) = extract[K]
  val (assignL, retrieveL, patTargetL) = extract[L]
  val (assignM, retrieveM, patTargetM) = extract[M]
  val (assignN, retrieveN, patTargetN) = extract[N]
  val (assignO, retrieveO, patTargetO) = extract[O]
  val (assignP, retrieveP, patTargetP) = extract[P]
  val (assignQ, retrieveQ, patTargetQ) = extract[Q]
  val (assignR, retrieveR, patTargetR) = extract[R]
  val (assignS, retrieveS, patTargetS) = extract[S]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH, fI -> patTargetI, fJ -> patTargetJ, fK -> patTargetK, fL -> patTargetL, fM -> patTargetM, fN -> patTargetN, fO -> patTargetO, fP -> patTargetP, fQ -> patTargetQ, fR -> patTargetR, fS -> patTargetS)
  new JsonEncode[TT] with JsonDecode[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)), assignI(aI(x)), assignJ(aJ(x)), assignK(aK(x)), assignL(aL(x)), assignM(aM(x)), assignN(aN(x)), assignO(aO(x)), assignP(aP(x)), assignQ(aQ(x)), assignR(aR(x)), assignS(aS(x)))
    def decode(x: JValue): Either[DecodeError, TT] =
      pattern.matches(x) match {
        case Right(results) =>
          val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results), retrieveI(results), retrieveJ(results), retrieveK(results), retrieveL(results), retrieveM(results), retrieveN(results), retrieveO(results), retrieveP(results), retrieveQ(results), retrieveR(results), retrieveS(results))
          try {
            Right(ctor.newInstance(params: _*).asInstanceOf[TT])
          } catch {
            case e: java.lang.reflect.InvocationTargetException => throw e.getCause
          }
        case Left(err) =>
          Left(err)
      }
  }
}
def build[A: JsonCodecOrOption: ClassTag, B: JsonCodecOrOption: ClassTag, C: JsonCodecOrOption: ClassTag, D: JsonCodecOrOption: ClassTag, E: JsonCodecOrOption: ClassTag, F: JsonCodecOrOption: ClassTag, G: JsonCodecOrOption: ClassTag, H: JsonCodecOrOption: ClassTag, I: JsonCodecOrOption: ClassTag, J: JsonCodecOrOption: ClassTag, K: JsonCodecOrOption: ClassTag, L: JsonCodecOrOption: ClassTag, M: JsonCodecOrOption: ClassTag, N: JsonCodecOrOption: ClassTag, O: JsonCodecOrOption: ClassTag, P: JsonCodecOrOption: ClassTag, Q: JsonCodecOrOption: ClassTag, R: JsonCodecOrOption: ClassTag, S: JsonCodecOrOption: ClassTag, T: JsonCodecOrOption: ClassTag](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H, fI: String, aI: TT => I, fJ: String, aJ: TT => J, fK: String, aK: TT => K, fL: String, aL: TT => L, fM: String, aM: TT => M, fN: String, aN: TT => N, fO: String, aO: TT => O, fP: String, aP: TT => P, fQ: String, aQ: TT => Q, fR: String, aR: TT => R, fS: String, aS: TT => S, fT: String, aT: TT => T): JsonEncode[TT] with JsonDecode[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H], t[I], t[J], t[K], t[L], t[M], t[N], t[O], t[P], t[Q], t[R], t[S], t[T])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val (assignI, retrieveI, patTargetI) = extract[I]
  val (assignJ, retrieveJ, patTargetJ) = extract[J]
  val (assignK, retrieveK, patTargetK) = extract[K]
  val (assignL, retrieveL, patTargetL) = extract[L]
  val (assignM, retrieveM, patTargetM) = extract[M]
  val (assignN, retrieveN, patTargetN) = extract[N]
  val (assignO, retrieveO, patTargetO) = extract[O]
  val (assignP, retrieveP, patTargetP) = extract[P]
  val (assignQ, retrieveQ, patTargetQ) = extract[Q]
  val (assignR, retrieveR, patTargetR) = extract[R]
  val (assignS, retrieveS, patTargetS) = extract[S]
  val (assignT, retrieveT, patTargetT) = extract[T]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH, fI -> patTargetI, fJ -> patTargetJ, fK -> patTargetK, fL -> patTargetL, fM -> patTargetM, fN -> patTargetN, fO -> patTargetO, fP -> patTargetP, fQ -> patTargetQ, fR -> patTargetR, fS -> patTargetS, fT -> patTargetT)
  new JsonEncode[TT] with JsonDecode[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)), assignI(aI(x)), assignJ(aJ(x)), assignK(aK(x)), assignL(aL(x)), assignM(aM(x)), assignN(aN(x)), assignO(aO(x)), assignP(aP(x)), assignQ(aQ(x)), assignR(aR(x)), assignS(aS(x)), assignT(aT(x)))
    def decode(x: JValue): Either[DecodeError, TT] =
      pattern.matches(x) match {
        case Right(results) =>
          val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results), retrieveI(results), retrieveJ(results), retrieveK(results), retrieveL(results), retrieveM(results), retrieveN(results), retrieveO(results), retrieveP(results), retrieveQ(results), retrieveR(results), retrieveS(results), retrieveT(results))
          try {
            Right(ctor.newInstance(params: _*).asInstanceOf[TT])
          } catch {
            case e: java.lang.reflect.InvocationTargetException => throw e.getCause
          }
        case Left(err) =>
          Left(err)
      }
  }
}
def build[A: JsonCodecOrOption: ClassTag, B: JsonCodecOrOption: ClassTag, C: JsonCodecOrOption: ClassTag, D: JsonCodecOrOption: ClassTag, E: JsonCodecOrOption: ClassTag, F: JsonCodecOrOption: ClassTag, G: JsonCodecOrOption: ClassTag, H: JsonCodecOrOption: ClassTag, I: JsonCodecOrOption: ClassTag, J: JsonCodecOrOption: ClassTag, K: JsonCodecOrOption: ClassTag, L: JsonCodecOrOption: ClassTag, M: JsonCodecOrOption: ClassTag, N: JsonCodecOrOption: ClassTag, O: JsonCodecOrOption: ClassTag, P: JsonCodecOrOption: ClassTag, Q: JsonCodecOrOption: ClassTag, R: JsonCodecOrOption: ClassTag, S: JsonCodecOrOption: ClassTag, T: JsonCodecOrOption: ClassTag, U: JsonCodecOrOption: ClassTag](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H, fI: String, aI: TT => I, fJ: String, aJ: TT => J, fK: String, aK: TT => K, fL: String, aL: TT => L, fM: String, aM: TT => M, fN: String, aN: TT => N, fO: String, aO: TT => O, fP: String, aP: TT => P, fQ: String, aQ: TT => Q, fR: String, aR: TT => R, fS: String, aS: TT => S, fT: String, aT: TT => T, fU: String, aU: TT => U): JsonEncode[TT] with JsonDecode[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H], t[I], t[J], t[K], t[L], t[M], t[N], t[O], t[P], t[Q], t[R], t[S], t[T], t[U])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val (assignI, retrieveI, patTargetI) = extract[I]
  val (assignJ, retrieveJ, patTargetJ) = extract[J]
  val (assignK, retrieveK, patTargetK) = extract[K]
  val (assignL, retrieveL, patTargetL) = extract[L]
  val (assignM, retrieveM, patTargetM) = extract[M]
  val (assignN, retrieveN, patTargetN) = extract[N]
  val (assignO, retrieveO, patTargetO) = extract[O]
  val (assignP, retrieveP, patTargetP) = extract[P]
  val (assignQ, retrieveQ, patTargetQ) = extract[Q]
  val (assignR, retrieveR, patTargetR) = extract[R]
  val (assignS, retrieveS, patTargetS) = extract[S]
  val (assignT, retrieveT, patTargetT) = extract[T]
  val (assignU, retrieveU, patTargetU) = extract[U]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH, fI -> patTargetI, fJ -> patTargetJ, fK -> patTargetK, fL -> patTargetL, fM -> patTargetM, fN -> patTargetN, fO -> patTargetO, fP -> patTargetP, fQ -> patTargetQ, fR -> patTargetR, fS -> patTargetS, fT -> patTargetT, fU -> patTargetU)
  new JsonEncode[TT] with JsonDecode[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)), assignI(aI(x)), assignJ(aJ(x)), assignK(aK(x)), assignL(aL(x)), assignM(aM(x)), assignN(aN(x)), assignO(aO(x)), assignP(aP(x)), assignQ(aQ(x)), assignR(aR(x)), assignS(aS(x)), assignT(aT(x)), assignU(aU(x)))
    def decode(x: JValue): Either[DecodeError, TT] =
      pattern.matches(x) match {
        case Right(results) =>
          val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results), retrieveI(results), retrieveJ(results), retrieveK(results), retrieveL(results), retrieveM(results), retrieveN(results), retrieveO(results), retrieveP(results), retrieveQ(results), retrieveR(results), retrieveS(results), retrieveT(results), retrieveU(results))
          try {
            Right(ctor.newInstance(params: _*).asInstanceOf[TT])
          } catch {
            case e: java.lang.reflect.InvocationTargetException => throw e.getCause
          }
        case Left(err) =>
          Left(err)
      }
  }
}
def build[A: JsonCodecOrOption: ClassTag, B: JsonCodecOrOption: ClassTag, C: JsonCodecOrOption: ClassTag, D: JsonCodecOrOption: ClassTag, E: JsonCodecOrOption: ClassTag, F: JsonCodecOrOption: ClassTag, G: JsonCodecOrOption: ClassTag, H: JsonCodecOrOption: ClassTag, I: JsonCodecOrOption: ClassTag, J: JsonCodecOrOption: ClassTag, K: JsonCodecOrOption: ClassTag, L: JsonCodecOrOption: ClassTag, M: JsonCodecOrOption: ClassTag, N: JsonCodecOrOption: ClassTag, O: JsonCodecOrOption: ClassTag, P: JsonCodecOrOption: ClassTag, Q: JsonCodecOrOption: ClassTag, R: JsonCodecOrOption: ClassTag, S: JsonCodecOrOption: ClassTag, T: JsonCodecOrOption: ClassTag, U: JsonCodecOrOption: ClassTag, V: JsonCodecOrOption: ClassTag](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H, fI: String, aI: TT => I, fJ: String, aJ: TT => J, fK: String, aK: TT => K, fL: String, aL: TT => L, fM: String, aM: TT => M, fN: String, aN: TT => N, fO: String, aO: TT => O, fP: String, aP: TT => P, fQ: String, aQ: TT => Q, fR: String, aR: TT => R, fS: String, aS: TT => S, fT: String, aT: TT => T, fU: String, aU: TT => U, fV: String, aV: TT => V): JsonEncode[TT] with JsonDecode[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H], t[I], t[J], t[K], t[L], t[M], t[N], t[O], t[P], t[Q], t[R], t[S], t[T], t[U], t[V])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val (assignI, retrieveI, patTargetI) = extract[I]
  val (assignJ, retrieveJ, patTargetJ) = extract[J]
  val (assignK, retrieveK, patTargetK) = extract[K]
  val (assignL, retrieveL, patTargetL) = extract[L]
  val (assignM, retrieveM, patTargetM) = extract[M]
  val (assignN, retrieveN, patTargetN) = extract[N]
  val (assignO, retrieveO, patTargetO) = extract[O]
  val (assignP, retrieveP, patTargetP) = extract[P]
  val (assignQ, retrieveQ, patTargetQ) = extract[Q]
  val (assignR, retrieveR, patTargetR) = extract[R]
  val (assignS, retrieveS, patTargetS) = extract[S]
  val (assignT, retrieveT, patTargetT) = extract[T]
  val (assignU, retrieveU, patTargetU) = extract[U]
  val (assignV, retrieveV, patTargetV) = extract[V]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH, fI -> patTargetI, fJ -> patTargetJ, fK -> patTargetK, fL -> patTargetL, fM -> patTargetM, fN -> patTargetN, fO -> patTargetO, fP -> patTargetP, fQ -> patTargetQ, fR -> patTargetR, fS -> patTargetS, fT -> patTargetT, fU -> patTargetU, fV -> patTargetV)
  new JsonEncode[TT] with JsonDecode[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)), assignI(aI(x)), assignJ(aJ(x)), assignK(aK(x)), assignL(aL(x)), assignM(aM(x)), assignN(aN(x)), assignO(aO(x)), assignP(aP(x)), assignQ(aQ(x)), assignR(aR(x)), assignS(aS(x)), assignT(aT(x)), assignU(aU(x)), assignV(aV(x)))
    def decode(x: JValue): Either[DecodeError, TT] =
      pattern.matches(x) match {
        case Right(results) =>
          val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results), retrieveI(results), retrieveJ(results), retrieveK(results), retrieveL(results), retrieveM(results), retrieveN(results), retrieveO(results), retrieveP(results), retrieveQ(results), retrieveR(results), retrieveS(results), retrieveT(results), retrieveU(results), retrieveV(results))
          try {
            Right(ctor.newInstance(params: _*).asInstanceOf[TT])
          } catch {
            case e: java.lang.reflect.InvocationTargetException => throw e.getCause
          }
        case Left(err) =>
          Left(err)
      }
  }
}
  }

  def apply[TT: ClassTag] = new FixedSimpleJsonCodecBuilder[TT]
}
