/*
 * Decompiled with CFR 0.152.
 */
package com.rojoma.json.v3.io;

import com.rojoma.json.v3.io.JsonToken;
import com.rojoma.json.v3.io.JsonTokenGenerator;
import com.rojoma.json.v3.io.JsonTokenGeneratorImpl;
import com.rojoma.json.v3.io.JsonTokenGeneratorImpl$IdentifierReader$;
import com.rojoma.json.v3.io.JsonTokenGeneratorImpl$NumberReader$;
import com.rojoma.json.v3.io.JsonTokenGeneratorImpl$StringReader$;
import com.rojoma.json.v3.io.Position$;
import com.rojoma.json.v3.io.SimpleJsonToken;
import com.rojoma.json.v3.io.TokenCloseBrace;
import com.rojoma.json.v3.io.TokenCloseBracket;
import com.rojoma.json.v3.io.TokenColon;
import com.rojoma.json.v3.io.TokenComma;
import com.rojoma.json.v3.io.TokenOpenBrace;
import com.rojoma.json.v3.io.TokenOpenBracket;
import scala.MatchError;
import scala.runtime.BoxesRunTime;

public final class JsonTokenGeneratorImpl$ {
    public static final JsonTokenGeneratorImpl$ MODULE$;

    static {
        new JsonTokenGeneratorImpl$();
    }

    public JsonTokenGenerator.Token token(JsonToken token, JsonTokenGeneratorImpl.PositionedCharExtractor input) {
        return new JsonTokenGenerator.Token(token, new JsonTokenGeneratorImpl.WaitingForToken(Position$.MODULE$.apply(input.nextCharRow(), input.nextCharCol())), input.freeze());
    }

    public JsonTokenGenerator.Result readToken(JsonTokenGeneratorImpl.PositionedCharExtractor input) {
        JsonTokenGenerator.Result result;
        char c = input.peek();
        switch (c) {
            default: {
                if (JsonTokenGeneratorImpl$NumberReader$.MODULE$.isDigit(c)) {
                    result = JsonTokenGeneratorImpl$NumberReader$.MODULE$.readNumber(input);
                    break;
                }
                if (Character.isUnicodeIdentifierStart(c)) {
                    result = JsonTokenGeneratorImpl$IdentifierReader$.MODULE$.readIdentifier(input);
                    break;
                }
                result = new JsonTokenGenerator.UnexpectedCharacter(c, "start of datum", Position$.MODULE$.apply(input.nextCharRow(), input.nextCharCol()));
                break;
            }
            case '-': {
                result = JsonTokenGeneratorImpl$NumberReader$.MODULE$.readNumber(input);
                break;
            }
            case '\"': 
            case '\'': {
                result = JsonTokenGeneratorImpl$StringReader$.MODULE$.readString(input);
                break;
            }
            case ',': 
            case ':': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                result = this.readSingleCharToken(input);
            }
        }
        return result;
    }

    public JsonTokenGenerator.Token readSingleCharToken(JsonTokenGeneratorImpl.PositionedCharExtractor input) {
        SimpleJsonToken simpleJsonToken;
        long position = Position$.MODULE$.apply(input.nextCharRow(), input.nextCharCol());
        char c = input.next();
        switch (c) {
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToCharacter((char)c));
            }
            case ',': {
                simpleJsonToken = new TokenComma(position);
                break;
            }
            case ':': {
                simpleJsonToken = new TokenColon(position);
                break;
            }
            case ']': {
                simpleJsonToken = new TokenCloseBracket(position);
                break;
            }
            case '[': {
                simpleJsonToken = new TokenOpenBracket(position);
                break;
            }
            case '}': {
                simpleJsonToken = new TokenCloseBrace(position);
                break;
            }
            case '{': {
                simpleJsonToken = new TokenOpenBrace(position);
            }
        }
        SimpleJsonToken t = simpleJsonToken;
        return this.token(t, input);
    }

    private JsonTokenGeneratorImpl$() {
        MODULE$ = this;
    }
}

