/*
 * Decompiled with CFR 0.152.
 */
package com.rojoma.json.v3.io;

import com.rojoma.json.v3.$minusimpl.util.AbstractBufferedIterator;
import com.rojoma.json.v3.io.JsonLexerEOF;
import com.rojoma.json.v3.io.JsonNumberOutOfRange;
import com.rojoma.json.v3.io.JsonToken;
import com.rojoma.json.v3.io.JsonUnexpectedCharacter;
import com.rojoma.json.v3.io.NoSuchTokenException;
import com.rojoma.json.v3.io.Position$;
import com.rojoma.json.v3.io.ReaderUtils$;
import com.rojoma.json.v3.io.TokenCloseBrace;
import com.rojoma.json.v3.io.TokenCloseBracket;
import com.rojoma.json.v3.io.TokenColon;
import com.rojoma.json.v3.io.TokenComma;
import com.rojoma.json.v3.io.TokenIdentifier;
import com.rojoma.json.v3.io.TokenNumber;
import com.rojoma.json.v3.io.TokenOpenBrace;
import com.rojoma.json.v3.io.TokenOpenBracket;
import com.rojoma.json.v3.io.TokenString;
import java.io.Reader;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001B\u0001\u0003\u00015\u0011\u0011CS:p]R{7.\u001a8Ji\u0016\u0014\u0018\r^8s\u0015\t\u0019A!\u0001\u0002j_*\u0011QAB\u0001\u0003mNR!a\u0002\u0005\u0002\t)\u001cxN\u001c\u0006\u0003\u0013)\taA]8k_6\f'\"A\u0006\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001q\u0001cA\b\u0015-5\t\u0001C\u0003\u0002\u0012%\u0005!Q\u000f^5m\u0015\t\u0019B!\u0001\u0006%[&tWo]5na2L!!\u0006\t\u00031\u0005\u00137\u000f\u001e:bGR\u0014UO\u001a4fe\u0016$\u0017\n^3sCR|'\u000f\u0005\u0002\u001815\t!!\u0003\u0002\u001a\u0005\tI!j]8o)>\\WM\u001c\u0005\t7\u0001\u0011\t\u0011)A\u00059\u00051!/Z1eKJ\u0004\"!H\u0011\u000e\u0003yQ!aA\u0010\u000b\u0003\u0001\nAA[1wC&\u0011!E\b\u0002\u0007%\u0016\fG-\u001a:\t\u000b\u0011\u0002A\u0011A\u0013\u0002\rqJg.\u001b;?)\t1s\u0005\u0005\u0002\u0018\u0001!)1d\ta\u00019!1\u0011\u0006\u0001Q!\n)\n\u0001\"[:QK\u0016\\W\r\u001a\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\b\u0005>|G.Z1o\u0011%\t\u0004\u00011A\u0001B\u0003&!'\u0001\u0004qK\u0016\\W\r\u001a\t\u0003WMJ!\u0001\u000e\u0017\u0003\t\rC\u0017M\u001d\u0005\u0007m\u0001\u0001\u000b\u0015\u0002\f\u0002\u00139,\u0007\u0010\u001e+pW\u0016t\u0007B\u0002\u001d\u0001A\u0003&\u0011(A\u0006oKb$8\t[1s%><\bCA\u0016;\u0013\tYDFA\u0002J]RDa!\u0010\u0001!B\u0013I\u0014a\u00038fqR\u001c\u0005.\u0019:D_2Daa\u0010\u0001!\u0002\u0013\u0001\u0015aB:de\u0006$8\r\u001b\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u0007\u0012\u000bq!\\;uC\ndWM\u0003\u0002FY\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u001d\u0013%!D*ue&twMQ;jY\u0012,'\u000fC\u0003J\u0001\u0011\u0005#*\u0001\u0005u_N#(/\u001b8h)\u0005Y\u0005C\u0001'P\u001b\u0005i%B\u0001( \u0003\u0011a\u0017M\\4\n\u0005Ak%AB*ue&tw\rC\u0003S\u0001\u0011%1+\u0001\u0006mKb,'/\u0012:s_J$R\u0001V,ZC\u000e\u0004\"aK+\n\u0005Yc#a\u0002(pi\"Lgn\u001a\u0005\u00061F\u0003\rAM\u0001\re\u0016\u001cW-\u001b<fI\u000eC\u0017M\u001d\u0005\u00065F\u0003\raW\u0001\tKb\u0004Xm\u0019;fIB\u0011Al\u0018\b\u0003WuK!A\u0018\u0017\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0006M\u0003\u0002_Y!)!-\u0015a\u0001s\u0005\u0019!o\\<\t\u000b\u0011\f\u0006\u0019A\u001d\u0002\u0007\r|G\u000eC\u0003g\u0001\u0011%q-\u0001\u0005oKb$8\t[1s)\u0005\u0011\u0004\"B5\u0001\t\u00139\u0017\u0001\u00039fK.\u001c\u0005.\u0019:\t\u000b-\u0004A\u0011\u00027\u0002\u000b\u0005$Xi\u0014$\u0015\u0003)BQA\u001c\u0001\u0005\n=\fqb]6jaR{WI\u001c3PM2Kg.\u001a\u000b\u0002aB\u00111&]\u0005\u0003e2\u0012A!\u00168ji\")A\u000f\u0001C\u0005_\u0006\u00012o[5q\u00052|7m[\"p[6,g\u000e\u001e\u0005\u0006m\u0002!Ia\\\u0001\fg.L\u0007oQ8n[\u0016tG\u000fC\u0003y\u0001\u0011%q.\u0001\btW&\u0004x\u000b[5uKN\u0004\u0018mY3)\u0005]T\bCA>\u007f\u001b\u0005a(BA?-\u0003)\tgN\\8uCRLwN\\\u0005\u0003\u007fr\u0014q\u0001^1jYJ,7\rC\u0004\u0002\u0004\u0001!\t!!\u0002\u0002\u000f!\f7OT3yiV\t!\u0006C\u0004\u0002\n\u0001!\t!a\u0003\u0002\t!,\u0017\rZ\u000b\u0002-!9\u0011q\u0002\u0001\u0005\u0002\u0005E\u0011\u0001\u00028fqR$\u0012A\u0006\u0005\u0007\u0003+\u0001A\u0011B8\u0002\u000f\u0005$g/\u00198dK\"9\u0011\u0011\u0004\u0001\u0005\n\u0005m\u0011aB5t\t&<\u0017\u000e\u001e\u000b\u0004U\u0005u\u0001bBA\u0010\u0003/\u0001\rAM\u0001\u0002G\"1\u00111\u0005\u0001\u0005\n\u001d\f\u0011B]3bI\u0012Kw-\u001b;\t\u000f\u0005\u001d\u0002\u0001\"\u0003\u0002*\u0005Q!/Z1e\u001dVl'-\u001a:\u0015\t\u0005-\u0012\u0011\u0007\t\u0004/\u00055\u0012bAA\u0018\u0005\tYAk\\6f]:+XNY3s\u0011!\t\u0019$!\nA\u0002\u0005U\u0012\u0001C:uCJ$\bk\\:\u0011\u0007]\t9$C\u0002\u0002:\t\u0011\u0001\u0002U8tSRLwN\u001c\u0005\b\u0003{\u0001A\u0011BA \u00039\u0011X-\u00193JI\u0016tG/\u001b4jKJ$B!!\u0011\u0002HA\u0019q#a\u0011\n\u0007\u0005\u0015#AA\bU_.,g.\u00133f]RLg-[3s\u0011!\t\u0019$a\u000fA\u0002\u0005U\u0002bBA&\u0001\u0011%\u0011QJ\u0001\u000be\u0016\fGm\u0015;sS:<G\u0003BA(\u0003+\u00022aFA)\u0013\r\t\u0019F\u0001\u0002\f)>\\WM\\*ue&tw\r\u0003\u0005\u00024\u0005%\u0003\u0019AA\u001b\u0011\u001d\tI\u0006\u0001C\u0005\u00037\n!D]3bIB{G/\u001a8uS\u0006d7+\u001e:s_\u001e\fG/\u001a)bSJ$R\u0001]A/\u0003?Bq!a\b\u0002X\u0001\u0007!\u0007C\u0004\u0002b\u0005]\u0003\u0019\u0001\u001a\u0002\u0017\u0015tGm\u00144TiJLgn\u001a\u0005\b\u0003K\u0002A\u0011BA4\u0003\u001d\u0011\u0017\rZ\"iCJ,\u0012A\r\u0005\b\u0003W\u0002A\u0011BA7\u0003E\u0011X-\u00193TkJ\u0014xnZ1uKB\u000b\u0017N\u001d\u000b\u0006a\u0006=\u0014\u0011\u000f\u0005\b\u0003?\tI\u00071\u00013\u0011\u001d\t\t'!\u001bA\u0002IB3!!\u001b{\u0011\u0019\t9\b\u0001C\u0005O\u0006A!/Z1e\u0007\"\f'\u000f\u0003\u0004\u0002|\u0001!IaZ\u0001\u0015e\u0016\fG-R:dCB,Gm\u00115be\u0006\u001cG/\u001a:\t\r\u0005}\u0004\u0001\"\u0003h\u0003Q\u0011X-\u00193V]&\u001cw\u000eZ3DQ\u0006\u0014\u0018m\u0019;fe\"9\u00111\u0011\u0001\u0005\n\u0005\u0015\u0015\u0001\u0004:fC\u0012DU\r\u001f#jO&$H#A\u001d")
public class JsonTokenIterator
extends AbstractBufferedIterator<JsonToken> {
    private final Reader reader;
    private boolean isPeeked;
    private char peeked;
    private JsonToken nextToken;
    private int nextCharRow;
    private int nextCharCol;
    private final StringBuilder scratch;

    @Override
    public String toString() {
        return this.nextToken != null ? "non-empty iterator" : "possibly-empty iterator";
    }

    private Nothing$ lexerError(char receivedChar, String expected, int row, int col) {
        throw new JsonUnexpectedCharacter(receivedChar, expected, Position$.MODULE$.apply(row, col));
    }

    private char nextChar() {
        this.peekChar();
        this.isPeeked = false;
        if (this.peeked == '\n') {
            ++this.nextCharRow;
            this.nextCharCol = 1;
        } else {
            ++this.nextCharCol;
        }
        return this.peeked;
    }

    private char peekChar() {
        if (!this.isPeeked) {
            int newChar = this.reader.read();
            if (newChar == -1) {
                throw new JsonLexerEOF(Position$.MODULE$.apply(this.nextCharRow, this.nextCharCol));
            }
            this.peeked = (char)newChar;
            this.isPeeked = true;
        }
        return this.peeked;
    }

    private boolean atEOF() {
        if (this.isPeeked) {
            return false;
        }
        int newChar = this.reader.read();
        if (newChar == -1) {
            return true;
        }
        this.peeked = (char)newChar;
        this.isPeeked = true;
        return false;
    }

    private void skipToEndOfLine() {
        while (!this.atEOF() && this.peekChar() != '\n') {
            this.nextChar();
        }
    }

    private void skipBlockComment() {
        char last = this.nextChar();
        while (last != '*' || this.peekChar() != '/') {
            last = this.nextChar();
        }
        this.nextChar();
    }

    private void skipComment() {
        this.nextChar();
        int row = this.nextCharRow;
        int col = this.nextCharCol;
        char c = this.nextChar();
        switch (c) {
            default: {
                throw this.lexerError(c, "/ or *", row, col);
            }
            case '*': {
                this.skipBlockComment();
                break;
            }
            case '/': {
                this.skipToEndOfLine();
            }
        }
    }

    private void skipWhitespace() {
        while (true) {
            if (!this.atEOF() && Character.isWhitespace(this.peekChar())) {
                this.nextChar();
                continue;
            }
            if (this.atEOF() || this.peekChar() != '/') break;
            this.skipComment();
        }
    }

    public boolean hasNext() {
        if (this.nextToken == null) {
            this.advance();
        }
        return this.nextToken != null;
    }

    public JsonToken head() {
        if (this.hasNext()) {
            return this.nextToken;
        }
        throw new NoSuchTokenException(Position$.MODULE$.apply(this.nextCharRow, this.nextCharCol));
    }

    /*
     * WARNING - void declaration
     */
    public JsonToken next() {
        void var1_1;
        JsonToken result = this.head();
        this.nextToken = null;
        return var1_1;
    }

    private void advance() {
        JsonToken jsonToken;
        this.skipWhitespace();
        if (this.atEOF()) {
            this.nextToken = null;
            return;
        }
        long tokenPosition = Position$.MODULE$.apply(this.nextCharRow, this.nextCharCol);
        char c = this.peekChar();
        switch (c) {
            default: {
                if (this.isDigit(c)) {
                    jsonToken = this.readNumber(tokenPosition);
                    break;
                }
                if (Character.isUnicodeIdentifierStart(c)) {
                    jsonToken = this.readIdentifier(tokenPosition);
                    break;
                }
                throw this.lexerError(c, "start of datum", this.nextCharRow, this.nextCharCol);
            }
            case '-': {
                jsonToken = this.readNumber(tokenPosition);
                break;
            }
            case '\"': 
            case '\'': {
                jsonToken = this.readString(tokenPosition);
                break;
            }
            case ',': {
                this.nextChar();
                jsonToken = new TokenComma(tokenPosition);
                break;
            }
            case ':': {
                this.nextChar();
                jsonToken = new TokenColon(tokenPosition);
                break;
            }
            case ']': {
                this.nextChar();
                jsonToken = new TokenCloseBracket(tokenPosition);
                break;
            }
            case '[': {
                this.nextChar();
                jsonToken = new TokenOpenBracket(tokenPosition);
                break;
            }
            case '}': {
                this.nextChar();
                jsonToken = new TokenCloseBrace(tokenPosition);
                break;
            }
            case '{': {
                this.nextChar();
                jsonToken = new TokenOpenBrace(tokenPosition);
            }
        }
        JsonToken token = jsonToken;
        this.nextToken = token;
    }

    private boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }

    /*
     * WARNING - void declaration
     */
    private char readDigit() {
        void var2_2;
        void var1_1;
        void var3_3;
        int row = this.nextCharRow;
        int col = this.nextCharCol;
        char c = this.nextChar();
        if (this.isDigit(c)) {
            return (char)var3_3;
        }
        throw this.lexerError((char)var3_3, "digit", (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TokenNumber readNumber(long startPos) {
        String string;
        boolean hasExponent;
        boolean hasFrac;
        this.scratch.setLength(0);
        Object object = this.peekChar() == '-' ? this.scratch.$plus$eq(this.nextChar()) : BoxedUnit.UNIT;
        do {
            this.scratch.$plus$eq(this.readDigit());
        } while (!this.atEOF() && this.isDigit(this.peekChar()));
        boolean bl = hasFrac = !this.atEOF() && this.peekChar() == '.';
        if (hasFrac) {
            this.scratch.$plus$eq(this.nextChar());
            do {
                this.scratch.$plus$eq(this.readDigit());
            } while (!this.atEOF() && this.isDigit(this.peekChar()));
        }
        boolean bl2 = hasExponent = !this.atEOF() && (this.peekChar() == 'e' || this.peekChar() == 'E');
        if (hasExponent) {
            this.scratch.$plus$eq(this.nextChar());
            StringBuilder stringBuilder = this.peekChar() == '-' || this.peekChar() == '+' ? this.scratch.$plus$eq(this.nextChar()) : this.scratch.$plus$eq('+');
            int exponentDigitsStart = this.scratch.length();
            do {
                this.scratch.$plus$eq(this.readDigit());
            } while (!this.atEOF() && this.isDigit(this.peekChar()));
            String result = this.scratch.toString();
            if (!ReaderUtils$.MODULE$.isBigDecimalizableUnsignedExponent(result, exponentDigitsStart)) void var7_5;
            throw new JsonNumberOutOfRange((String)var7_5, startPos);
            string = result;
        } else {
            string = this.scratch.toString();
        }
        String n = string;
        return new TokenNumber(n, startPos);
    }

    private TokenIdentifier readIdentifier(long startPos) {
        this.scratch.setLength(0);
        this.scratch.$plus$eq(this.nextChar());
        while (!this.atEOF() && Character.isUnicodeIdentifierPart(this.peekChar())) {
            this.scratch.$plus$eq(this.nextChar());
        }
        return new TokenIdentifier(this.scratch.toString(), startPos);
    }

    private TokenString readString(long startPos) {
        this.scratch.setLength(0);
        char Boundary = this.nextChar();
        while (this.peekChar() != Boundary) {
            this.readPotentialSurrogatePair(this.readChar(), Boundary);
        }
        this.nextChar();
        return new TokenString(this.scratch.toString(), startPos);
    }

    private void readPotentialSurrogatePair(char c, char endOfString) {
        if (c >= '\ud800' && c <= '\udfff') {
            this.readSurrogatePair(c, endOfString);
        } else {
            this.scratch.$plus$eq(c);
        }
    }

    private char badChar() {
        return (char)65533;
    }

    private void readSurrogatePair(char c, char endOfString) {
        block6: {
            BoxedUnit boxedUnit;
            while (Character.isHighSurrogate(c)) {
                if (this.peekChar() == endOfString) {
                    this.scratch.$plus$eq(this.badChar());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    char potentialSecondHalf = this.readChar();
                    if (Character.isLowSurrogate(potentialSecondHalf)) {
                        this.scratch.$plus$eq(c);
                        this.scratch.$plus$eq(potentialSecondHalf);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.scratch.$plus$eq(this.badChar());
                        if (potentialSecondHalf >= '\ud800' && c <= '\udfff') {
                            c = potentialSecondHalf;
                            continue;
                        }
                        this.scratch.$plus$eq(potentialSecondHalf);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
                break block6;
            }
            this.scratch.$plus$eq(this.badChar());
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private char readChar() {
        char c;
        char c2 = this.nextChar();
        switch (c2) {
            default: {
                c = c2;
                break;
            }
            case '\\': {
                c = this.readEscapedCharacter();
            }
        }
        return c;
    }

    private char readEscapedCharacter() {
        char c;
        int row = this.nextCharRow;
        int col = this.nextCharCol;
        char c2 = this.nextChar();
        switch (c2) {
            default: {
                throw this.lexerError(c2, "string escape character", row, col);
            }
            case 'u': {
                c = this.readUnicodeCharacter();
                break;
            }
            case 't': {
                c = '\t';
                break;
            }
            case 'r': {
                c = '\r';
                break;
            }
            case 'n': {
                c = '\n';
                break;
            }
            case 'f': {
                c = '\f';
                break;
            }
            case 'b': {
                c = '\b';
                break;
            }
            case '/': {
                c = '/';
                break;
            }
            case '\\': {
                c = '\\';
                break;
            }
            case '\'': {
                c = '\'';
                break;
            }
            case '\"': {
                c = '\"';
            }
        }
        return c;
    }

    private char readUnicodeCharacter() {
        int h1 = this.readHexDigit();
        int h2 = this.readHexDigit();
        int h3 = this.readHexDigit();
        int h4 = this.readHexDigit();
        return (char)(h1 << 12 | h2 << 8 | h3 << 4 | h4);
    }

    private int readHexDigit() {
        char c;
        int col;
        int row;
        block5: {
            int n;
            block3: {
                block4: {
                    block2: {
                        row = this.nextCharRow;
                        col = this.nextCharCol;
                        c = this.nextChar();
                        if (!this.isDigit(c)) break block2;
                        n = c - 48;
                        break block3;
                    }
                    if ('a' > c || c > 'f') break block4;
                    n = 10 + c - 97;
                    break block3;
                }
                if ('A' > c || c > 'F') break block5;
                n = 10 + c - 65;
            }
            return n;
        }
        throw this.lexerError(c, "hex digit", row, col);
    }

    public JsonTokenIterator(Reader reader) {
        this.reader = reader;
        this.isPeeked = false;
        this.nextToken = null;
        this.nextCharRow = 1;
        this.nextCharCol = 1;
        this.scratch = new StringBuilder();
    }
}

