/*
 * Decompiled with CFR 0.152.
 */
package com.rojoma.json.v3.util.time;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;

final class ParseHelper {
    private ParseHelper() {
    }

    static Instant parseInstant(String string) {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)string, Instant::from);
    }

    static OffsetDateTime parseOffsetDateTime(String string) {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)string, OffsetDateTime::from);
    }

    static OffsetTime parseOffsetTime(String string) {
        return DateTimeFormatter.ISO_OFFSET_TIME.parse((CharSequence)string, OffsetTime::from);
    }

    static LocalDateTime parseLocalDateTime(String string) {
        return DateTimeFormatter.ISO_LOCAL_DATE_TIME.parse((CharSequence)string, LocalDateTime::from);
    }

    static LocalDate parseLocalDate(String string) {
        return DateTimeFormatter.ISO_LOCAL_DATE.parse((CharSequence)string, LocalDate::from);
    }

    static LocalTime parseLocalTime(String string) {
        return DateTimeFormatter.ISO_LOCAL_TIME.parse((CharSequence)string, LocalTime::from);
    }

    static Instant parseInstantRFC1123(String string) {
        return DateTimeFormatter.RFC_1123_DATE_TIME.parse((CharSequence)string, Instant::from);
    }

    static OffsetDateTime parseOffsetDateTimeRFC1123(String string) {
        return DateTimeFormatter.RFC_1123_DATE_TIME.parse((CharSequence)string, OffsetDateTime::from);
    }
}

