package com.rojoma.json
package util

import ast._
import codec._
import matcher._

import com.rojoma.`json-impl`.util._

object SimpleJsonCodecBuilder {
  private def t[A: Manifest]: Class[_] = manifest[A].erasure

  private def findCtor(baseClass: Class[_])(fieldClasses: Class[_]*) = {
    baseClass.getConstructor(fieldClasses : _*)
  }

  // the horror, the horror
  private def extract[A](implicit jcooA: JsonCodecOrOption[A]) = jcooA match {
    case jc: JsonCodecVersion[_] =>
      val varA = Variable[jc.RealType]()(jc.codec)
      val assignA = (varA := _).asInstanceOf[Any => Pattern.Results => Pattern.Results]
      val retrieveA = varA(_: Pattern.Results).asInstanceOf[AnyRef]
      (assignA, retrieveA, varA)
    case o: OptionVersion[_] =>
      val varA = Variable[o.RealType]()(o.codec)
      val assignA = (varA :=? _).asInstanceOf[Any => Pattern.Results => Pattern.Results]
      val retrieveA = varA.get(_: Pattern.Results).asInstanceOf[AnyRef]
      (assignA, retrieveA, POption(varA))
  }

  class FixedSimpleJsonCodecBuilder[TT: Manifest] {
def build[A: JsonCodecOrOption: Manifest](fA: String, aA: TT => A): JsonCodec[TT] = {
  val ctor = findCtor(t[TT])(t[A])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val pattern = PObject(fA -> patTargetA)
  new JsonCodec[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)))
    def decode(x: JValue): Option[TT] =
      pattern.matches(x) map { results =>
        val params = Array(retrieveA(results))
        try {
          ctor.newInstance(params: _*).asInstanceOf[TT]
        } catch {
          case e: java.lang.reflect.InvocationTargetException => throw e.getCause
        }
      }
  }
}
def build[A: JsonCodecOrOption: Manifest, B: JsonCodecOrOption: Manifest](fA: String, aA: TT => A, fB: String, aB: TT => B): JsonCodec[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB)
  new JsonCodec[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)))
    def decode(x: JValue): Option[TT] =
      pattern.matches(x) map { results =>
        val params = Array(retrieveA(results), retrieveB(results))
        try {
          ctor.newInstance(params: _*).asInstanceOf[TT]
        } catch {
          case e: java.lang.reflect.InvocationTargetException => throw e.getCause
        }
      }
  }
}
def build[A: JsonCodecOrOption: Manifest, B: JsonCodecOrOption: Manifest, C: JsonCodecOrOption: Manifest](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C): JsonCodec[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC)
  new JsonCodec[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)))
    def decode(x: JValue): Option[TT] =
      pattern.matches(x) map { results =>
        val params = Array(retrieveA(results), retrieveB(results), retrieveC(results))
        try {
          ctor.newInstance(params: _*).asInstanceOf[TT]
        } catch {
          case e: java.lang.reflect.InvocationTargetException => throw e.getCause
        }
      }
  }
}
def build[A: JsonCodecOrOption: Manifest, B: JsonCodecOrOption: Manifest, C: JsonCodecOrOption: Manifest, D: JsonCodecOrOption: Manifest](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D): JsonCodec[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD)
  new JsonCodec[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)))
    def decode(x: JValue): Option[TT] =
      pattern.matches(x) map { results =>
        val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results))
        try {
          ctor.newInstance(params: _*).asInstanceOf[TT]
        } catch {
          case e: java.lang.reflect.InvocationTargetException => throw e.getCause
        }
      }
  }
}
def build[A: JsonCodecOrOption: Manifest, B: JsonCodecOrOption: Manifest, C: JsonCodecOrOption: Manifest, D: JsonCodecOrOption: Manifest, E: JsonCodecOrOption: Manifest](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E): JsonCodec[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE)
  new JsonCodec[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)))
    def decode(x: JValue): Option[TT] =
      pattern.matches(x) map { results =>
        val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results))
        try {
          ctor.newInstance(params: _*).asInstanceOf[TT]
        } catch {
          case e: java.lang.reflect.InvocationTargetException => throw e.getCause
        }
      }
  }
}
def build[A: JsonCodecOrOption: Manifest, B: JsonCodecOrOption: Manifest, C: JsonCodecOrOption: Manifest, D: JsonCodecOrOption: Manifest, E: JsonCodecOrOption: Manifest, F: JsonCodecOrOption: Manifest](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F): JsonCodec[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF)
  new JsonCodec[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)))
    def decode(x: JValue): Option[TT] =
      pattern.matches(x) map { results =>
        val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results))
        try {
          ctor.newInstance(params: _*).asInstanceOf[TT]
        } catch {
          case e: java.lang.reflect.InvocationTargetException => throw e.getCause
        }
      }
  }
}
def build[A: JsonCodecOrOption: Manifest, B: JsonCodecOrOption: Manifest, C: JsonCodecOrOption: Manifest, D: JsonCodecOrOption: Manifest, E: JsonCodecOrOption: Manifest, F: JsonCodecOrOption: Manifest, G: JsonCodecOrOption: Manifest](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G): JsonCodec[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG)
  new JsonCodec[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)))
    def decode(x: JValue): Option[TT] =
      pattern.matches(x) map { results =>
        val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results))
        try {
          ctor.newInstance(params: _*).asInstanceOf[TT]
        } catch {
          case e: java.lang.reflect.InvocationTargetException => throw e.getCause
        }
      }
  }
}
def build[A: JsonCodecOrOption: Manifest, B: JsonCodecOrOption: Manifest, C: JsonCodecOrOption: Manifest, D: JsonCodecOrOption: Manifest, E: JsonCodecOrOption: Manifest, F: JsonCodecOrOption: Manifest, G: JsonCodecOrOption: Manifest, H: JsonCodecOrOption: Manifest](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H): JsonCodec[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH)
  new JsonCodec[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)))
    def decode(x: JValue): Option[TT] =
      pattern.matches(x) map { results =>
        val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results))
        try {
          ctor.newInstance(params: _*).asInstanceOf[TT]
        } catch {
          case e: java.lang.reflect.InvocationTargetException => throw e.getCause
        }
      }
  }
}
def build[A: JsonCodecOrOption: Manifest, B: JsonCodecOrOption: Manifest, C: JsonCodecOrOption: Manifest, D: JsonCodecOrOption: Manifest, E: JsonCodecOrOption: Manifest, F: JsonCodecOrOption: Manifest, G: JsonCodecOrOption: Manifest, H: JsonCodecOrOption: Manifest, I: JsonCodecOrOption: Manifest](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H, fI: String, aI: TT => I): JsonCodec[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H], t[I])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val (assignI, retrieveI, patTargetI) = extract[I]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH, fI -> patTargetI)
  new JsonCodec[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)), assignI(aI(x)))
    def decode(x: JValue): Option[TT] =
      pattern.matches(x) map { results =>
        val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results), retrieveI(results))
        try {
          ctor.newInstance(params: _*).asInstanceOf[TT]
        } catch {
          case e: java.lang.reflect.InvocationTargetException => throw e.getCause
        }
      }
  }
}
def build[A: JsonCodecOrOption: Manifest, B: JsonCodecOrOption: Manifest, C: JsonCodecOrOption: Manifest, D: JsonCodecOrOption: Manifest, E: JsonCodecOrOption: Manifest, F: JsonCodecOrOption: Manifest, G: JsonCodecOrOption: Manifest, H: JsonCodecOrOption: Manifest, I: JsonCodecOrOption: Manifest, J: JsonCodecOrOption: Manifest](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H, fI: String, aI: TT => I, fJ: String, aJ: TT => J): JsonCodec[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H], t[I], t[J])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val (assignI, retrieveI, patTargetI) = extract[I]
  val (assignJ, retrieveJ, patTargetJ) = extract[J]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH, fI -> patTargetI, fJ -> patTargetJ)
  new JsonCodec[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)), assignI(aI(x)), assignJ(aJ(x)))
    def decode(x: JValue): Option[TT] =
      pattern.matches(x) map { results =>
        val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results), retrieveI(results), retrieveJ(results))
        try {
          ctor.newInstance(params: _*).asInstanceOf[TT]
        } catch {
          case e: java.lang.reflect.InvocationTargetException => throw e.getCause
        }
      }
  }
}
def build[A: JsonCodecOrOption: Manifest, B: JsonCodecOrOption: Manifest, C: JsonCodecOrOption: Manifest, D: JsonCodecOrOption: Manifest, E: JsonCodecOrOption: Manifest, F: JsonCodecOrOption: Manifest, G: JsonCodecOrOption: Manifest, H: JsonCodecOrOption: Manifest, I: JsonCodecOrOption: Manifest, J: JsonCodecOrOption: Manifest, K: JsonCodecOrOption: Manifest](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H, fI: String, aI: TT => I, fJ: String, aJ: TT => J, fK: String, aK: TT => K): JsonCodec[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H], t[I], t[J], t[K])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val (assignI, retrieveI, patTargetI) = extract[I]
  val (assignJ, retrieveJ, patTargetJ) = extract[J]
  val (assignK, retrieveK, patTargetK) = extract[K]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH, fI -> patTargetI, fJ -> patTargetJ, fK -> patTargetK)
  new JsonCodec[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)), assignI(aI(x)), assignJ(aJ(x)), assignK(aK(x)))
    def decode(x: JValue): Option[TT] =
      pattern.matches(x) map { results =>
        val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results), retrieveI(results), retrieveJ(results), retrieveK(results))
        try {
          ctor.newInstance(params: _*).asInstanceOf[TT]
        } catch {
          case e: java.lang.reflect.InvocationTargetException => throw e.getCause
        }
      }
  }
}
def build[A: JsonCodecOrOption: Manifest, B: JsonCodecOrOption: Manifest, C: JsonCodecOrOption: Manifest, D: JsonCodecOrOption: Manifest, E: JsonCodecOrOption: Manifest, F: JsonCodecOrOption: Manifest, G: JsonCodecOrOption: Manifest, H: JsonCodecOrOption: Manifest, I: JsonCodecOrOption: Manifest, J: JsonCodecOrOption: Manifest, K: JsonCodecOrOption: Manifest, L: JsonCodecOrOption: Manifest](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H, fI: String, aI: TT => I, fJ: String, aJ: TT => J, fK: String, aK: TT => K, fL: String, aL: TT => L): JsonCodec[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H], t[I], t[J], t[K], t[L])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val (assignI, retrieveI, patTargetI) = extract[I]
  val (assignJ, retrieveJ, patTargetJ) = extract[J]
  val (assignK, retrieveK, patTargetK) = extract[K]
  val (assignL, retrieveL, patTargetL) = extract[L]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH, fI -> patTargetI, fJ -> patTargetJ, fK -> patTargetK, fL -> patTargetL)
  new JsonCodec[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)), assignI(aI(x)), assignJ(aJ(x)), assignK(aK(x)), assignL(aL(x)))
    def decode(x: JValue): Option[TT] =
      pattern.matches(x) map { results =>
        val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results), retrieveI(results), retrieveJ(results), retrieveK(results), retrieveL(results))
        try {
          ctor.newInstance(params: _*).asInstanceOf[TT]
        } catch {
          case e: java.lang.reflect.InvocationTargetException => throw e.getCause
        }
      }
  }
}
def build[A: JsonCodecOrOption: Manifest, B: JsonCodecOrOption: Manifest, C: JsonCodecOrOption: Manifest, D: JsonCodecOrOption: Manifest, E: JsonCodecOrOption: Manifest, F: JsonCodecOrOption: Manifest, G: JsonCodecOrOption: Manifest, H: JsonCodecOrOption: Manifest, I: JsonCodecOrOption: Manifest, J: JsonCodecOrOption: Manifest, K: JsonCodecOrOption: Manifest, L: JsonCodecOrOption: Manifest, M: JsonCodecOrOption: Manifest](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H, fI: String, aI: TT => I, fJ: String, aJ: TT => J, fK: String, aK: TT => K, fL: String, aL: TT => L, fM: String, aM: TT => M): JsonCodec[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H], t[I], t[J], t[K], t[L], t[M])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val (assignI, retrieveI, patTargetI) = extract[I]
  val (assignJ, retrieveJ, patTargetJ) = extract[J]
  val (assignK, retrieveK, patTargetK) = extract[K]
  val (assignL, retrieveL, patTargetL) = extract[L]
  val (assignM, retrieveM, patTargetM) = extract[M]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH, fI -> patTargetI, fJ -> patTargetJ, fK -> patTargetK, fL -> patTargetL, fM -> patTargetM)
  new JsonCodec[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)), assignI(aI(x)), assignJ(aJ(x)), assignK(aK(x)), assignL(aL(x)), assignM(aM(x)))
    def decode(x: JValue): Option[TT] =
      pattern.matches(x) map { results =>
        val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results), retrieveI(results), retrieveJ(results), retrieveK(results), retrieveL(results), retrieveM(results))
        try {
          ctor.newInstance(params: _*).asInstanceOf[TT]
        } catch {
          case e: java.lang.reflect.InvocationTargetException => throw e.getCause
        }
      }
  }
}
def build[A: JsonCodecOrOption: Manifest, B: JsonCodecOrOption: Manifest, C: JsonCodecOrOption: Manifest, D: JsonCodecOrOption: Manifest, E: JsonCodecOrOption: Manifest, F: JsonCodecOrOption: Manifest, G: JsonCodecOrOption: Manifest, H: JsonCodecOrOption: Manifest, I: JsonCodecOrOption: Manifest, J: JsonCodecOrOption: Manifest, K: JsonCodecOrOption: Manifest, L: JsonCodecOrOption: Manifest, M: JsonCodecOrOption: Manifest, N: JsonCodecOrOption: Manifest](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H, fI: String, aI: TT => I, fJ: String, aJ: TT => J, fK: String, aK: TT => K, fL: String, aL: TT => L, fM: String, aM: TT => M, fN: String, aN: TT => N): JsonCodec[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H], t[I], t[J], t[K], t[L], t[M], t[N])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val (assignI, retrieveI, patTargetI) = extract[I]
  val (assignJ, retrieveJ, patTargetJ) = extract[J]
  val (assignK, retrieveK, patTargetK) = extract[K]
  val (assignL, retrieveL, patTargetL) = extract[L]
  val (assignM, retrieveM, patTargetM) = extract[M]
  val (assignN, retrieveN, patTargetN) = extract[N]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH, fI -> patTargetI, fJ -> patTargetJ, fK -> patTargetK, fL -> patTargetL, fM -> patTargetM, fN -> patTargetN)
  new JsonCodec[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)), assignI(aI(x)), assignJ(aJ(x)), assignK(aK(x)), assignL(aL(x)), assignM(aM(x)), assignN(aN(x)))
    def decode(x: JValue): Option[TT] =
      pattern.matches(x) map { results =>
        val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results), retrieveI(results), retrieveJ(results), retrieveK(results), retrieveL(results), retrieveM(results), retrieveN(results))
        try {
          ctor.newInstance(params: _*).asInstanceOf[TT]
        } catch {
          case e: java.lang.reflect.InvocationTargetException => throw e.getCause
        }
      }
  }
}
def build[A: JsonCodecOrOption: Manifest, B: JsonCodecOrOption: Manifest, C: JsonCodecOrOption: Manifest, D: JsonCodecOrOption: Manifest, E: JsonCodecOrOption: Manifest, F: JsonCodecOrOption: Manifest, G: JsonCodecOrOption: Manifest, H: JsonCodecOrOption: Manifest, I: JsonCodecOrOption: Manifest, J: JsonCodecOrOption: Manifest, K: JsonCodecOrOption: Manifest, L: JsonCodecOrOption: Manifest, M: JsonCodecOrOption: Manifest, N: JsonCodecOrOption: Manifest, O: JsonCodecOrOption: Manifest](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H, fI: String, aI: TT => I, fJ: String, aJ: TT => J, fK: String, aK: TT => K, fL: String, aL: TT => L, fM: String, aM: TT => M, fN: String, aN: TT => N, fO: String, aO: TT => O): JsonCodec[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H], t[I], t[J], t[K], t[L], t[M], t[N], t[O])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val (assignI, retrieveI, patTargetI) = extract[I]
  val (assignJ, retrieveJ, patTargetJ) = extract[J]
  val (assignK, retrieveK, patTargetK) = extract[K]
  val (assignL, retrieveL, patTargetL) = extract[L]
  val (assignM, retrieveM, patTargetM) = extract[M]
  val (assignN, retrieveN, patTargetN) = extract[N]
  val (assignO, retrieveO, patTargetO) = extract[O]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH, fI -> patTargetI, fJ -> patTargetJ, fK -> patTargetK, fL -> patTargetL, fM -> patTargetM, fN -> patTargetN, fO -> patTargetO)
  new JsonCodec[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)), assignI(aI(x)), assignJ(aJ(x)), assignK(aK(x)), assignL(aL(x)), assignM(aM(x)), assignN(aN(x)), assignO(aO(x)))
    def decode(x: JValue): Option[TT] =
      pattern.matches(x) map { results =>
        val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results), retrieveI(results), retrieveJ(results), retrieveK(results), retrieveL(results), retrieveM(results), retrieveN(results), retrieveO(results))
        try {
          ctor.newInstance(params: _*).asInstanceOf[TT]
        } catch {
          case e: java.lang.reflect.InvocationTargetException => throw e.getCause
        }
      }
  }
}
def build[A: JsonCodecOrOption: Manifest, B: JsonCodecOrOption: Manifest, C: JsonCodecOrOption: Manifest, D: JsonCodecOrOption: Manifest, E: JsonCodecOrOption: Manifest, F: JsonCodecOrOption: Manifest, G: JsonCodecOrOption: Manifest, H: JsonCodecOrOption: Manifest, I: JsonCodecOrOption: Manifest, J: JsonCodecOrOption: Manifest, K: JsonCodecOrOption: Manifest, L: JsonCodecOrOption: Manifest, M: JsonCodecOrOption: Manifest, N: JsonCodecOrOption: Manifest, O: JsonCodecOrOption: Manifest, P: JsonCodecOrOption: Manifest](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H, fI: String, aI: TT => I, fJ: String, aJ: TT => J, fK: String, aK: TT => K, fL: String, aL: TT => L, fM: String, aM: TT => M, fN: String, aN: TT => N, fO: String, aO: TT => O, fP: String, aP: TT => P): JsonCodec[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H], t[I], t[J], t[K], t[L], t[M], t[N], t[O], t[P])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val (assignI, retrieveI, patTargetI) = extract[I]
  val (assignJ, retrieveJ, patTargetJ) = extract[J]
  val (assignK, retrieveK, patTargetK) = extract[K]
  val (assignL, retrieveL, patTargetL) = extract[L]
  val (assignM, retrieveM, patTargetM) = extract[M]
  val (assignN, retrieveN, patTargetN) = extract[N]
  val (assignO, retrieveO, patTargetO) = extract[O]
  val (assignP, retrieveP, patTargetP) = extract[P]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH, fI -> patTargetI, fJ -> patTargetJ, fK -> patTargetK, fL -> patTargetL, fM -> patTargetM, fN -> patTargetN, fO -> patTargetO, fP -> patTargetP)
  new JsonCodec[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)), assignI(aI(x)), assignJ(aJ(x)), assignK(aK(x)), assignL(aL(x)), assignM(aM(x)), assignN(aN(x)), assignO(aO(x)), assignP(aP(x)))
    def decode(x: JValue): Option[TT] =
      pattern.matches(x) map { results =>
        val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results), retrieveI(results), retrieveJ(results), retrieveK(results), retrieveL(results), retrieveM(results), retrieveN(results), retrieveO(results), retrieveP(results))
        try {
          ctor.newInstance(params: _*).asInstanceOf[TT]
        } catch {
          case e: java.lang.reflect.InvocationTargetException => throw e.getCause
        }
      }
  }
}
def build[A: JsonCodecOrOption: Manifest, B: JsonCodecOrOption: Manifest, C: JsonCodecOrOption: Manifest, D: JsonCodecOrOption: Manifest, E: JsonCodecOrOption: Manifest, F: JsonCodecOrOption: Manifest, G: JsonCodecOrOption: Manifest, H: JsonCodecOrOption: Manifest, I: JsonCodecOrOption: Manifest, J: JsonCodecOrOption: Manifest, K: JsonCodecOrOption: Manifest, L: JsonCodecOrOption: Manifest, M: JsonCodecOrOption: Manifest, N: JsonCodecOrOption: Manifest, O: JsonCodecOrOption: Manifest, P: JsonCodecOrOption: Manifest, Q: JsonCodecOrOption: Manifest](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H, fI: String, aI: TT => I, fJ: String, aJ: TT => J, fK: String, aK: TT => K, fL: String, aL: TT => L, fM: String, aM: TT => M, fN: String, aN: TT => N, fO: String, aO: TT => O, fP: String, aP: TT => P, fQ: String, aQ: TT => Q): JsonCodec[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H], t[I], t[J], t[K], t[L], t[M], t[N], t[O], t[P], t[Q])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val (assignI, retrieveI, patTargetI) = extract[I]
  val (assignJ, retrieveJ, patTargetJ) = extract[J]
  val (assignK, retrieveK, patTargetK) = extract[K]
  val (assignL, retrieveL, patTargetL) = extract[L]
  val (assignM, retrieveM, patTargetM) = extract[M]
  val (assignN, retrieveN, patTargetN) = extract[N]
  val (assignO, retrieveO, patTargetO) = extract[O]
  val (assignP, retrieveP, patTargetP) = extract[P]
  val (assignQ, retrieveQ, patTargetQ) = extract[Q]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH, fI -> patTargetI, fJ -> patTargetJ, fK -> patTargetK, fL -> patTargetL, fM -> patTargetM, fN -> patTargetN, fO -> patTargetO, fP -> patTargetP, fQ -> patTargetQ)
  new JsonCodec[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)), assignI(aI(x)), assignJ(aJ(x)), assignK(aK(x)), assignL(aL(x)), assignM(aM(x)), assignN(aN(x)), assignO(aO(x)), assignP(aP(x)), assignQ(aQ(x)))
    def decode(x: JValue): Option[TT] =
      pattern.matches(x) map { results =>
        val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results), retrieveI(results), retrieveJ(results), retrieveK(results), retrieveL(results), retrieveM(results), retrieveN(results), retrieveO(results), retrieveP(results), retrieveQ(results))
        try {
          ctor.newInstance(params: _*).asInstanceOf[TT]
        } catch {
          case e: java.lang.reflect.InvocationTargetException => throw e.getCause
        }
      }
  }
}
def build[A: JsonCodecOrOption: Manifest, B: JsonCodecOrOption: Manifest, C: JsonCodecOrOption: Manifest, D: JsonCodecOrOption: Manifest, E: JsonCodecOrOption: Manifest, F: JsonCodecOrOption: Manifest, G: JsonCodecOrOption: Manifest, H: JsonCodecOrOption: Manifest, I: JsonCodecOrOption: Manifest, J: JsonCodecOrOption: Manifest, K: JsonCodecOrOption: Manifest, L: JsonCodecOrOption: Manifest, M: JsonCodecOrOption: Manifest, N: JsonCodecOrOption: Manifest, O: JsonCodecOrOption: Manifest, P: JsonCodecOrOption: Manifest, Q: JsonCodecOrOption: Manifest, R: JsonCodecOrOption: Manifest](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H, fI: String, aI: TT => I, fJ: String, aJ: TT => J, fK: String, aK: TT => K, fL: String, aL: TT => L, fM: String, aM: TT => M, fN: String, aN: TT => N, fO: String, aO: TT => O, fP: String, aP: TT => P, fQ: String, aQ: TT => Q, fR: String, aR: TT => R): JsonCodec[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H], t[I], t[J], t[K], t[L], t[M], t[N], t[O], t[P], t[Q], t[R])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val (assignI, retrieveI, patTargetI) = extract[I]
  val (assignJ, retrieveJ, patTargetJ) = extract[J]
  val (assignK, retrieveK, patTargetK) = extract[K]
  val (assignL, retrieveL, patTargetL) = extract[L]
  val (assignM, retrieveM, patTargetM) = extract[M]
  val (assignN, retrieveN, patTargetN) = extract[N]
  val (assignO, retrieveO, patTargetO) = extract[O]
  val (assignP, retrieveP, patTargetP) = extract[P]
  val (assignQ, retrieveQ, patTargetQ) = extract[Q]
  val (assignR, retrieveR, patTargetR) = extract[R]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH, fI -> patTargetI, fJ -> patTargetJ, fK -> patTargetK, fL -> patTargetL, fM -> patTargetM, fN -> patTargetN, fO -> patTargetO, fP -> patTargetP, fQ -> patTargetQ, fR -> patTargetR)
  new JsonCodec[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)), assignI(aI(x)), assignJ(aJ(x)), assignK(aK(x)), assignL(aL(x)), assignM(aM(x)), assignN(aN(x)), assignO(aO(x)), assignP(aP(x)), assignQ(aQ(x)), assignR(aR(x)))
    def decode(x: JValue): Option[TT] =
      pattern.matches(x) map { results =>
        val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results), retrieveI(results), retrieveJ(results), retrieveK(results), retrieveL(results), retrieveM(results), retrieveN(results), retrieveO(results), retrieveP(results), retrieveQ(results), retrieveR(results))
        try {
          ctor.newInstance(params: _*).asInstanceOf[TT]
        } catch {
          case e: java.lang.reflect.InvocationTargetException => throw e.getCause
        }
      }
  }
}
def build[A: JsonCodecOrOption: Manifest, B: JsonCodecOrOption: Manifest, C: JsonCodecOrOption: Manifest, D: JsonCodecOrOption: Manifest, E: JsonCodecOrOption: Manifest, F: JsonCodecOrOption: Manifest, G: JsonCodecOrOption: Manifest, H: JsonCodecOrOption: Manifest, I: JsonCodecOrOption: Manifest, J: JsonCodecOrOption: Manifest, K: JsonCodecOrOption: Manifest, L: JsonCodecOrOption: Manifest, M: JsonCodecOrOption: Manifest, N: JsonCodecOrOption: Manifest, O: JsonCodecOrOption: Manifest, P: JsonCodecOrOption: Manifest, Q: JsonCodecOrOption: Manifest, R: JsonCodecOrOption: Manifest, S: JsonCodecOrOption: Manifest](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H, fI: String, aI: TT => I, fJ: String, aJ: TT => J, fK: String, aK: TT => K, fL: String, aL: TT => L, fM: String, aM: TT => M, fN: String, aN: TT => N, fO: String, aO: TT => O, fP: String, aP: TT => P, fQ: String, aQ: TT => Q, fR: String, aR: TT => R, fS: String, aS: TT => S): JsonCodec[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H], t[I], t[J], t[K], t[L], t[M], t[N], t[O], t[P], t[Q], t[R], t[S])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val (assignI, retrieveI, patTargetI) = extract[I]
  val (assignJ, retrieveJ, patTargetJ) = extract[J]
  val (assignK, retrieveK, patTargetK) = extract[K]
  val (assignL, retrieveL, patTargetL) = extract[L]
  val (assignM, retrieveM, patTargetM) = extract[M]
  val (assignN, retrieveN, patTargetN) = extract[N]
  val (assignO, retrieveO, patTargetO) = extract[O]
  val (assignP, retrieveP, patTargetP) = extract[P]
  val (assignQ, retrieveQ, patTargetQ) = extract[Q]
  val (assignR, retrieveR, patTargetR) = extract[R]
  val (assignS, retrieveS, patTargetS) = extract[S]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH, fI -> patTargetI, fJ -> patTargetJ, fK -> patTargetK, fL -> patTargetL, fM -> patTargetM, fN -> patTargetN, fO -> patTargetO, fP -> patTargetP, fQ -> patTargetQ, fR -> patTargetR, fS -> patTargetS)
  new JsonCodec[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)), assignI(aI(x)), assignJ(aJ(x)), assignK(aK(x)), assignL(aL(x)), assignM(aM(x)), assignN(aN(x)), assignO(aO(x)), assignP(aP(x)), assignQ(aQ(x)), assignR(aR(x)), assignS(aS(x)))
    def decode(x: JValue): Option[TT] =
      pattern.matches(x) map { results =>
        val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results), retrieveI(results), retrieveJ(results), retrieveK(results), retrieveL(results), retrieveM(results), retrieveN(results), retrieveO(results), retrieveP(results), retrieveQ(results), retrieveR(results), retrieveS(results))
        try {
          ctor.newInstance(params: _*).asInstanceOf[TT]
        } catch {
          case e: java.lang.reflect.InvocationTargetException => throw e.getCause
        }
      }
  }
}
def build[A: JsonCodecOrOption: Manifest, B: JsonCodecOrOption: Manifest, C: JsonCodecOrOption: Manifest, D: JsonCodecOrOption: Manifest, E: JsonCodecOrOption: Manifest, F: JsonCodecOrOption: Manifest, G: JsonCodecOrOption: Manifest, H: JsonCodecOrOption: Manifest, I: JsonCodecOrOption: Manifest, J: JsonCodecOrOption: Manifest, K: JsonCodecOrOption: Manifest, L: JsonCodecOrOption: Manifest, M: JsonCodecOrOption: Manifest, N: JsonCodecOrOption: Manifest, O: JsonCodecOrOption: Manifest, P: JsonCodecOrOption: Manifest, Q: JsonCodecOrOption: Manifest, R: JsonCodecOrOption: Manifest, S: JsonCodecOrOption: Manifest, T: JsonCodecOrOption: Manifest](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H, fI: String, aI: TT => I, fJ: String, aJ: TT => J, fK: String, aK: TT => K, fL: String, aL: TT => L, fM: String, aM: TT => M, fN: String, aN: TT => N, fO: String, aO: TT => O, fP: String, aP: TT => P, fQ: String, aQ: TT => Q, fR: String, aR: TT => R, fS: String, aS: TT => S, fT: String, aT: TT => T): JsonCodec[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H], t[I], t[J], t[K], t[L], t[M], t[N], t[O], t[P], t[Q], t[R], t[S], t[T])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val (assignI, retrieveI, patTargetI) = extract[I]
  val (assignJ, retrieveJ, patTargetJ) = extract[J]
  val (assignK, retrieveK, patTargetK) = extract[K]
  val (assignL, retrieveL, patTargetL) = extract[L]
  val (assignM, retrieveM, patTargetM) = extract[M]
  val (assignN, retrieveN, patTargetN) = extract[N]
  val (assignO, retrieveO, patTargetO) = extract[O]
  val (assignP, retrieveP, patTargetP) = extract[P]
  val (assignQ, retrieveQ, patTargetQ) = extract[Q]
  val (assignR, retrieveR, patTargetR) = extract[R]
  val (assignS, retrieveS, patTargetS) = extract[S]
  val (assignT, retrieveT, patTargetT) = extract[T]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH, fI -> patTargetI, fJ -> patTargetJ, fK -> patTargetK, fL -> patTargetL, fM -> patTargetM, fN -> patTargetN, fO -> patTargetO, fP -> patTargetP, fQ -> patTargetQ, fR -> patTargetR, fS -> patTargetS, fT -> patTargetT)
  new JsonCodec[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)), assignI(aI(x)), assignJ(aJ(x)), assignK(aK(x)), assignL(aL(x)), assignM(aM(x)), assignN(aN(x)), assignO(aO(x)), assignP(aP(x)), assignQ(aQ(x)), assignR(aR(x)), assignS(aS(x)), assignT(aT(x)))
    def decode(x: JValue): Option[TT] =
      pattern.matches(x) map { results =>
        val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results), retrieveI(results), retrieveJ(results), retrieveK(results), retrieveL(results), retrieveM(results), retrieveN(results), retrieveO(results), retrieveP(results), retrieveQ(results), retrieveR(results), retrieveS(results), retrieveT(results))
        try {
          ctor.newInstance(params: _*).asInstanceOf[TT]
        } catch {
          case e: java.lang.reflect.InvocationTargetException => throw e.getCause
        }
      }
  }
}
def build[A: JsonCodecOrOption: Manifest, B: JsonCodecOrOption: Manifest, C: JsonCodecOrOption: Manifest, D: JsonCodecOrOption: Manifest, E: JsonCodecOrOption: Manifest, F: JsonCodecOrOption: Manifest, G: JsonCodecOrOption: Manifest, H: JsonCodecOrOption: Manifest, I: JsonCodecOrOption: Manifest, J: JsonCodecOrOption: Manifest, K: JsonCodecOrOption: Manifest, L: JsonCodecOrOption: Manifest, M: JsonCodecOrOption: Manifest, N: JsonCodecOrOption: Manifest, O: JsonCodecOrOption: Manifest, P: JsonCodecOrOption: Manifest, Q: JsonCodecOrOption: Manifest, R: JsonCodecOrOption: Manifest, S: JsonCodecOrOption: Manifest, T: JsonCodecOrOption: Manifest, U: JsonCodecOrOption: Manifest](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H, fI: String, aI: TT => I, fJ: String, aJ: TT => J, fK: String, aK: TT => K, fL: String, aL: TT => L, fM: String, aM: TT => M, fN: String, aN: TT => N, fO: String, aO: TT => O, fP: String, aP: TT => P, fQ: String, aQ: TT => Q, fR: String, aR: TT => R, fS: String, aS: TT => S, fT: String, aT: TT => T, fU: String, aU: TT => U): JsonCodec[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H], t[I], t[J], t[K], t[L], t[M], t[N], t[O], t[P], t[Q], t[R], t[S], t[T], t[U])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val (assignI, retrieveI, patTargetI) = extract[I]
  val (assignJ, retrieveJ, patTargetJ) = extract[J]
  val (assignK, retrieveK, patTargetK) = extract[K]
  val (assignL, retrieveL, patTargetL) = extract[L]
  val (assignM, retrieveM, patTargetM) = extract[M]
  val (assignN, retrieveN, patTargetN) = extract[N]
  val (assignO, retrieveO, patTargetO) = extract[O]
  val (assignP, retrieveP, patTargetP) = extract[P]
  val (assignQ, retrieveQ, patTargetQ) = extract[Q]
  val (assignR, retrieveR, patTargetR) = extract[R]
  val (assignS, retrieveS, patTargetS) = extract[S]
  val (assignT, retrieveT, patTargetT) = extract[T]
  val (assignU, retrieveU, patTargetU) = extract[U]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH, fI -> patTargetI, fJ -> patTargetJ, fK -> patTargetK, fL -> patTargetL, fM -> patTargetM, fN -> patTargetN, fO -> patTargetO, fP -> patTargetP, fQ -> patTargetQ, fR -> patTargetR, fS -> patTargetS, fT -> patTargetT, fU -> patTargetU)
  new JsonCodec[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)), assignI(aI(x)), assignJ(aJ(x)), assignK(aK(x)), assignL(aL(x)), assignM(aM(x)), assignN(aN(x)), assignO(aO(x)), assignP(aP(x)), assignQ(aQ(x)), assignR(aR(x)), assignS(aS(x)), assignT(aT(x)), assignU(aU(x)))
    def decode(x: JValue): Option[TT] =
      pattern.matches(x) map { results =>
        val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results), retrieveI(results), retrieveJ(results), retrieveK(results), retrieveL(results), retrieveM(results), retrieveN(results), retrieveO(results), retrieveP(results), retrieveQ(results), retrieveR(results), retrieveS(results), retrieveT(results), retrieveU(results))
        try {
          ctor.newInstance(params: _*).asInstanceOf[TT]
        } catch {
          case e: java.lang.reflect.InvocationTargetException => throw e.getCause
        }
      }
  }
}
def build[A: JsonCodecOrOption: Manifest, B: JsonCodecOrOption: Manifest, C: JsonCodecOrOption: Manifest, D: JsonCodecOrOption: Manifest, E: JsonCodecOrOption: Manifest, F: JsonCodecOrOption: Manifest, G: JsonCodecOrOption: Manifest, H: JsonCodecOrOption: Manifest, I: JsonCodecOrOption: Manifest, J: JsonCodecOrOption: Manifest, K: JsonCodecOrOption: Manifest, L: JsonCodecOrOption: Manifest, M: JsonCodecOrOption: Manifest, N: JsonCodecOrOption: Manifest, O: JsonCodecOrOption: Manifest, P: JsonCodecOrOption: Manifest, Q: JsonCodecOrOption: Manifest, R: JsonCodecOrOption: Manifest, S: JsonCodecOrOption: Manifest, T: JsonCodecOrOption: Manifest, U: JsonCodecOrOption: Manifest, V: JsonCodecOrOption: Manifest](fA: String, aA: TT => A, fB: String, aB: TT => B, fC: String, aC: TT => C, fD: String, aD: TT => D, fE: String, aE: TT => E, fF: String, aF: TT => F, fG: String, aG: TT => G, fH: String, aH: TT => H, fI: String, aI: TT => I, fJ: String, aJ: TT => J, fK: String, aK: TT => K, fL: String, aL: TT => L, fM: String, aM: TT => M, fN: String, aN: TT => N, fO: String, aO: TT => O, fP: String, aP: TT => P, fQ: String, aQ: TT => Q, fR: String, aR: TT => R, fS: String, aS: TT => S, fT: String, aT: TT => T, fU: String, aU: TT => U, fV: String, aV: TT => V): JsonCodec[TT] = {
  val ctor = findCtor(t[TT])(t[A], t[B], t[C], t[D], t[E], t[F], t[G], t[H], t[I], t[J], t[K], t[L], t[M], t[N], t[O], t[P], t[Q], t[R], t[S], t[T], t[U], t[V])
  val (assignA, retrieveA, patTargetA) = extract[A]
  val (assignB, retrieveB, patTargetB) = extract[B]
  val (assignC, retrieveC, patTargetC) = extract[C]
  val (assignD, retrieveD, patTargetD) = extract[D]
  val (assignE, retrieveE, patTargetE) = extract[E]
  val (assignF, retrieveF, patTargetF) = extract[F]
  val (assignG, retrieveG, patTargetG) = extract[G]
  val (assignH, retrieveH, patTargetH) = extract[H]
  val (assignI, retrieveI, patTargetI) = extract[I]
  val (assignJ, retrieveJ, patTargetJ) = extract[J]
  val (assignK, retrieveK, patTargetK) = extract[K]
  val (assignL, retrieveL, patTargetL) = extract[L]
  val (assignM, retrieveM, patTargetM) = extract[M]
  val (assignN, retrieveN, patTargetN) = extract[N]
  val (assignO, retrieveO, patTargetO) = extract[O]
  val (assignP, retrieveP, patTargetP) = extract[P]
  val (assignQ, retrieveQ, patTargetQ) = extract[Q]
  val (assignR, retrieveR, patTargetR) = extract[R]
  val (assignS, retrieveS, patTargetS) = extract[S]
  val (assignT, retrieveT, patTargetT) = extract[T]
  val (assignU, retrieveU, patTargetU) = extract[U]
  val (assignV, retrieveV, patTargetV) = extract[V]
  val pattern = PObject(fA -> patTargetA, fB -> patTargetB, fC -> patTargetC, fD -> patTargetD, fE -> patTargetE, fF -> patTargetF, fG -> patTargetG, fH -> patTargetH, fI -> patTargetI, fJ -> patTargetJ, fK -> patTargetK, fL -> patTargetL, fM -> patTargetM, fN -> patTargetN, fO -> patTargetO, fP -> patTargetP, fQ -> patTargetQ, fR -> patTargetR, fS -> patTargetS, fT -> patTargetT, fU -> patTargetU, fV -> patTargetV)
  new JsonCodec[TT] {
    def encode(x: TT) = pattern.generate(assignA(aA(x)), assignB(aB(x)), assignC(aC(x)), assignD(aD(x)), assignE(aE(x)), assignF(aF(x)), assignG(aG(x)), assignH(aH(x)), assignI(aI(x)), assignJ(aJ(x)), assignK(aK(x)), assignL(aL(x)), assignM(aM(x)), assignN(aN(x)), assignO(aO(x)), assignP(aP(x)), assignQ(aQ(x)), assignR(aR(x)), assignS(aS(x)), assignT(aT(x)), assignU(aU(x)), assignV(aV(x)))
    def decode(x: JValue): Option[TT] =
      pattern.matches(x) map { results =>
        val params = Array(retrieveA(results), retrieveB(results), retrieveC(results), retrieveD(results), retrieveE(results), retrieveF(results), retrieveG(results), retrieveH(results), retrieveI(results), retrieveJ(results), retrieveK(results), retrieveL(results), retrieveM(results), retrieveN(results), retrieveO(results), retrieveP(results), retrieveQ(results), retrieveR(results), retrieveS(results), retrieveT(results), retrieveU(results), retrieveV(results))
        try {
          ctor.newInstance(params: _*).asInstanceOf[TT]
        } catch {
          case e: java.lang.reflect.InvocationTargetException => throw e.getCause
        }
      }
  }
}
  }

  def apply[TT: Manifest] = new FixedSimpleJsonCodecBuilder[TT]
}
